/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class PluginsUsagesCollector
extends ApplicationUsagesCollector {
    PluginsUsagesCollector() {
    }

    @Override
    @NotNull
    public String getGroupId() {
        if ("plugins" == null) {
            PluginsUsagesCollector.$$$reportNull$$$0(0);
        }
        return "plugins";
    }

    @Override
    @NotNull
    public Set<MetricEvent> getMetrics() {
        THashSet result2 = new THashSet();
        for (String id : PluginManagerCore.disabledPlugins()) {
            PluginInfo info = PluginInfoDetectorKt.getPluginInfoById(PluginId.findId((String[])new String[]{id}));
            FeatureUsageData data = new FeatureUsageData().addPluginInfo(info);
            result2.add(MetricEventFactoryKt.newMetric("disabled.plugin", data));
        }
        Object[] plugins2 = PluginManagerCore.getPlugins();
        List nonBundledEnabledPlugins = ContainerUtil.filter((Object[])plugins2, d -> d.isEnabled() && !d.isBundled());
        for (IdeaPluginDescriptor descriptor2 : nonBundledEnabledPlugins) {
            PluginInfo info = PluginInfoDetectorKt.getPluginInfoByDescriptor(descriptor2);
            FeatureUsageData data = new FeatureUsageData().addPluginInfo(info);
            result2.add(MetricEventFactoryKt.newMetric("enabled.not.bundled.plugin", data));
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            PluginsUsagesCollector.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/collectors/fus/plugins/PluginsUsagesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

