/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class SmartPointerListModel<T>
extends AbstractListModel<T>
implements ModelDiff.Model<T> {
    private final CollectionListModel<Object> myDelegate = new CollectionListModel(new Object[0]);

    SmartPointerListModel() {
        this.myDelegate.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                SmartPointerListModel.this.fireIntervalAdded(e.getSource(), e.getIndex0(), e.getIndex1());
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                SmartPointerListModel.this.fireIntervalRemoved(e.getSource(), e.getIndex0(), e.getIndex1());
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                SmartPointerListModel.this.fireContentsChanged(e.getSource(), e.getIndex0(), e.getIndex1());
            }
        });
    }

    @Override
    public int getSize() {
        return this.myDelegate.getSize();
    }

    @Override
    public T getElementAt(int index) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.unwrap(this.myDelegate.getElementAt(index));
    }

    private Object wrap(T element) {
        return TreeAnchorizer.getService().createAnchor(element);
    }

    private T unwrap(Object at) {
        return (T)TreeAnchorizer.getService().retrieveElement(at);
    }

    @Override
    public void addToModel(int idx, T element) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDelegate.add(Math.min(idx, this.getSize()), this.wrap(element));
    }

    @Override
    public void addAllToModel(int index, List<? extends T> elements2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDelegate.addAll(Math.min(index, this.getSize()), ContainerUtil.map(elements2, this::wrap));
    }

    @Override
    public void removeRangeFromModel(int start2, int end) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (start2 < this.getSize() && !this.isEmpty()) {
            this.myDelegate.removeRange(start2, Math.min(end, this.getSize() - 1));
        }
    }

    boolean isEmpty() {
        return this.getSize() == 0;
    }

    void removeAll() {
        this.myDelegate.removeAll();
    }

    boolean contains(T elem) {
        return this.getItems().indexOf(elem) >= 0;
    }

    List<T> getItems() {
        return ContainerUtil.map((Collection)this.myDelegate.getItems(), this::unwrap);
    }
}

