/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.SetShortcutAction;
import com.intellij.ide.actions.searcheverywhere.CheckBoxSearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionSearchEverywhereContributor
implements SearchEverywhereContributor<GotoActionModel.MatchedValue> {
    private static final Logger LOG = Logger.getInstance(ActionSearchEverywhereContributor.class);
    private final Project myProject;
    private final Component myContextComponent;
    private final GotoActionModel myModel;
    private final GotoActionItemProvider myProvider;
    private boolean myDisabledActions;

    public ActionSearchEverywhereContributor(Project project, Component contextComponent, Editor editor) {
        this.myProject = project;
        this.myContextComponent = contextComponent;
        this.myModel = new GotoActionModel(project, contextComponent, editor);
        this.myProvider = new GotoActionItemProvider(this.myModel);
    }

    @NotNull
    public String getGroupName() {
        if ("Actions" == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        return "Actions";
    }

    @NotNull
    public String getAdvertisement() {
        ShortcutSet altEnterShortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)"ShowIntentionActions");
        String altEnter = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)altEnterShortcutSet);
        String string = "Press " + altEnter + " to assign a shortcut";
        if (string == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String includeNonProjectItemsText() {
        return IdeBundle.message((String)"checkbox.disabled.included", (Object[])new Object[0]);
    }

    public int getSortWeight() {
        return 400;
    }

    public boolean isShownInSeparateTab() {
        return true;
    }

    public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super GotoActionModel.MatchedValue> consumer) {
        if (pattern == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)pattern)) {
            return;
        }
        this.myProvider.filterElements(pattern, (Processor<? super GotoActionModel.MatchedValue>)((Processor)element -> {
            if (progressIndicator.isCanceled()) {
                return false;
            }
            if (!this.myDisabledActions && element.value instanceof GotoActionModel.ActionWrapper && !((GotoActionModel.ActionWrapper)element.value).isAvailable()) {
                return true;
            }
            if (element == null) {
                LOG.error("Null action has been returned from model");
                return true;
            }
            return consumer.process(element);
        }));
    }

    @NotNull
    public List<AnAction> getActions(final @NotNull Runnable onChanged) {
        if (onChanged == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        List<1> list2 = Collections.singletonList(new CheckBoxSearchEverywhereToggleAction(this.includeNonProjectItemsText()){

            public boolean isEverywhere() {
                return ActionSearchEverywhereContributor.this.myDisabledActions;
            }

            public void setEverywhere(boolean state) {
                ActionSearchEverywhereContributor.this.myDisabledActions = state;
                onChanged.run();
            }
        });
        if (list2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public ListCellRenderer<? super GotoActionModel.MatchedValue> getElementsRenderer() {
        GotoActionModel.GotoActionListCellRenderer gotoActionListCellRenderer = new GotoActionModel.GotoActionListCellRenderer((Function<? super OptionDescription, String>)((Function)this.myModel::getGroupName), true);
        if (gotoActionListCellRenderer == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        return gotoActionListCellRenderer;
    }

    public boolean showInFindResults() {
        return false;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = ActionSearchEverywhereContributor.class.getSimpleName();
        if (string == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(8);
        }
        return string;
    }

    public Object getDataForItem(@NotNull GotoActionModel.MatchedValue element, @NotNull String dataId) {
        AnAction action2;
        if (element == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(9);
        }
        if (dataId == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(10);
        }
        if (SetShortcutAction.SELECTED_ACTION.is(dataId)) {
            return ActionSearchEverywhereContributor.getAction(element);
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && (action2 = ActionSearchEverywhereContributor.getAction(element)) != null) {
            String description = action2.getTemplatePresentation().getDescription();
            if (UISettings.getInstance().getShowInplaceCommentsInternal()) {
                String presentableId = StringUtil.notNullize((String)ActionManager.getInstance().getId(action2), (String)("class: " + action2.getClass().getName()));
                return String.format("[%s] %s", presentableId, StringUtil.notNullize((String)description));
            }
            return description;
        }
        return null;
    }

    public boolean processSelectedItem(@NotNull GotoActionModel.MatchedValue item, int modifiers, @NotNull String text2) {
        if (item == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(12);
        }
        if (modifiers == 8) {
            this.showAssignShortcutDialog(item);
            return true;
        }
        Object selected2 = item.value;
        if (selected2 instanceof BooleanOptionDescription) {
            BooleanOptionDescription option;
            option.setOptionState(!(option = (BooleanOptionDescription)selected2).isOptionEnabled());
            return false;
        }
        GotoActionAction.openOptionOrPerformAction(selected2, text2, this.myProject, this.myContextComponent);
        boolean inplaceChange = selected2 instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)selected2).getAction() instanceof ToggleAction;
        return !inplaceChange;
    }

    @Nullable
    private static AnAction getAction(@NotNull GotoActionModel.MatchedValue element) {
        Object value;
        if (element == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(13);
        }
        if ((value = element.value) instanceof GotoActionModel.ActionWrapper) {
            value = ((GotoActionModel.ActionWrapper)value).getAction();
        }
        return value instanceof AnAction ? (AnAction)value : null;
    }

    private void showAssignShortcutDialog(@NotNull GotoActionModel.MatchedValue value) {
        AnAction action2;
        if (value == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(14);
        }
        if ((action2 = ActionSearchEverywhereContributor.getAction(value)) == null) {
            return;
        }
        String id = ActionManager.getInstance().getId(action2);
        Keymap activeKeymap = Optional.ofNullable(KeymapManager.getInstance()).map(KeymapManager::getActiveKeymap).orElse(null);
        if (activeKeymap == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Window window;
            Window window2 = window = this.myProject != null ? WindowManager.getInstance().suggestParentWindow(this.myProject) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window == null) {
                return;
            }
            KeymapPanel.addKeyboardShortcut(id, ActionShortcutRestrictions.getInstance().getForActionId(id), activeKeymap, window, new QuickList[0]);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ActionSearchEverywhereContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdvertisement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ActionSearchEverywhereContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showAssignShortcutDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<GotoActionModel.MatchedValue> {
        @NotNull
        public SearchEverywhereContributor<GotoActionModel.MatchedValue> createContributor(@NotNull AnActionEvent initEvent) {
            if (initEvent == null) {
                Factory.$$$reportNull$$$0(0);
            }
            ActionSearchEverywhereContributor actionSearchEverywhereContributor = new ActionSearchEverywhereContributor(initEvent.getProject(), (Component)initEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT), (Editor)initEvent.getData(CommonDataKeys.EDITOR));
            if (actionSearchEverywhereContributor == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return actionSearchEverywhereContributor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ActionSearchEverywhereContributor$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ActionSearchEverywhereContributor$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContributor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createContributor";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

