/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.navigator.RootReason;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.IntList;
import com.intellij.diagnostic.hprof.util.TruncatingPrintBuffer;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0005\u001d\u001e\u001f !B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree;", "", "disposedObjectsIDsSet", "Lgnu/trove/TIntHashSet;", "parentMapping", "Lcom/intellij/diagnostic/hprof/util/IntList;", "sizesMapping", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "allObjectsOfClass", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "(Lgnu/trove/TIntHashSet;Lcom/intellij/diagnostic/hprof/util/IntList;Lcom/intellij/diagnostic/hprof/util/IntList;Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;)V", "cachedSize", "", "Ljava/lang/Integer;", "countOfIgnoredObjects", "topNode", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode;", "getDisposedDominatorNodes", "", "", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "printTree", "", "headLimit", "tailLimit", "registerObject", "", "objectId", "Companion", "Edge", "Node", "RegularNode", "RootNode", "intellij.platform.ide.impl"})
public final class GCRootPathsTree {
    private final RootNode topNode;
    private int countOfIgnoredObjects;
    private final Integer cachedSize;
    private final TIntHashSet disposedObjectsIDsSet;
    private final IntList parentMapping;
    private final IntList sizesMapping;
    private final ObjectNavigator nav;
    private final ClassDefinition allObjectsOfClass;
    private static final int MINIMUM_OBJECT_SIZE_FOR_REPORT = 10000000;
    private static final int MINIMUM_OBJECT_COUNT_FOR_REPORT = 10000;
    private static final int MINIMUM_OBJECT_COUNT_PERCENT = 10;
    private static final int MAX_TREE_DEPTH = 500;
    private static final int MAX_INDENT = 40;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void registerObject(int objectId) {
        int n;
        TIntArrayList gcPath = new TIntArrayList();
        int objectIterationId = objectId;
        int parentId = this.parentMapping.get(objectIterationId);
        for (int count = 0; count < 500 && parentId != objectIterationId; ++count) {
            gcPath.add(objectIterationId);
            objectIterationId = parentId;
            parentId = this.parentMapping.get(objectIterationId);
        }
        if (parentId != objectIterationId) {
            int n2 = this.countOfIgnoredObjects;
            this.countOfIgnoredObjects = n2 + 1;
            return;
        }
        gcPath.add(objectIterationId);
        if (this.cachedSize != null) {
            n = this.cachedSize;
        } else {
            this.nav.goTo(objectId, ObjectNavigator.ReferenceResolution.NO_REFERENCES);
            n = this.nav.getObjectSize();
        }
        int size = n;
        Node currentNode = this.topNode;
        int n3 = gcPath.size() - 1;
        boolean bl = false;
        while (n3 >= 0) {
            void i;
            int id = gcPath.get((int)i);
            ClassDefinition classDefinition = this.nav.getClassForObjectId(id);
            currentNode = currentNode.addEdge(id, size, this.sizesMapping.get(id), classDefinition, this.disposedObjectsIDsSet.contains(id));
            --i;
        }
    }

    @NotNull
    public final String printTree(int headLimit, int tailLimit) {
        StringBuilder result2 = new StringBuilder();
        if (this.countOfIgnoredObjects > 0) {
            result2.append("Ignored " + this.countOfIgnoredObjects + " too-deep objects\n");
        }
        Function1 rootReasonGetter2 = (Function1)new Function1<Integer, String>(this){
            final /* synthetic */ GCRootPathsTree this$0;

            @NotNull
            public final String invoke(int id) {
                Object object = GCRootPathsTree.access$getNav$p(this.this$0).getRootReasonForObjectId(id);
                if (object == null || (object = ((RootReason)object).getDescription()) == null) {
                    object = "<Couldn't find root description>";
                }
                return object;
            }
            {
                this.this$0 = gCRootPathsTree;
                super(1);
            }
        };
        result2.append(this.topNode.createHotPathReport((Function1<? super Integer, String>)rootReasonGetter2, headLimit, tailLimit));
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public final Map<ClassDefinition, List<RegularNode>> getDisposedDominatorNodes() {
        HashMap result2 = new HashMap();
        this.topNode.collectDisposedDominatorNodes(result2);
        return result2;
    }

    public GCRootPathsTree(@NotNull TIntHashSet disposedObjectsIDsSet, @NotNull IntList parentMapping, @NotNull IntList sizesMapping, @NotNull ObjectNavigator nav, @Nullable ClassDefinition allObjectsOfClass) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)disposedObjectsIDsSet, (String)"disposedObjectsIDsSet");
        Intrinsics.checkParameterIsNotNull((Object)parentMapping, (String)"parentMapping");
        Intrinsics.checkParameterIsNotNull((Object)sizesMapping, (String)"sizesMapping");
        Intrinsics.checkParameterIsNotNull((Object)nav, (String)"nav");
        this.disposedObjectsIDsSet = disposedObjectsIDsSet;
        this.parentMapping = parentMapping;
        this.sizesMapping = sizesMapping;
        this.nav = nav;
        this.allObjectsOfClass = allObjectsOfClass;
        this.topNode = new RootNode();
        GCRootPathsTree gCRootPathsTree = this;
        ClassDefinition classDefinition = this.allObjectsOfClass;
        if (classDefinition != null) {
            ClassDefinition classDefinition2 = classDefinition;
            GCRootPathsTree gCRootPathsTree2 = gCRootPathsTree;
            boolean bl = false;
            boolean bl2 = false;
            ClassDefinition it = classDefinition2;
            boolean bl3 = false;
            Integer n2 = this.allObjectsOfClass.isArray() ? null : Integer.valueOf(it.getInstanceSize());
            gCRootPathsTree = gCRootPathsTree2;
            n = n2;
        } else {
            n = null;
        }
        gCRootPathsTree.cachedSize = n;
    }

    public static final /* synthetic */ ObjectNavigator access$getNav$p(GCRootPathsTree $this) {
        return $this.nav;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J0\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Node;", "", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "disposed", "", "intellij.platform.ide.impl"})
    public static interface Node {
        @NotNull
        public Node addEdge(int var1, int var2, int var3, @NotNull ClassDefinition var4, boolean var5);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "disposed", "", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;Z)V", "getClassDefinition", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getDisposed", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class Edge {
        @NotNull
        private final ClassDefinition classDefinition;
        private final boolean disposed;

        @NotNull
        public final ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        public Edge(@NotNull ClassDefinition classDefinition, boolean disposed) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
            this.disposed = disposed;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.classDefinition;
        }

        public final boolean component2() {
            return this.disposed;
        }

        @NotNull
        public final Edge copy(@NotNull ClassDefinition classDefinition, boolean disposed) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            return new Edge(classDefinition, disposed);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, ClassDefinition classDefinition, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = edge.classDefinition;
            }
            if ((n & 2) != 0) {
                bl = edge.disposed;
            }
            return edge.copy(classDefinition, bl);
        }

        @NotNull
        public String toString() {
            return "Edge(classDefinition=" + this.classDefinition + ", disposed=" + this.disposed + ")";
        }

        public int hashCode() {
            ClassDefinition classDefinition = this.classDefinition;
            int n = (classDefinition != null ? ((Object)classDefinition).hashCode() : 0) * 31;
            int n2 = this.disposed ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Edge)) break block3;
                    Edge edge = (Edge)object;
                    if (!Intrinsics.areEqual((Object)this.classDefinition, (Object)edge.classDefinition) || !(this.disposed == edge.disposed)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020#2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000&0%R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Node;", "()V", "edges", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Ljava/util/HashMap;", "setEdges", "(Ljava/util/HashMap;)V", "instances", "Lgnu/trove/TIntHashSet;", "getInstances", "()Lgnu/trove/TIntHashSet;", "pathsCount", "", "getPathsCount", "()I", "setPathsCount", "(I)V", "pathsSize", "getPathsSize", "setPathsSize", "totalSizeInDwords", "getTotalSizeInDwords", "setTotalSizeInDwords", "addEdge", "objectId", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "disposed", "", "collectDisposedDominatorNodes", "", "result", "", "", "intellij.platform.ide.impl"})
    public static final class RegularNode
    implements Node {
        @Nullable
        private HashMap<Edge, RegularNode> edges;
        private int pathsCount;
        private int pathsSize;
        private int totalSizeInDwords;
        @NotNull
        private final TIntHashSet instances = new TIntHashSet(1);

        @Nullable
        public final HashMap<Edge, RegularNode> getEdges() {
            return this.edges;
        }

        public final void setEdges(@Nullable HashMap<Edge, RegularNode> hashMap) {
            this.edges = hashMap;
        }

        public final int getPathsCount() {
            return this.pathsCount;
        }

        public final void setPathsCount(int n) {
            this.pathsCount = n;
        }

        public final int getPathsSize() {
            return this.pathsSize;
        }

        public final void setPathsSize(int n) {
            this.pathsSize = n;
        }

        public final int getTotalSizeInDwords() {
            return this.totalSizeInDwords;
        }

        public final void setTotalSizeInDwords(int n) {
            this.totalSizeInDwords = n;
        }

        @NotNull
        public final TIntHashSet getInstances() {
            return this.instances;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, boolean disposed) {
            Object object;
            void $this$getOrPut$iv22;
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            HashMap<Edge, RegularNode> localEdges = this.edges;
            if (localEdges == null) {
                this.edges = localEdges = new HashMap(1);
            }
            Map map2 = localEdges;
            Edge key$iv = new Edge(classDefinition, disposed);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv22.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                RegularNode answer$iv = new RegularNode();
                $this$getOrPut$iv22.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            RegularNode node = (RegularNode)object;
            int $this$getOrPut$iv22 = node.pathsCount;
            node.pathsCount = $this$getOrPut$iv22 + 1;
            node.pathsSize = (long)node.pathsSize + (long)objectSize > (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (node.pathsSize += objectSize);
            boolean added = node.instances.add(objectId);
            if (added) {
                node.totalSizeInDwords = (long)node.totalSizeInDwords + (long)subgraphSizeInDwords > (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (node.totalSizeInDwords += subgraphSizeInDwords);
            }
            return node;
        }

        /*
         * WARNING - void declaration
         */
        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            ArrayDeque<RegularNode> stack = new ArrayDeque<RegularNode>();
            stack.push(this);
            block0: while (true) {
                Collection collection = stack;
                boolean bl = false;
                if (!(!collection.isEmpty())) break;
                RegularNode currentNode = (RegularNode)stack.pop();
                HashMap<Edge, RegularNode> hashMap = currentNode.edges;
                if (hashMap == null) continue;
                Map $this$forEach$iv = hashMap;
                boolean $i$f$forEach = false;
                Map map2 = $this$forEach$iv;
                boolean bl2 = false;
                Iterator iterator = map2.entrySet().iterator();
                while (true) {
                    Map.Entry element$iv;
                    if (!iterator.hasNext()) continue block0;
                    Map.Entry $dstr$edge$childNode = element$iv = iterator.next();
                    boolean bl3 = false;
                    Object object = $dstr$edge$childNode;
                    boolean bl4 = false;
                    Edge edge = (Edge)object.getKey();
                    object = $dstr$edge$childNode;
                    bl4 = false;
                    RegularNode childNode = (RegularNode)object.getValue();
                    if (edge.getDisposed()) {
                        Object object2;
                        void $this$getOrPut$iv;
                        object = result2;
                        ClassDefinition key$iv = edge.getClassDefinition();
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl5 = false;
                            boolean bl6 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        ((List)object2).add(childNode);
                        continue;
                    }
                    stack.push(childNode);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0002J \u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00170\u0016J*\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fJu\u0010\u001e\u001a\u00020\u00142\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020 0\u001b2\b\u0010!\u001a\u0004\u0018\u00010\f2\b\u0010\"\u001a\u0004\u0018\u00010\f2\b\u0010#\u001a\u0004\u0018\u00010\f2\b\u0010$\u001a\u0004\u0018\u00010\f2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010*R#\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006,"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Node;", "()V", "edges", "Lgnu/trove/TIntObjectHashMap;", "Lkotlin/Pair;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getEdges", "()Lgnu/trove/TIntObjectHashMap;", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "disposed", "", "calculateTotalInstanceCount", "collectDisposedDominatorNodes", "", "result", "", "", "createHotPathReport", "", "rootReasonGetter", "Lkotlin/Function1;", "headLimit", "tailLimit", "printReportLine", "printFunc", "", "pathsCount", "percent", "instanceCount", "instanceSize", "subgraphSize", "", "lastInPath", "indent", "text", "(Lkotlin/jvm/functions/Function1;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;ZLjava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;)V", "StackEntry", "intellij.platform.ide.impl"})
    public static final class RootNode
    implements Node {
        @NotNull
        private final TIntObjectHashMap<Pair<RegularNode, ClassDefinition>> edges = new TIntObjectHashMap();

        @NotNull
        public final TIntObjectHashMap<Pair<RegularNode, ClassDefinition>> getEdges() {
            return this.edges;
        }

        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, boolean disposed) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            Pair pair = (Pair)this.edges.get(objectId);
            RegularNode nullableNode = pair != null ? (RegularNode)pair.getFirst() : null;
            RegularNode node = null;
            if (nullableNode != null) {
                node = nullableNode;
            } else {
                RegularNode newNode = new RegularNode();
                Pair pair2 = new Pair((Object)newNode, (Object)classDefinition);
                newNode.getInstances().add(objectId);
                this.edges.put(objectId, (Object)pair2);
                node = newNode;
                node.setTotalSizeInDwords(subgraphSizeInDwords);
            }
            RegularNode regularNode = node;
            int n = regularNode.getPathsCount();
            regularNode.setPathsCount(n + 1);
            if ((long)node.getPathsSize() + (long)objectSize > (long)Integer.MAX_VALUE) {
                node.setPathsSize(Integer.MAX_VALUE);
            } else {
                RegularNode regularNode2 = node;
                regularNode2.setPathsSize(regularNode2.getPathsSize() + objectSize);
            }
            return node;
        }

        /*
         * WARNING - void declaration
         */
        private final int calculateTotalInstanceCount() {
            void result2;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            this.edges.forEachValue((TObjectProcedure)new TObjectProcedure<Pair<? extends RegularNode, ? extends ClassDefinition>>((Ref.IntRef)result2){
                final /* synthetic */ Ref.IntRef $result;

                public final boolean execute(Pair<RegularNode, ClassDefinition> $dstr$node$_u24__u24) {
                    RegularNode node = (RegularNode)$dstr$node$_u24__u24.component1();
                    this.$result.element += node.getPathsCount();
                    return true;
                }
                {
                    this.$result = intRef;
                }
            });
            return result2.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String createHotPathReport(@NotNull Function1<? super Integer, String> rootReasonGetter2, int headLimit, int tailLimit) {
            Object node;
            Object object;
            void $this$filterIndexedTo$iv$iv;
            Iterator iterator;
            Intrinsics.checkParameterIsNotNull(rootReasonGetter2, (String)"rootReasonGetter");
            boolean bl = false;
            List rootList = new ArrayList();
            StringBuilder result2 = new StringBuilder();
            this.edges.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Pair<? extends RegularNode, ? extends ClassDefinition>>(rootList){
                final /* synthetic */ List $rootList;

                public final boolean execute(int objectId, Pair<RegularNode, ClassDefinition> $dstr$node$classDef) {
                    RegularNode node = (RegularNode)$dstr$node$classDef.component1();
                    ClassDefinition classDef = (ClassDefinition)$dstr$node$classDef.component2();
                    return this.$rootList.add(new Triple((Object)objectId, (Object)node, (Object)classDef));
                }
                {
                    this.$rootList = list2;
                }
            });
            List $this$sortByDescending$iv = rootList;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                List list2 = $this$sortByDescending$iv;
                boolean bl2 = false;
                iterator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Triple it = (Triple)b;
                        boolean bl2 = false;
                        Comparable comparable = Integer.valueOf(((RegularNode)it.getSecond()).getPathsSize());
                        it = (Triple)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Integer n = ((RegularNode)it.getSecond()).getPathsSize();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                };
                CollectionsKt.sortWith((List)list2, (Comparator)((Object)iterator));
            }
            int totalInstanceCount = this.calculateTotalInstanceCount();
            int minimumObjectsForReport = Math.min(10000, (int)(Math.ceil((double)totalInstanceCount / 100.0) * (double)10));
            Iterable $this$filterIndexed$iv = rootList;
            boolean $i$f$filterIndexed = false;
            iterator = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void $dstr$_u24__u24$node$_u24__u24;
                void element$iv$iv;
                int n = index$iv$iv$iv++;
                boolean bl3 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                object = item$iv$iv$iv;
                int index$iv$iv = n2;
                boolean bl4 = false;
                Triple triple = (Triple)element$iv$iv;
                int index = index$iv$iv;
                boolean bl5 = false;
                node = (RegularNode)$dstr$_u24__u24$node$_u24__u24.component2();
                if (!(index <= 1 || ((RegularNode)node).getPathsCount() >= minimumObjectsForReport || ((RegularNode)node).getPathsSize() >= 10000000)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Triple $dstr$rootObjectId$rootNode$rootObjectClass = (Triple)element$iv;
                boolean bl6 = false;
                int rootObjectId = ((Number)$dstr$rootObjectId$rootNode$rootObjectClass.component1()).intValue();
                RegularNode rootNode = (RegularNode)$dstr$rootObjectId$rootNode$rootObjectClass.component2();
                ClassDefinition rootObjectClass = (ClassDefinition)$dstr$rootObjectId$rootNode$rootObjectClass.component3();
                Function1 printFunc = (Function1)new Function1<String, Unit>(this, result2, rootReasonGetter2, totalInstanceCount, headLimit, tailLimit, minimumObjectsForReport){
                    final /* synthetic */ RootNode this$0;
                    final /* synthetic */ StringBuilder $result$inlined;
                    final /* synthetic */ Function1 $rootReasonGetter$inlined;
                    final /* synthetic */ int $totalInstanceCount$inlined;
                    final /* synthetic */ int $headLimit$inlined;
                    final /* synthetic */ int $tailLimit$inlined;
                    final /* synthetic */ int $minimumObjectsForReport$inlined;
                    {
                        this.this$0 = rootNode;
                        this.$result$inlined = stringBuilder;
                        this.$rootReasonGetter$inlined = function1;
                        this.$totalInstanceCount$inlined = n;
                        this.$headLimit$inlined = n2;
                        this.$tailLimit$inlined = n3;
                        this.$minimumObjectsForReport$inlined = n4;
                        super(1);
                    }

                    public final void invoke(@NotNull String s) {
                        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                        StringBuilder stringBuilder = this.$result$inlined;
                        boolean bl = false;
                        StringBuilder stringBuilder2 = stringBuilder.append(s);
                        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                        StringsKt.appendln((StringBuilder)stringBuilder2);
                    }
                };
                String rootReasonString = (String)rootReasonGetter2.invoke((Object)rootObjectId);
                int rootPercent = (int)(100.0 * (double)rootNode.getPathsCount() / (double)totalInstanceCount);
                Object object2 = result2;
                object = "ROOT: " + rootReasonString + ": " + rootNode.getPathsCount() + " objects (" + rootPercent + "%), " + HeapReportUtils.Companion.toShortStringAsSize(rootNode.getPathsSize());
                boolean bl7 = false;
                StringBuilder stringBuilder = ((StringBuilder)object2).append((String)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
                object2 = new TruncatingPrintBuffer(headLimit, tailLimit, (Function1<? super String, ? extends Object>)printFunc);
                boolean bl8 = false;
                Throwable throwable = null;
                try {
                    TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)object2;
                    boolean bl9 = false;
                    ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
                    stack.push(new StackEntry(new Edge(rootObjectClass, false), rootNode, "", ""));
                    while (!stack.isEmpty()) {
                        void $this$filterIndexedTo$iv$iv2;
                        HashMap<Edge, RegularNode> currentNodeEdges;
                        void classDefinition;
                        void indent;
                        void node2;
                        void edge;
                        Object bl5 = (StackEntry)stack.pop();
                        node = ((StackEntry)bl5).component1();
                        RegularNode regularNode = ((StackEntry)bl5).component2();
                        String string = ((StackEntry)bl5).component3();
                        String nextIndent = ((StackEntry)bl5).component4();
                        void var31_46 = edge;
                        bl5 = var31_46.component1();
                        boolean disposed = var31_46.component2();
                        this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>(buffer){

                            public final void invoke(@NotNull String p1) {
                                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                ((TruncatingPrintBuffer)this.receiver).println(p1);
                            }

                            public final KDeclarationContainer getOwner() {
                                return Reflection.getOrCreateKotlinClass(TruncatingPrintBuffer.class);
                            }

                            public final String getName() {
                                return "println";
                            }

                            public final String getSignature() {
                                return "println(Ljava/lang/String;)V";
                            }
                        }), node2.getPathsCount(), (int)(100.0 * (double)node2.getPathsCount() / (double)totalInstanceCount), node2.getInstances().size(), node2.getPathsSize(), (long)node2.getTotalSizeInDwords() * (long)4, node2.getEdges() == null, disposed, (String)indent, classDefinition.getPrettyName());
                        if (node2.getEdges() == null) {
                            continue;
                        }
                        Set<Map.Entry<Edge, RegularNode>> set = currentNodeEdges.entrySet();
                        Intrinsics.checkExpressionValueIsNotNull(set, (String)"currentNodeEdges\n                .entries");
                        Iterable $this$sortedByDescending$iv = set;
                        boolean $i$f$sortedByDescending = false;
                        Iterable iterable = $this$sortedByDescending$iv;
                        boolean bl10 = false;
                        Comparator comparator2 = new Comparator<T>(){

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                Map.Entry it = (Map.Entry)b;
                                boolean bl2 = false;
                                Comparable comparable = Integer.valueOf(((RegularNode)it.getValue()).getPathsSize());
                                it = (Map.Entry)a;
                                Comparable comparable2 = comparable;
                                bl2 = false;
                                Integer n = ((RegularNode)it.getValue()).getPathsSize();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                            }
                        };
                        Iterable $this$filterIndexed$iv2 = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator2);
                        boolean $i$f$filterIndexed2 = false;
                        iterable = $this$filterIndexed$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIndexedTo2 = false;
                        void $this$forEachIndexed$iv$iv$iv2 = $this$filterIndexedTo$iv$iv2;
                        boolean $i$f$forEachIndexed2 = false;
                        int index$iv$iv$iv2 = 0;
                        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv2) {
                            void e;
                            void element$iv$iv;
                            int n = index$iv$iv$iv2++;
                            boolean bl11 = false;
                            if (n < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            int n3 = n;
                            Object t = item$iv$iv$iv;
                            int index$iv$iv = n3;
                            boolean bl12 = false;
                            Map.Entry entry = (Map.Entry)element$iv$iv;
                            int index = index$iv$iv;
                            boolean bl13 = false;
                            if (!(index == 0 || ((RegularNode)e.getValue()).getPathsCount() >= minimumObjectsForReport || ((RegularNode)e.getValue()).getPathsSize() >= 10000000)) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        List childrenToReport = CollectionsKt.asReversed((List)((List)destination$iv$iv2));
                        if (childrenToReport.size() == 1) {
                            Object k = ((Map.Entry)childrenToReport.get(0)).getKey();
                            Intrinsics.checkExpressionValueIsNotNull(k, (String)"childrenToReport[0].key");
                            Edge edge2 = (Edge)k;
                            Object v = ((Map.Entry)childrenToReport.get(0)).getValue();
                            Intrinsics.checkExpressionValueIsNotNull(v, (String)"childrenToReport[0].value");
                            stack.push(new StackEntry(edge2, (RegularNode)v, nextIndent, nextIndent));
                            continue;
                        }
                        if (nextIndent.length() >= 40) {
                            this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>(buffer){

                                public final void invoke(@NotNull String p1) {
                                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                    ((TruncatingPrintBuffer)this.receiver).println(p1);
                                }

                                public final KDeclarationContainer getOwner() {
                                    return Reflection.getOrCreateKotlinClass(TruncatingPrintBuffer.class);
                                }

                                public final String getName() {
                                    return "println";
                                }

                                public final String getSignature() {
                                    return "println(Ljava/lang/String;)V";
                                }
                            }), null, null, null, null, null, true, null, nextIndent, "\\-[...]");
                            continue;
                        }
                        Iterable $this$forEachIndexed$iv = childrenToReport;
                        boolean $i$f$forEachIndexed3 = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$forEachIndexed$iv) {
                            void e;
                            int n = index$iv++;
                            boolean bl14 = false;
                            if (n < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            int n4 = n;
                            Map.Entry entry = (Map.Entry)item$iv;
                            int index = n4;
                            boolean bl15 = false;
                            if (index == 0) {
                                Object k = e.getKey();
                                Intrinsics.checkExpressionValueIsNotNull(k, (String)"e.key");
                                Edge edge3 = (Edge)k;
                                Object v = e.getValue();
                                Intrinsics.checkExpressionValueIsNotNull(v, (String)"e.value");
                                stack.push(new StackEntry(edge3, (RegularNode)v, nextIndent + "\\-", nextIndent + "  "));
                                continue;
                            }
                            Object k = e.getKey();
                            Intrinsics.checkExpressionValueIsNotNull(k, (String)"e.key");
                            Edge edge4 = (Edge)k;
                            Object v = e.getValue();
                            Intrinsics.checkExpressionValueIsNotNull(v, (String)"e.value");
                            stack.push(new StackEntry(edge4, (RegularNode)v, nextIndent + "+-", nextIndent + "| "));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
            }
            String string = result2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
            return string;
        }

        private final void printReportLine(Function1<? super String, ? extends Object> printFunc, Integer pathsCount, Integer percent, Integer instanceCount, Integer instanceSize, Long subgraphSize, boolean lastInPath, Boolean disposed, String indent, String text2) {
            Object object;
            String instanceSizeString;
            String disposedString;
            String lastInPathString;
            String instanceCountString;
            String percentString;
            String pathsCountString;
            block20: {
                block19: {
                    boolean bl;
                    Object object2;
                    block18: {
                        block17: {
                            Object object3;
                            block16: {
                                block15: {
                                    int it;
                                    boolean bl2;
                                    Object object4;
                                    block14: {
                                        block13: {
                                            object4 = pathsCount;
                                            if (object4 == null) break block13;
                                            Integer n = object4;
                                            boolean bl3 = false;
                                            bl2 = false;
                                            it = ((Number)n).intValue();
                                            boolean bl4 = false;
                                            object4 = HeapReportUtils.Companion.toShortStringAsCount(it);
                                            if (object4 != null) break block14;
                                        }
                                        object4 = "";
                                    }
                                    pathsCountString = StringsKt.padStart$default((String)object4, (int)5, (char)'\u0000', (int)2, null);
                                    object3 = percent;
                                    if (object3 == null) break block15;
                                    Integer n = object3;
                                    bl2 = false;
                                    it = 0;
                                    int it2 = ((Number)n).intValue();
                                    boolean bl5 = false;
                                    object3 = "" + it2 + '%';
                                    if (object3 != null) break block16;
                                }
                                object3 = "";
                            }
                            percentString = StringsKt.padStart$default((String)object3, (int)4, (char)'\u0000', (int)2, null);
                            Object object5 = instanceCount;
                            if (object5 == null) {
                                object5 = "";
                            }
                            instanceCountString = StringsKt.padStart$default((String)object5.toString(), (int)10, (char)'\u0000', (int)2, null);
                            lastInPathString = lastInPath ? "*" : " ";
                            disposedString = Intrinsics.areEqual((Object)disposed, (Object)true) ? " (disposed)" : "";
                            object2 = instanceSize;
                            if (object2 == null) break block17;
                            Integer bl5 = object2;
                            boolean bl6 = false;
                            bl = false;
                            int it = ((Number)bl5).intValue();
                            boolean bl7 = false;
                            object2 = HeapReportUtils.Companion.toShortStringAsSize(it);
                            if (object2 != null) break block18;
                        }
                        object2 = "";
                    }
                    instanceSizeString = StringsKt.padStart$default((String)object2, (int)6, (char)'\u0000', (int)2, null);
                    object = subgraphSize;
                    if (object == null) break block19;
                    Long l = object;
                    bl = false;
                    boolean bl8 = false;
                    long it = ((Number)l).longValue();
                    boolean bl9 = false;
                    object = HeapReportUtils.Companion.toShortStringAsSize(it);
                    if (object != null) break block20;
                }
                object = "";
            }
            String subgraphSizeString = StringsKt.padStart$default((String)object, (int)6, (char)'\u0000', (int)2, null);
            printFunc.invoke((Object)('[' + pathsCountString + '/' + percentString + '/' + instanceSizeString + "] " + subgraphSizeString + ' ' + instanceCountString + ' ' + lastInPathString + ' ' + indent + text2 + disposedString));
        }

        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            this.edges.forEachValue((TObjectProcedure)new TObjectProcedure<Pair<? extends RegularNode, ? extends ClassDefinition>>(result2){
                final /* synthetic */ Map $result;

                public final boolean execute(Pair<RegularNode, ClassDefinition> $dstr$node$_u24__u24) {
                    RegularNode node = (RegularNode)$dstr$node$_u24__u24.component1();
                    node.collectDisposedDominatorNodes(this.$result);
                    return true;
                }
                {
                    this.$result = map2;
                }
            });
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode$StackEntry;", "", "edge", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "node", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "indent", "", "nextIndent", "(Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;Ljava/lang/String;Ljava/lang/String;)V", "getEdge", "()Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "getIndent", "()Ljava/lang/String;", "getNextIndent", "getNode", "()Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
        public static final class StackEntry {
            @NotNull
            private final Edge edge;
            @NotNull
            private final RegularNode node;
            @NotNull
            private final String indent;
            @NotNull
            private final String nextIndent;

            @NotNull
            public final Edge getEdge() {
                return this.edge;
            }

            @NotNull
            public final RegularNode getNode() {
                return this.node;
            }

            @NotNull
            public final String getIndent() {
                return this.indent;
            }

            @NotNull
            public final String getNextIndent() {
                return this.nextIndent;
            }

            public StackEntry(@NotNull Edge edge, @NotNull RegularNode node, @NotNull String indent, @NotNull String nextIndent) {
                Intrinsics.checkParameterIsNotNull((Object)edge, (String)"edge");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
                Intrinsics.checkParameterIsNotNull((Object)nextIndent, (String)"nextIndent");
                this.edge = edge;
                this.node = node;
                this.indent = indent;
                this.nextIndent = nextIndent;
            }

            @NotNull
            public final Edge component1() {
                return this.edge;
            }

            @NotNull
            public final RegularNode component2() {
                return this.node;
            }

            @NotNull
            public final String component3() {
                return this.indent;
            }

            @NotNull
            public final String component4() {
                return this.nextIndent;
            }

            @NotNull
            public final StackEntry copy(@NotNull Edge edge, @NotNull RegularNode node, @NotNull String indent, @NotNull String nextIndent) {
                Intrinsics.checkParameterIsNotNull((Object)edge, (String)"edge");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
                Intrinsics.checkParameterIsNotNull((Object)nextIndent, (String)"nextIndent");
                return new StackEntry(edge, node, indent, nextIndent);
            }

            public static /* synthetic */ StackEntry copy$default(StackEntry stackEntry, Edge edge, RegularNode regularNode, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    edge = stackEntry.edge;
                }
                if ((n & 2) != 0) {
                    regularNode = stackEntry.node;
                }
                if ((n & 4) != 0) {
                    string = stackEntry.indent;
                }
                if ((n & 8) != 0) {
                    string2 = stackEntry.nextIndent;
                }
                return stackEntry.copy(edge, regularNode, string, string2);
            }

            @NotNull
            public String toString() {
                return "StackEntry(edge=" + this.edge + ", node=" + this.node + ", indent=" + this.indent + ", nextIndent=" + this.nextIndent + ")";
            }

            public int hashCode() {
                Edge edge = this.edge;
                RegularNode regularNode = this.node;
                String string = this.indent;
                String string2 = this.nextIndent;
                return (((edge != null ? ((Object)edge).hashCode() : 0) * 31 + (regularNode != null ? regularNode.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StackEntry)) break block3;
                        StackEntry stackEntry = (StackEntry)object;
                        if (!Intrinsics.areEqual((Object)this.edge, (Object)stackEntry.edge) || !Intrinsics.areEqual((Object)this.node, (Object)stackEntry.node) || !Intrinsics.areEqual((Object)this.indent, (Object)stackEntry.indent) || !Intrinsics.areEqual((Object)this.nextIndent, (Object)stackEntry.nextIndent)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Companion;", "", "()V", "MAX_INDENT", "", "MAX_TREE_DEPTH", "MINIMUM_OBJECT_COUNT_FOR_REPORT", "MINIMUM_OBJECT_COUNT_PERCENT", "MINIMUM_OBJECT_SIZE_FOR_REPORT", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

