/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.sh.completion.ShCompletionUtil;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShKeywordCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final int PRIORITY = 10;
    @NotNull
    private final String[] myKeywords;
    @NotNull
    private final String myFeatureActionId;
    private final boolean myWithDescription;

    ShKeywordCompletionProvider(@NotNull String featureActionId, String ... keywords) {
        if (featureActionId == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(0);
        }
        if (keywords == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(1);
        }
        this(featureActionId, false, keywords);
    }

    ShKeywordCompletionProvider(@NotNull String featureActionId, boolean withDescription, String ... keywords) {
        if (featureActionId == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(2);
        }
        if (keywords == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(3);
        }
        this.myKeywords = keywords;
        this.myFeatureActionId = featureActionId;
        this.myWithDescription = withDescription;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(5);
        }
        if (result == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(6);
        }
        if (ShCompletionUtil.endsWithDot(parameters)) {
            return;
        }
        Project project = parameters.getOriginalFile().getProject();
        for (String keyword : this.myKeywords) {
            result.addElement(this.createKeywordLookupElement(project, keyword));
        }
    }

    @NotNull
    private LookupElement createKeywordLookupElement(@NotNull Project project, @NotNull String keyword) {
        if (project == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(7);
        }
        if (keyword == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(8);
        }
        TemplateManagerImpl templateManager = (TemplateManagerImpl)TemplateManager.getInstance((Project)project);
        Template template = TemplateSettings.getInstance().getTemplateById("shell_" + keyword);
        InsertHandler<LookupElement> insertHandler = ShKeywordCompletionProvider.createTemplateBasedInsertHandler(templateManager, template, this.myFeatureActionId);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)keyword).withTypeText(template != null && this.myWithDescription ? template.getDescription() : "").withBoldness(true).withInsertHandler(insertHandler), (double)10.0);
        if (lookupElement == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(9);
        }
        return lookupElement;
    }

    private static InsertHandler<LookupElement> createTemplateBasedInsertHandler(@NotNull TemplateManagerImpl templateManager, @Nullable Template template, @NotNull String featureActionId) {
        if (templateManager == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(10);
        }
        if (featureActionId == null) {
            ShKeywordCompletionProvider.$$$reportNull$$$0(11);
        }
        return (context, item) -> {
            Editor editor = context.getEditor();
            if (template != null) {
                editor.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
                templateManager.startTemplate(editor, template);
            } else {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
            }
            ShFeatureUsagesCollector.logFeatureUsage(featureActionId);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureActionId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/completion/ShKeywordCompletionProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/completion/ShKeywordCompletionProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeywordLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordLookupElement";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateBasedInsertHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

