/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class LightVirtualFile
extends LightVirtualFileBase {
    private CharSequence myContent;
    private Language myLanguage;

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NotNull String name) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(0);
        }
        this(name, "");
    }

    public LightVirtualFile(@NotNull String name, @NotNull CharSequence content) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(1);
        }
        if (content == null) {
            LightVirtualFile.$$$reportNull$$$0(2);
        }
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(3);
        }
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(4);
        }
        this(name, fileType, text, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(VirtualFile original, @NotNull CharSequence text, long modificationStamp) {
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(5);
        }
        this(original.getName(), original.getFileType(), text, modificationStamp);
        this.setCharset(original.getCharset());
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text, long modificationStamp) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(6);
        }
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(7);
        }
        this(name, fileType, text, CharsetUtil.extractCharsetFromFileContent(null, null, fileType, text), modificationStamp);
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text, Charset charset, long modificationStamp) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(8);
        }
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(9);
        }
        super(name, fileType, modificationStamp);
        this.myContent = text;
        this.setCharset(charset);
    }

    public LightVirtualFile(@NotNull String name, @NotNull Language language, @NotNull CharSequence text) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(10);
        }
        if (language == null) {
            LightVirtualFile.$$$reportNull$$$0(11);
        }
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(12);
        }
        super(name, null, LocalTimeCounter.currentTime());
        this.myContent = text;
        this.setLanguage(language);
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(@NotNull Language language) {
        if (language == null) {
            LightVirtualFile.$$$reportNull$$$0(13);
        }
        this.myLanguage = language;
        FileType type = language.getAssociatedFileType();
        if (type == null) {
            type = FileTypeRegistry.getInstance().getFileTypeByFileName(this.getNameSequence());
        }
        this.setFileType(type);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.contentsToByteArray(), this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        this.assertWritable();
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                assert (LightVirtualFile.this.isWritable());
                LightVirtualFile.this.setModificationStamp(newModificationStamp);
                try {
                    LightVirtualFile.this.myContent = this.toString(LightVirtualFile.this.getCharset().name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
        if (outputStream == null) {
            LightVirtualFile.$$$reportNull$$$0(14);
        }
        return outputStream;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = this.getContent().toString();
        byte[] byArray = s.getBytes(charset.name());
        if (byArray == null) {
            LightVirtualFile.$$$reportNull$$$0(15);
        }
        return byArray;
    }

    public void setContent(Object requestor, @NotNull CharSequence content, boolean fireEvent) {
        if (content == null) {
            LightVirtualFile.$$$reportNull$$$0(16);
        }
        this.assertWritable();
        this.myContent = content;
        this.setModificationStamp(LocalTimeCounter.currentTime());
    }

    @NotNull
    public CharSequence getContent() {
        CharSequence charSequence = this.myContent;
        if (charSequence == null) {
            LightVirtualFile.$$$reportNull$$$0(17);
        }
        return charSequence;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightVirtualFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setLanguage";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

