/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.util.log;

import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogListener;
import com.intellij.remoteServer.agent.util.log.LogPipeBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class LogPipe
extends LogPipeBase {
    private static int ourInstanceCounter = 0;
    private final String myDeploymentName;
    private final String myLogPipeName;
    private final CloudAgentLogger myLogger;
    private final CloudAgentLoggingHandler myLoggingHandler;
    private volatile boolean myClosed;
    private volatile boolean myLogDebugEnabled;
    private int myTotalLines;
    private int myLines2Skip;
    private final int myInstanceNumber;

    private static int advanceInstanceCounter() {
        return ourInstanceCounter++;
    }

    public LogPipe(String deploymentName, String logPipeName, CloudAgentLogger logger, CloudAgentLoggingHandler loggingHandler) {
        this.myDeploymentName = deploymentName;
        this.myLogPipeName = logPipeName;
        this.myLogger = logger;
        this.myLoggingHandler = loggingHandler;
        this.myClosed = false;
        this.myInstanceNumber = LogPipe.advanceInstanceCounter();
    }

    public void open() {
        InputStream inputStream = this.createInputStream(this.myDeploymentName);
        if (inputStream == null) {
            return;
        }
        InputStreamReader streamReader = new InputStreamReader(inputStream);
        final BufferedReader bufferedReader = new BufferedReader(streamReader);
        this.myTotalLines = 0;
        this.myLines2Skip = 0;
        new Thread("log pipe"){

            public void run() {
                try {
                    while (true) {
                        String line;
                        if ((line = bufferedReader.readLine()) == null) {
                            if (LogPipe.this.isLogDebugEnabled()) {
                                LogPipe.this.debug("Thread[LP]: end of log stream found: " + this);
                            }
                            break;
                        }
                        if (LogPipe.this.isLogDebugEnabled()) {
                            LogPipe.this.debug("Thread[LP]: read line: ``" + line + "`` :" + this);
                        }
                        if (LogPipe.this.myLines2Skip == 0) {
                            LogPipe.this.getLogListener().lineLogged(line);
                            LogPipe.this.myTotalLines++;
                            continue;
                        }
                        LogPipe.this.myLines2Skip--;
                    }
                }
                catch (IOException e) {
                    LogPipe.this.debugEx(e);
                    LogPipe.this.myLoggingHandler.println(e.toString());
                }
                finally {
                    LogListener logListener = LogPipe.this.getLogListener();
                    if (LogPipe.this.isLogDebugEnabled()) {
                        LogPipe.this.debug("Thread[LP]: Pipe thread about to quit, closing LogListener: " + logListener + " :" + this);
                    }
                    logListener.close();
                }
            }

            public String toString() {
                int NAME_SIZE = 8;
                String shortName = LogPipe.this.myDeploymentName.length() < NAME_SIZE ? LogPipe.this.myDeploymentName : LogPipe.this.myDeploymentName.substring(0, NAME_SIZE);
                return "Thread[LP]@" + Integer.toHexString(System.identityHashCode(this)) + " for: " + shortName + "[" + LogPipe.this.myLogPipeName + "]";
            }
        }.start();
    }

    public void close() {
        this.myClosed = true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " {" + this.myInstanceNumber + "}, closed: " + this.isClosed();
    }

    protected final void cutTail() {
        this.myLines2Skip = this.myTotalLines;
    }

    protected final boolean isClosed() {
        return this.myClosed;
    }

    protected abstract InputStream createInputStream(String var1);

    protected final LogListener getLogListener() {
        return this.myLoggingHandler.getOrCreateLogListener(this.myLogPipeName);
    }

    protected final void setLogDebugEnabled(boolean enabled) {
        this.myLogDebugEnabled = enabled;
    }

    protected boolean isLogDebugEnabled() {
        return this.myLogDebugEnabled;
    }

    protected void debug(String message) {
        if (this.myLogDebugEnabled) {
            this.myLogger.debug(this + ": " + message);
        }
    }

    protected void debugEx(Exception e) {
        if (this.myLogDebugEnabled) {
            this.myLogger.debugEx(e);
        }
    }
}

