/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.ThreeStateCheckboxAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.UnversionedViewDialog;
import com.intellij.openapi.vcs.changes.actions.RollbackDialogAction;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.commit.PartialCommitChangeNodeDecorator;
import com.intellij.vcs.commit.PartialCommitInclusionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultipleLocalChangeListsBrowser
extends CommitDialogChangesBrowser
implements Disposable {
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private final boolean myEnableUnversioned;
    private final boolean myEnablePartialCommit;
    @Nullable
    private JComponent myBottomDiffComponent;
    @NotNull
    private final ChangeListChooser myChangeListChooser;
    @NotNull
    private final DeleteProvider myDeleteProvider;
    @NotNull
    private final PartialCommitInclusionModel myInclusionModel;
    @NotNull
    private LocalChangeList myChangeList;
    private final List<Change> myChanges;
    private final List<VirtualFile> myUnversioned;
    private boolean myHasHiddenUnversioned;
    @Nullable
    private Runnable mySelectedListChangeListener;
    private final RollbackDialogAction myRollbackDialogAction;

    MultipleLocalChangeListsBrowser(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, boolean enableUnversioned, boolean enablePartialCommit) {
        List allChangeLists;
        if (project == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(0);
        }
        super(project, showCheckboxes, highlightProblems);
        this.myUpdateQueue = new MergingUpdateQueue("MultipleLocalChangeListsBrowser", 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this);
        this.myDeleteProvider = new VirtualFileDeleteProvider();
        this.myChanges = new ArrayList<Change>();
        this.myUnversioned = new ArrayList<VirtualFile>();
        this.myEnableUnversioned = enableUnversioned;
        this.myEnablePartialCommit = enablePartialCommit;
        this.myChangeList = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
        this.myChangeListChooser = new ChangeListChooser();
        this.myRollbackDialogAction = new RollbackDialogAction();
        this.myRollbackDialogAction.registerCustomShortcutSet(this, null);
        if (Registry.is((String)"vcs.skip.single.default.changelist") && (allChangeLists = ChangeListManager.getInstance((Project)project).getChangeLists()).size() == 1 && ((LocalChangeList)allChangeLists.get(0)).isBlank()) {
            this.myChangeListChooser.setVisible(false);
        }
        this.myInclusionModel = new PartialCommitInclusionModel(this.myProject);
        Disposer.register((Disposable)this, (Disposable)this.myInclusionModel);
        this.getViewer().setInclusionModel(this.myInclusionModel);
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new MyChangeListListener(), (Disposable)this);
        this.init();
        this.updateDisplayedChangeLists();
        this.updateSelectedChangeList(this.myChangeList);
    }

    @Override
    @Nullable
    protected JComponent createHeaderPanel() {
        return JBUI.Panels.simplePanel((Component)this.myChangeListChooser).withBorder((Border)JBUI.Borders.emptyLeft((int)6));
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        AnAction rollbackGroup = this.createRollbackGroup(true);
        List list = ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{rollbackGroup, ActionManager.getInstance().getAction("ChangesView.Refresh"), ActionManager.getInstance().getAction("Vcs.CheckinProjectToolbar")});
        if (list == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(1);
        }
        return list;
    }

    private AnAction createRollbackGroup(boolean popup) {
        List<? extends AnAction> rollbackActions = this.createAdditionalRollbackActions();
        if (rollbackActions.isEmpty()) {
            return this.myRollbackDialogAction;
        }
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{this.myRollbackDialogAction});
        group.addAll(rollbackActions);
        ActionUtil.copyFrom((AnAction)group, (String)"ChangesView.Revert");
        group.setPopup(popup);
        return group;
    }

    protected List<? extends AnAction> createAdditionalRollbackActions() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>(super.createPopupMenuActions());
        result2.add(ActionManager.getInstance().getAction("ChangesView.Refresh"));
        if (this.myEnableUnversioned) {
            result2.add((AnAction)new ShowHideUnversionedFilesAction());
            result2.add((AnAction)UnversionedViewDialog.registerUnversionedPopupGroup((JComponent)((Object)this.myViewer)));
        } else {
            result2.add(ActionManager.getInstance().getAction("ChangesView.Move"));
        }
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)((Object)this.myViewer));
        result2.add(this.createRollbackGroup(false));
        EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this);
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        result2.add((AnAction)editSourceAction);
        result2.add(ActionManager.getInstance().getAction("Vcs.CheckinProjectMenu"));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createDiffActions() {
        List list = ContainerUtil.append(super.createDiffActions(), (Object[])new AnAction[]{new ToggleChangeDiffAction()});
        if (list == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    protected void updateDiffContext(@NotNull DiffRequestChain chain) {
        if (chain == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(4);
        }
        super.updateDiffContext(chain);
        chain.putUserData(DiffUserDataKeysEx.BOTTOM_PANEL, (Object)this.myBottomDiffComponent);
        chain.putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)this.myEnablePartialCommit);
        chain.putUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, (Object)true);
    }

    public void setBottomDiffComponent(@NotNull JComponent value) {
        if (value == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(5);
        }
        this.myBottomDiffComponent = value;
    }

    public void setSelectedListChangeListener(@Nullable Runnable runnable) {
        this.mySelectedListChangeListener = runnable;
    }

    private boolean isShowUnversioned() {
        return this.myEnableUnversioned && VcsConfiguration.getInstance((Project)this.myProject).SHOW_UNVERSIONED_FILES_WHILE_COMMIT;
    }

    private void setShowUnversioned(boolean value) {
        VcsConfiguration.getInstance((Project)this.myProject).SHOW_UNVERSIONED_FILES_WHILE_COMMIT = value;
        this.updateDisplayedChanges();
    }

    @Override
    @NotNull
    public LocalChangeList getSelectedChangeList() {
        LocalChangeList localChangeList = this.myChangeList;
        if (localChangeList == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(6);
        }
        return localChangeList;
    }

    public void setSelectedChangeList(@NotNull LocalChangeList list) {
        if (list == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(7);
        }
        this.myChangeListChooser.setSelectedChangeList(list);
    }

    private void updateSelectedChangeList(@NotNull LocalChangeList list) {
        boolean isListChanged;
        if (list == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(8);
        }
        boolean bl = isListChanged = !this.myChangeList.getId().equals(list.getId());
        if (isListChanged) {
            LineStatusTrackerManager.getInstanceImpl(this.myProject).resetExcludedFromCommitMarkers();
        }
        this.myChangeList = list;
        this.myChangeListChooser.setToolTipText(list.getName());
        this.updateDisplayedChanges();
        if (isListChanged && this.mySelectedListChangeListener != null) {
            this.mySelectedListChangeListener.run();
        }
        this.myInclusionModel.setChangeLists((Collection<? extends LocalChangeList>)ContainerUtil.immutableSingletonList((Object)this.myChangeList));
    }

    @Override
    public void updateDisplayedChangeLists() {
        List changeLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
        this.myChangeListChooser.setAvailableLists(changeLists);
    }

    public void updateDisplayedChanges() {
        this.myChanges.clear();
        this.myUnversioned.clear();
        this.myHasHiddenUnversioned = false;
        this.myChanges.addAll(this.myChangeList.getChanges());
        if (this.myEnableUnversioned) {
            List<VirtualFile> unversioned = ChangeListManagerImpl.getInstanceImpl(this.myProject).getUnversionedFiles();
            if (this.isShowUnversioned()) {
                this.myUnversioned.addAll(unversioned);
            }
            if (!this.isShowUnversioned() && !unversioned.isEmpty()) {
                this.myHasHiddenUnversioned = true;
            }
        }
        this.myViewer.rebuildTree();
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        PartialCommitChangeNodeDecorator decorator = new PartialCommitChangeNodeDecorator(this.myProject, RemoteRevisionsCache.getInstance(this.myProject).getChangesNodeDecorator());
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, this.getGrouping());
        builder.setChanges(this.myChanges, decorator);
        builder.setUnversioned(this.myUnversioned);
        if (this.myHasHiddenUnversioned) {
            this.myViewer.getEmptyText().setText("Unversioned files available. ").appendText("Show", SimpleTextAttributes.LINK_ATTRIBUTES, e -> this.setShowUnversioned(true));
        } else {
            this.myViewer.getEmptyText().setText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        }
        DefaultTreeModel defaultTreeModel = builder.build();
        if (defaultTreeModel == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(9);
        }
        return defaultTreeModel;
    }

    @Override
    @Nullable
    protected ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object entry) {
        if (entry == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(10);
        }
        if (entry instanceof VirtualFile) {
            return UnversionedDiffRequestProducer.create(this.myProject, (VirtualFile)entry);
        }
        return super.getDiffRequestProducer(entry);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(11);
        }
        if (ChangesListView.UNVERSIONED_FILES_DATA_KEY.is(dataId)) {
            return VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjectsStream(VirtualFile.class);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteProvider;
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return new ChangeList[]{this.myChangeList};
        }
        if (ChangesListView.EXACTLY_SELECTED_FILES_DATA_KEY.is(dataId)) {
            return ChangesListView.getExactlySelectedVirtualFiles((JTree)((Object)this.myViewer));
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    public List<Change> getDisplayedChanges() {
        List<Change> list = VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Change> getSelectedChanges() {
        List<Change> list = VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Change> getIncludedChanges() {
        List<Change> list = VcsTreeModelData.included(this.myViewer).userObjects(Change.class);
        if (list == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> getDisplayedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(15);
            }
            return list;
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.allUnderTag((JTree)((Object)this.myViewer), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            List<VirtualFile> list = this.myUnversioned;
            if (list == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<VirtualFile> list = treeModelData.userObjects(VirtualFile.class);
        if (list == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSelectedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(18);
            }
            return list;
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.selectedUnderTag((JTree)((Object)this.myViewer), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            List<VirtualFile> list = this.myUnversioned;
            if (list == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(19);
            }
            return list;
        }
        List<VirtualFile> list = treeModelData.userObjects(VirtualFile.class);
        if (list == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> getIncludedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(21);
            }
            return list;
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.includedUnderTag(this.myViewer, ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            List<VirtualFile> list = this.myUnversioned;
            if (list == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<VirtualFile> list = treeModelData.userObjects(VirtualFile.class);
        if (list == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static boolean containsCollapsedUnversionedNode(@NotNull VcsTreeModelData treeModelData) {
        Optional<ChangesBrowserNode> node;
        if (treeModelData == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(24);
        }
        if (!(node = treeModelData.nodesStream().filter(it -> it instanceof ChangesBrowserUnversionedFilesNode).findAny()).isPresent()) {
            return false;
        }
        ChangesBrowserUnversionedFilesNode unversionedFilesNode = (ChangesBrowserUnversionedFilesNode)node.get();
        return unversionedFilesNode.isManyFiles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModelData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenuActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangeList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedChanges";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedChanges";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedUnversionedFiles";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnversionedFiles";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedUnversionedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateDiffContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setBottomDiffComponent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedChangeList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedChangeList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestProducer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "containsCollapsedUnversionedNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListsChanged() {
            MultipleLocalChangeListsBrowser.this.myUpdateQueue.queue(new Update("updateChangeLists"){

                public void run() {
                    MultipleLocalChangeListsBrowser.this.updateDisplayedChangeLists();
                }
            });
        }
    }

    private class ToggleChangeDiffAction
    extends ThreeStateCheckboxAction
    implements CustomComponentAction,
    DumbAware {
        ToggleChangeDiffAction() {
            super(VcsBundle.message((String)"commit.dialog.include.action.name", (Object[])new Object[0]));
        }

        @NotNull
        public ThreeStateCheckBox.State isSelected(AnActionEvent e) {
            Object object = this.getUserObject(e);
            if (object == null) {
                ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
                if (state == null) {
                    ToggleChangeDiffAction.$$$reportNull$$$0(0);
                }
                return state;
            }
            ThreeStateCheckBox.State state = MultipleLocalChangeListsBrowser.this.myInclusionModel.getInclusionState(object);
            if (state == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(1);
            }
            return state;
        }

        public void setSelected(AnActionEvent e, @NotNull ThreeStateCheckBox.State state) {
            Object object;
            if (state == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(2);
            }
            if ((object = this.getUserObject(e)) == null) {
                return;
            }
            if (state != ThreeStateCheckBox.State.NOT_SELECTED) {
                MultipleLocalChangeListsBrowser.this.myViewer.includeChange(object);
            } else {
                MultipleLocalChangeListsBrowser.this.myViewer.excludeChange(object);
            }
        }

        @Nullable
        private Object getUserObject(@NotNull AnActionEvent e) {
            Object object;
            if (e == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(3);
            }
            if ((object = e.getData(VcsDataKeys.CURRENT_CHANGE)) == null) {
                object = e.getData(VcsDataKeys.CURRENT_UNVERSIONED);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ToggleChangeDiffAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isSelected";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ToggleChangeDiffAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserObject";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ShowHideUnversionedFilesAction
    extends ToggleAction
    implements DumbAware {
        private ShowHideUnversionedFilesAction() {
            super("Show Unversioned Files", null, AllIcons.Vcs.ShowUnversionedFiles);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowHideUnversionedFilesAction.$$$reportNull$$$0(0);
            }
            return MultipleLocalChangeListsBrowser.this.isShowUnversioned();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowHideUnversionedFilesAction.$$$reportNull$$$0(1);
            }
            MultipleLocalChangeListsBrowser.this.setShowUnversioned(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ShowHideUnversionedFilesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ChangeListChooser
    extends JPanel {
        private static final int MAX_NAME_LEN = 35;
        @NotNull
        private final ComboBox<LocalChangeList> myChooser = new ComboBox();

        ChangeListChooser() {
            this.myChooser.setEditable(false);
            this.myChooser.setRenderer((ListCellRenderer)new ColoredListCellRenderer<LocalChangeList>(){

                protected void customizeCellRenderer(@NotNull JList<? extends LocalChangeList> list, LocalChangeList value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String name = StringUtil.shortenTextWithEllipsis((String)value.getName().trim(), (int)35, (int)0);
                    this.append(name, value.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ChangeListChooser$1", "customizeCellRenderer"));
                }
            });
            this.myChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LocalChangeList changeList;
                    if (e.getStateChange() == 1 && (changeList = (LocalChangeList)ChangeListChooser.this.myChooser.getSelectedItem()) != null) {
                        MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(changeList);
                    }
                }
            });
            this.setLayout(new BorderLayout(4, 2));
            JLabel label = new JLabel(VcsBundle.message((String)"commit.dialog.changelist.label", (Object[])new Object[0]));
            label.setLabelFor((Component)this.myChooser);
            this.add((Component)label, "West");
            this.add((Component)this.myChooser, "Center");
        }

        public void setAvailableLists(@NotNull List<LocalChangeList> lists) {
            LocalChangeList currentList;
            if (lists == null) {
                ChangeListChooser.$$$reportNull$$$0(0);
            }
            if ((currentList = (LocalChangeList)ContainerUtil.find(lists, (Object)MultipleLocalChangeListsBrowser.this.getSelectedChangeList())) == null) {
                currentList = lists.get(0);
            }
            this.myChooser.setModel((ComboBoxModel)new CollectionComboBoxModel(lists, (Object)currentList));
            this.myChooser.setEnabled(lists.size() > 1);
            MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(currentList);
        }

        public void setSelectedChangeList(@NotNull LocalChangeList list) {
            if (list == null) {
                ChangeListChooser.$$$reportNull$$$0(1);
            }
            ComboBoxModel model = this.myChooser.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                LocalChangeList element = (LocalChangeList)model.getElementAt(i);
                if (!element.getName().equals(list.getName())) continue;
                this.myChooser.setSelectedIndex(i);
                MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(element);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lists";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ChangeListChooser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setAvailableLists";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelectedChangeList";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

