# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.connectivity_filter import ConnectivityFilter


class PConnectivityFilter(ConnectivityFilter):
    """
    PConnectivityFilter - Parallel version of ConnectivityFilter
    
    Superclass: ConnectivityFilter
    
    This class computes connectivity of a distributed data set in
    parallel.
    
    Problem =======
    
    Datasets are distributed among ranks in a distributed process (Figure
    1). ConnectivityFilter already runs in parallel on each piece in a
    typical VTK application run with MPI, but it does not produce correct
    results. As Figure 2 shows, distributed pieces of each connected
    component may end up with different labels.
    
    ![Figure 1: Pieces in a distributed data set colored by processor
    rank.](vtk_p_connectivity_filter_figure1.png)
    
    ![Figure 2: Left). Incorrect parallel labeling. Right). Correct
    labeling.](vtk_p_connectivity_filter_figure2.png)
    
    The part missing from a fully parallel connectivity filter
    implementation is the identification of which pieces on different
    ranks are actually connected. This parallel filter provides that
    missing piece.
    
    Approach ========
    
    Run ConnectivityFilter on each rank’s piece and resolve the
    connected pieces afterwards. The implementation uses
    MPIProcessController to communicate among processes.
    
    Steps in the PConnectivityFilter
    -----------------------------------
    
    ### High-level steps
    
    + Run local connectivity algorithm.
    
    + Identify region connections across ranks and create a graph of
    these links.
    
    + Run a connected components algorithm on the graph created in the
    previous
      step to unify the regions across ranks.
    
    + Relabel cells and points with their “global” region_ids.
    
    ### Low-level steps
    
    + In generate_data(), invoke the superclass’s generate_data() method.
    Make temporary changes to extract all connected regions - we’ll
    handle the different extraction modes at the end. Example results on
    3 ranks are shown in Figure 3 where color indicates region_id computed
    by ConnectivityFilter.
    
    + Check for errors in superclass generate_data() on any rank and exit
    the algorithm if any encountered an error-indicating return code.
    
    ![Figure 3: Results after ConnectivityFilter superclass is called
    on each piece.](vtk_p_connectivity_filter_figure3.png)
    
    + all_gatherv the number of connected region_ids from each rank and
    all_gatherv the region_ids themselves.
    
    + Gather all axis-aligned bounding boxes from all other ranks. This
    is used to compute potential neighbors with which each rank should
    exchange points and region_ids.
    
    ![Figure 4: Point and associated region_id
    exchange.](vtk_p_connectivity_filter_figure4.png)
    
    + Each rank gathers up points potentially coincident with points on
    neighboring ranks and sends them to their neighbors as well as the
    region_id assigned to each point.
    
    + Each rank runs through the received points and determines which
    points it owns using a locator object. If a point is found on the
    local rank, add the region_id from the remote point to a set
    associated with the local region_id. This signifies that the local
    region_id is connected to the remote region_id associated with the
    point.
    
    + Each rank gathers the local-_region_id-to-remote-_region_id links from
    all other ranks.
    
    + From these links, each rank generates a graph structure of the
    global links. The graph structure is identical on all ranks.
    (Optimization opportunity: To reduce communication, this link
    exchange could be avoided and the graph could be made distributed.
    This is just more complicated to program, however).
    
    ![Figure 5: Connected region graph depicted by black line
    segments.](vtk_p_connectivity_filter_figure5.png)
    
    + Run a connected components algorithm that relabels the region_ids,
    yielding the full connectivity graph across ranks. Figure 6 shows an
    example result.
    
    + Relabel the remaining region_ids by a contiguous set of region_ids
    (e.g., go from [0, 5, 8, 9] to [0, 1, 2, 3]).
    
    ![Figure 6: Connected components of graph linking region_ids across
    ranks.](vtk_p_connectivity_filter_figure6.png)
    
    + From the region_id graph, relabel points and cells in the output.
    The result is shown in Figure 7.
    
    ![Figure 7: Dataset relabeled with global connected
    region_ids.](vtk_p_connectivity_filter_figure7.png)
    
    + Handle scalar_connectivy option and extraction_mode after full region
    connectivity is determined by identifying the correct region_id and
    extracting it by thresholding.
    
    Caveats =======
    
    This parallel implementation does not support a number of features
    that the ConnectivityFilter class supports, including:
    
    - scalar_connectivity
    - VTK_EXTRACT_POINT_SEEDED_REGIONS extraction mode
    - VTK_EXTRACT_CELL_SEEDED_REGIONS extraction mode
    - VTK_EXTRACT_SPECIFIED_REGIONS extraction mode
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPConnectivityFilter, obj, update, **traits)
    
    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        
        """
    )

    _updateable_traits_ = \
    (('color_regions', 'GetColorRegions'), ('scalar_connectivity',
    'GetScalarConnectivity'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('extraction_mode', 'GetExtractionMode'), ('closest_point',
    'GetClosestPoint'), ('output_points_precision',
    'GetOutputPointsPrecision'), ('region_id_assignment_mode',
    'GetRegionIdAssignmentMode'), ('scalar_range', 'GetScalarRange'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'color_regions', 'debug', 'global_warning_display',
    'release_data_flag', 'scalar_connectivity', 'extraction_mode',
    'closest_point', 'output_points_precision', 'progress_text',
    'region_id_assignment_mode', 'scalar_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PConnectivityFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PConnectivityFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['color_regions', 'scalar_connectivity'], ['extraction_mode'],
            ['closest_point', 'output_points_precision',
            'region_id_assignment_mode', 'scalar_range']),
            title='Edit PConnectivityFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PConnectivityFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

