/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdInputStream
extends FilterInputStream {
    private final long stream;
    private long dstPos = 0L;
    private long srcPos = 0L;
    private long srcSize = 0L;
    private byte[] src = new byte[srcBuffSize];
    private static final int srcBuffSize;
    private boolean isContinuous = false;
    private boolean frameFinished = true;
    private boolean isClosed = false;

    private static native long recommendedDInSize();

    private static native long recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native int decompressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        ZstdInputStream zstdInputStream = this;
        synchronized (zstdInputStream) {
            this.stream = ZstdInputStream.createDStream();
            this.initDStream(this.stream);
        }
    }

    public synchronized ZstdInputStream setContinuous(boolean bl) {
        this.isContinuous = bl;
        return this;
    }

    public synchronized boolean getContinuous() {
        return this.isContinuous;
    }

    public synchronized ZstdInputStream setDict(byte[] byArray) throws IOException {
        int n = Zstd.loadDictDecompress(this.stream, byArray, byArray.length);
        if (Zstd.isError(n)) {
            throw new IOException("Decompression error: " + Zstd.getErrorName(n));
        }
        return this;
    }

    public synchronized ZstdInputStream setDict(ZstdDictDecompress zstdDictDecompress) throws IOException {
        zstdDictDecompress.acquireSharedLock();
        try {
            int n = Zstd.loadFastDictDecompress(this.stream, zstdDictDecompress);
            if (Zstd.isError(n)) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(n));
            }
        }
        finally {
            zstdDictDecompress.releaseSharedLock();
        }
        return this;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Requested lenght " + n2 + " from offset " + n + " in buffer of size " + byArray.length);
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (n3 == 0) {
            n3 = this.readInternal(byArray, n, n2);
        }
        return n3;
    }

    int readInternal(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (n < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Requested lenght " + n2 + " from offset " + n + " in buffer of size " + byArray.length);
        }
        int n3 = n + n2;
        this.dstPos = n;
        while (this.dstPos < (long)n3) {
            int n4;
            if (this.srcSize - this.srcPos == 0L) {
                this.srcSize = this.in.read(this.src, 0, srcBuffSize);
                this.srcPos = 0L;
                if (this.srcSize < 0L) {
                    this.srcSize = 0L;
                    if (this.frameFinished) {
                        return -1;
                    }
                    if (this.isContinuous) {
                        return (int)(this.dstPos - (long)n);
                    }
                    throw new IOException("Read error or truncated source");
                }
                this.frameFinished = false;
            }
            if (Zstd.isError(n4 = this.decompressStream(this.stream, byArray, n3, this.src, (int)this.srcSize))) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(n4));
            }
            if (n4 != 0) continue;
            this.frameFinished = true;
            return (int)(this.dstPos - (long)n);
        }
        return n2;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = 0;
        while (n == 0) {
            n = this.readInternal(byArray, 0, 1);
        }
        if (n == 1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (this.srcSize - this.srcPos > 0L) {
            return (int)(this.srcSize - this.srcPos);
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        int n;
        long l2;
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (l <= 0L) {
            return 0L;
        }
        int n2 = (int)Math.min(ZstdInputStream.recommendedDOutSize(), l2);
        byte[] byArray = new byte[n2];
        for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)Math.min((long)n2, l2))) >= 0; l2 -= (long)n) {
        }
        return l - l2;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        ZstdInputStream.freeDStream(this.stream);
        this.in.close();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        Native.load();
        srcBuffSize = (int)ZstdInputStream.recommendedDInSize();
    }
}

