/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOInputStream
extends InputStream {
    private final IRubyObject io;
    private final InputStream in;
    private final IRubyObject numOne;
    private final CallSite readAdapter = MethodIndex.getFunctionalCallSite("read");
    private final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");

    public IOInputStream(IRubyObject io2) {
        this(io2, true);
    }

    public IOInputStream(IRubyObject io2, boolean verifyCanRead) {
        this.io = io2;
        InputStream inputStream = this.in = io2 instanceof RubyIO && !((RubyIO)io2).isClosed() && ((RubyIO)io2).isBuiltin("read") ? ((RubyIO)io2).getInStream() : null;
        if (this.in == null && verifyCanRead && !io2.respondsTo("read")) {
            throw new IllegalArgumentException("Object: " + io2 + " is not a legal argument to this wrapper, cause it doesn't respond to \"read\".");
        }
        this.numOne = RubyFixnum.one(io2.getRuntime());
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        } else if (this.io.respondsTo("close")) {
            this.closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io);
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in != null) {
            return this.in.available();
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        if (this.in != null) {
            return this.in.read();
        }
        Ruby runtime2 = this.io.getRuntime();
        IRubyObject readValue = this.readAdapter.call(runtime2.getCurrentContext(), this.io, this.io, this.numOne);
        if (readValue.isNil()) {
            return -1;
        }
        return readValue.convertToString().getByteList().get(0) & 0xFF;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.in != null) {
            return this.in.read(b2, off, len);
        }
        Ruby runtime2 = this.io.getRuntime();
        IRubyObject readValue = this.readAdapter.call(runtime2.getCurrentContext(), this.io, this.io, (IRubyObject)runtime2.newFixnum(len));
        if (readValue.isNil()) {
            return -1;
        }
        ByteList str = readValue.convertToString().getByteList();
        System.arraycopy(str.getUnsafeBytes(), str.getBegin(), b2, off, str.getRealSize());
        return str.getRealSize();
    }
}

