"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var rendering_1 = require("../../chart_types/xy_chart/rendering/rendering");
var rendering_props_utils_1 = require("./utils/rendering_props_utils");
var LineGeometries = /** @class */ (function (_super) {
    __extends(LineGeometries, _super);
    function LineGeometries(props) {
        var _this = _super.call(this, props) || this;
        _this.barSeriesRef = react_1.default.createRef();
        _this.renderPoints = function (linePoints, lineKey, pointStyleProps) {
            var linePointsElements = [];
            linePoints.forEach(function (linePoint, pointIndex) {
                var x = linePoint.x, y = linePoint.y, transform = linePoint.transform;
                var key = "line-point-" + lineKey + "-" + pointIndex;
                var pointProps = rendering_props_utils_1.buildPointRenderProps(transform.x + x, y, pointStyleProps);
                linePointsElements.push(react_1.default.createElement(react_konva_1.Circle, __assign({}, pointProps, { key: key })));
            });
            return linePointsElements;
        };
        _this.renderLineGeoms = function () {
            var _a = _this.props, lines = _a.lines, sharedStyle = _a.sharedStyle;
            return lines.reduce(function (acc, glyph) {
                var seriesLineStyle = glyph.seriesLineStyle, seriesPointStyle = glyph.seriesPointStyle, geometryId = glyph.geometryId;
                var key = rendering_1.getGeometryIdKey(geometryId, 'line-');
                if (seriesLineStyle.visible) {
                    acc.push(_this.getLineToRender(glyph, sharedStyle, key));
                }
                if (seriesPointStyle.visible) {
                    acc.push.apply(acc, __spread(_this.getPointToRender(glyph, sharedStyle, key)));
                }
                return acc;
            }, []);
        };
        _this.barSeriesRef = react_1.default.createRef();
        _this.state = {
            overPoint: undefined,
        };
        return _this;
    }
    LineGeometries.prototype.render = function () {
        return (react_1.default.createElement(react_konva_1.Group, { ref: this.barSeriesRef, key: 'bar_series' }, this.renderLineGeoms()));
    };
    LineGeometries.prototype.getLineToRender = function (glyph, sharedStyle, key) {
        var clippings = this.props.clippings;
        var line = glyph.line, color = glyph.color, transform = glyph.transform, geometryId = glyph.geometryId, seriesLineStyle = glyph.seriesLineStyle;
        var geometryStyle = rendering_1.getGeometryStyle(geometryId, this.props.highlightedLegendItem, sharedStyle);
        var lineProps = rendering_props_utils_1.buildLineRenderProps(transform.x, line, color, seriesLineStyle, geometryStyle);
        return (react_1.default.createElement(react_konva_1.Group, __assign({}, clippings, { key: key }),
            react_1.default.createElement(react_konva_1.Path, __assign({}, lineProps))));
    };
    LineGeometries.prototype.getPointToRender = function (glyph, sharedStyle, key) {
        var points = glyph.points, color = glyph.color, geometryId = glyph.geometryId, seriesPointStyle = glyph.seriesPointStyle;
        var geometryStyle = rendering_1.getGeometryStyle(geometryId, this.props.highlightedLegendItem, sharedStyle);
        var pointStyleProps = rendering_props_utils_1.buildPointStyleProps(color, seriesPointStyle, geometryStyle);
        return this.renderPoints(points, key, pointStyleProps);
    };
    LineGeometries.defaultProps = {
        animated: false,
    };
    return LineGeometries;
}(react_1.default.PureComponent));
exports.LineGeometries = LineGeometries;
//# sourceMappingURL=line_geometries.js.map