/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webauthn4j.converter.jackson.WebAuthnCBORModule;
import com.webauthn4j.converter.jackson.WebAuthnJSONModule;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.JsonConverter;

class ConverterUtil {
    private ConverterUtil() {
    }

    static ObjectMapper initializeJsonMapper(ObjectMapper jsonMapper, JsonConverter jsonConverter, CborConverter cborConverter) {
        jsonMapper.registerModule((Module)new WebAuthnJSONModule(jsonConverter, cborConverter));
        jsonMapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, false);
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return jsonMapper;
    }

    static ObjectMapper initializeCborMapper(ObjectMapper cborMapper, JsonConverter jsonConverter, CborConverter cborConverter) {
        cborMapper.registerModule((Module)new WebAuthnCBORModule(jsonConverter, cborConverter));
        cborMapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, false);
        cborMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        cborMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return cborMapper;
    }
}

