/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.audit;

import javax.inject.Singleton;
import org.drools.core.audit.ThreadedWorkingMemoryFileLogger;
import org.drools.core.audit.WorkingMemoryConsoleLogger;
import org.drools.core.audit.WorkingMemoryFileLogger;
import org.drools.core.impl.AbstractRuntime;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.logger.KieLoggers;
import org.kie.api.logger.KieRuntimeLogger;

@Singleton
public class KnowledgeRuntimeLoggerProviderImpl
implements KieLoggers {
    public KieRuntimeLogger newFileLogger(KieRuntimeEventManager session, String fileName) {
        return this.newFileLogger(session, fileName, 1000);
    }

    public KieRuntimeLogger newFileLogger(KieRuntimeEventManager session, String fileName, int maxEventsInMemory) {
        WorkingMemoryFileLogger logger = new WorkingMemoryFileLogger(session);
        logger.setMaxEventsInMemory(maxEventsInMemory);
        if (fileName != null) {
            logger.setFileName(fileName);
        }
        return this.registerRuntimeLogger(session, logger);
    }

    public KieRuntimeLogger newThreadedFileLogger(KieRuntimeEventManager session, String fileName, int interval) {
        ThreadedWorkingMemoryFileLogger logger = new ThreadedWorkingMemoryFileLogger(session);
        if (fileName != null) {
            logger.setFileName(fileName);
        }
        logger.start(interval);
        return this.registerRuntimeLogger(session, logger);
    }

    public KieRuntimeLogger newConsoleLogger(KieRuntimeEventManager session) {
        WorkingMemoryConsoleLogger logger = new WorkingMemoryConsoleLogger(session);
        return this.registerRuntimeLogger(session, logger);
    }

    private KieRuntimeLogger registerRuntimeLogger(KieRuntimeEventManager session, KieRuntimeLogger logger) {
        if (session instanceof AbstractRuntime) {
            ((AbstractRuntime)session).setLogger(logger);
        }
        return logger;
    }
}

