/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.serialization.AbstractSerializableHolder;

public class FieldHolder
extends AbstractSerializableHolder<Field>
implements PrivilegedAction<Field> {
    private static final long serialVersionUID = 407021346356682729L;
    private final Class<?> declaringClass;
    private final String fieldName;

    public FieldHolder(Field field) {
        super(field);
        this.declaringClass = field.getDeclaringClass();
        this.fieldName = field.getName();
    }

    @Override
    protected Field initialize() {
        return AccessController.doPrivileged(this);
    }

    @Override
    public Field run() {
        try {
            return this.declaringClass.getDeclaredField(this.fieldName);
        }
        catch (Exception e) {
            throw ReflectionLogger.LOG.unableToGetFieldOnDeserialization(this.declaringClass, this.fieldName, e);
        }
    }
}

