/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.common.iteration.ByteIterator;

class CertificateChainAttributeDefinitions {
    private static final String SHA_1 = "SHA-1";
    private static final String SHA_256 = "SHA-256";
    private static final SimpleAttributeDefinition TYPE = new SimpleAttributeDefinitionBuilder("type", ModelType.STRING).build();
    private static final SimpleAttributeDefinition ALGORITHM = new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).build();
    private static final SimpleAttributeDefinition FORMAT = new SimpleAttributeDefinitionBuilder("format", ModelType.STRING).build();
    private static final SimpleAttributeDefinition PUBLIC_KEY = new SimpleAttributeDefinitionBuilder("public-key", ModelType.STRING).build();
    private static final SimpleAttributeDefinition SHA_1_DIGEST = new SimpleAttributeDefinitionBuilder("sha-1-digest", ModelType.STRING).build();
    private static final SimpleAttributeDefinition SHA_256_DIGEST = new SimpleAttributeDefinitionBuilder("sha-256-digest", ModelType.STRING).build();
    private static final SimpleAttributeDefinition ENCODED = new SimpleAttributeDefinitionBuilder("encoded", ModelType.STRING).build();
    private static final SimpleAttributeDefinition SUBJECT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("subject", ModelType.STRING).setRequired(false)).build();
    private static final SimpleAttributeDefinition ISSUER = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("issuer", ModelType.STRING).setRequired(false)).build();
    private static final SimpleAttributeDefinition NOT_BEFORE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("not-before", ModelType.STRING).setRequired(false)).build();
    private static final SimpleAttributeDefinition NOT_AFTER = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("not-after", ModelType.STRING).setRequired(false)).build();
    private static final SimpleAttributeDefinition SERIAL_NUMBER = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("serial-number", ModelType.STRING).setRequired(false)).build();
    private static final SimpleAttributeDefinition SIGNATURE_ALGORITHM = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("signature-algorithm", ModelType.STRING).setRequired(false)).build();
    private static final SimpleAttributeDefinition SIGNATURE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("signature", ModelType.STRING).setRequired(false)).build();
    private static final SimpleAttributeDefinition VERSION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("version", ModelType.STRING).setRequired(false)).build();
    static final ObjectTypeAttributeDefinition CERTIFICATE = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("certificate", new AttributeDefinition[]{TYPE, ALGORITHM, FORMAT, PUBLIC_KEY, SHA_1_DIGEST, SHA_256_DIGEST, ENCODED, SUBJECT, ISSUER, NOT_BEFORE, NOT_AFTER, SERIAL_NUMBER, SIGNATURE_ALGORITHM, SIGNATURE, VERSION}).setStorageRuntime()).build();

    CertificateChainAttributeDefinitions() {
    }

    static ObjectListAttributeDefinition getNamedCertificateList(String name) {
        return ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder(name, CERTIFICATE).setRequired(false)).setStorageRuntime()).build();
    }

    static void writeCertificate(ModelNode certificateModel, Certificate certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        certificateModel.get("type").set(certificate.getType());
        PublicKey publicKey = certificate.getPublicKey();
        certificateModel.get("algorithm").set(publicKey.getAlgorithm());
        certificateModel.get("format").set(publicKey.getFormat());
        certificateModel.get("public-key").set(CertificateChainAttributeDefinitions.encodedHexString(publicKey.getEncoded()));
        byte[] encodedCertificate = certificate.getEncoded();
        certificateModel.get("sha-1-digest").set(CertificateChainAttributeDefinitions.encodedHexString(CertificateChainAttributeDefinitions.digest(SHA_1, encodedCertificate)));
        certificateModel.get("sha-256-digest").set(CertificateChainAttributeDefinitions.encodedHexString(CertificateChainAttributeDefinitions.digest(SHA_256, encodedCertificate)));
        certificateModel.get("encoded").set(CertificateChainAttributeDefinitions.encodedHexString(encodedCertificate));
        if (certificate instanceof X509Certificate) {
            CertificateChainAttributeDefinitions.writeX509Certificate(certificateModel, (X509Certificate)certificate);
        }
    }

    private static void writeX509Certificate(ModelNode certificateModel, X509Certificate certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        certificateModel.get("subject").set(certificate.getSubjectX500Principal().getName());
        certificateModel.get("issuer").set(certificate.getIssuerX500Principal().getName());
        certificateModel.get("not-before").set(sdf.format(certificate.getNotBefore()));
        certificateModel.get("not-after").set(sdf.format(certificate.getNotAfter()));
        certificateModel.get("serial-number").set(CertificateChainAttributeDefinitions.delimit(certificate.getSerialNumber().toString(16).toCharArray()));
        certificateModel.get("signature-algorithm").set(certificate.getSigAlgName());
        certificateModel.get("signature").set(CertificateChainAttributeDefinitions.encodedHexString(certificate.getSignature()));
        certificateModel.get("version").set("v" + certificate.getVersion());
    }

    static void writeCertificates(ModelNode result, Certificate[] certificates) throws CertificateEncodingException, NoSuchAlgorithmException {
        if (certificates != null) {
            for (Certificate current : certificates) {
                ModelNode certificate = new ModelNode();
                CertificateChainAttributeDefinitions.writeCertificate(certificate, current);
                result.add(certificate);
            }
        }
    }

    private static byte[] digest(String algorithm, byte[] encoded) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        return digest.digest(encoded);
    }

    private static String encodedHexString(byte[] encoded) {
        return CertificateChainAttributeDefinitions.delimit(ByteIterator.ofBytes((byte[])encoded).hexEncode().drainToString().toCharArray());
    }

    private static String delimit(char[] chars) {
        StringBuilder sb = new StringBuilder();
        int offset = 1;
        if (chars.length % 2 != 0) {
            sb.append('0');
            ++offset;
        }
        for (int i = 0; i < chars.length; ++i) {
            sb.append(chars[i]);
            if (i + 1 >= chars.length || (i + offset) % 2 != 0) continue;
            sb.append(':');
        }
        return sb.toString();
    }
}

