/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.client;

import java.util.Collections;
import java.util.Map;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.client.ClientStorageProviderModel;
import org.keycloak.storage.client.UnsupportedOperationsClientStorageAdapter;

public abstract class AbstractClientStorageAdapter
extends UnsupportedOperationsClientStorageAdapter {
    protected KeycloakSession session;
    protected RealmModel realm;
    protected ClientStorageProviderModel component;
    private StorageId storageId;

    public AbstractClientStorageAdapter(KeycloakSession session, RealmModel realm, ClientStorageProviderModel component) {
        this.session = session;
        this.realm = realm;
        this.component = component;
    }

    public String getId() {
        if (this.storageId == null) {
            this.storageId = new StorageId(this.component.getId(), this.getClientId());
        }
        return this.storageId.getId();
    }

    public final RealmModel getRealm() {
        return this.realm;
    }

    public boolean isSurrogateAuthRequired() {
        return false;
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
    }

    public Map<String, Integer> getRegisteredNodes() {
        return Collections.EMPTY_MAP;
    }

    public void registerNode(String nodeHost, int registrationTime) {
    }

    public void unregisterNode(String nodeHost) {
    }

    public void updateClient() {
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.ClientUpdatedEvent(){

            public ClientModel getUpdatedClient() {
                return AbstractClientStorageAdapter.this;
            }

            public KeycloakSession getKeycloakSession() {
                return AbstractClientStorageAdapter.this.session;
            }
        });
    }
}

