/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.services.resources.Cors;

public class CorsErrorResponseException
extends WebApplicationException {
    private final Cors cors;
    private final String error;
    private final String errorDescription;
    private final Response.Status status;

    public CorsErrorResponseException(Cors cors, String error, String errorDescription, Response.Status status) {
        this.cors = cors;
        this.error = error;
        this.errorDescription = errorDescription;
        this.status = status;
    }

    public Response getResponse() {
        OAuth2ErrorRepresentation errorRep = new OAuth2ErrorRepresentation(this.error, this.errorDescription);
        Response.ResponseBuilder builder = Response.status((Response.Status)this.status).entity((Object)errorRep).type(MediaType.APPLICATION_JSON_TYPE);
        return this.cors.builder(builder).build();
    }
}

