/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.profile.ecp.authenticator;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.common.util.Base64;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class HttpBasicAuthenticator
implements Authenticator {
    private static final String BASIC = "Basic";
    private static final String BASIC_PREFIX = "Basic ";

    public void authenticate(AuthenticationFlowContext context) {
        HttpRequest httpRequest = context.getHttpRequest();
        HttpHeaders httpHeaders = httpRequest.getHttpHeaders();
        String[] usernameAndPassword = this.getUsernameAndPassword(httpHeaders);
        context.attempted();
        if (usernameAndPassword != null) {
            RealmModel realm = context.getRealm();
            String username = usernameAndPassword[0];
            UserModel user = context.getSession().users().getUserByUsername(username, realm);
            context.getEvent().detail("username", username);
            context.getAuthenticationSession().setAuthNote("ATTEMPTED_USERNAME", username);
            if (user != null) {
                String password = usernameAndPassword[1];
                boolean valid = context.getSession().userCredentialManager().isValid(realm, user, new CredentialInput[]{UserCredentialModel.password((String)password)});
                if (valid) {
                    if (this.isTemporarilyDisabledByBruteForce(context, user)) {
                        this.userDisabledAction(context, realm, user, "user_temporarily_disabled");
                    } else if (user.isEnabled()) {
                        this.userSuccessAction(context, user);
                    } else {
                        this.userDisabledAction(context, realm, user, "user_disabled");
                    }
                } else {
                    this.notValidCredentialsAction(context, realm, user);
                }
            } else {
                this.nullUserAction(context, realm, username);
            }
        }
    }

    protected void userSuccessAction(AuthenticationFlowContext context, UserModel user) {
        context.getAuthenticationSession().setAuthenticatedUser(user);
        context.success();
    }

    protected void userDisabledAction(AuthenticationFlowContext context, RealmModel realm, UserModel user, String eventError) {
        context.getEvent().user(user);
        context.getEvent().error(eventError);
        context.failure(AuthenticationFlowError.INVALID_USER, Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)("Basic realm=\"" + realm.getName() + "\"")).build());
    }

    protected void nullUserAction(AuthenticationFlowContext context, RealmModel realm, String user) {
    }

    protected void notValidCredentialsAction(AuthenticationFlowContext context, RealmModel realm, UserModel user) {
        context.getEvent().user(user);
        context.getEvent().error("invalid_user_credentials");
        context.failure(AuthenticationFlowError.INVALID_USER, Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)("Basic realm=\"" + realm.getName() + "\"")).build());
    }

    private boolean isTemporarilyDisabledByBruteForce(AuthenticationFlowContext context, UserModel user) {
        return context.getRealm().isBruteForceProtected() && context.getProtector().isTemporarilyDisabled(context.getSession(), context.getRealm(), user);
    }

    private String[] getUsernameAndPassword(HttpHeaders httpHeaders) {
        List authHeaders = httpHeaders.getRequestHeader("Authorization");
        if (authHeaders == null || authHeaders.size() == 0) {
            return null;
        }
        String credentials = null;
        for (String authHeader : authHeaders) {
            if (!authHeader.startsWith(BASIC_PREFIX)) continue;
            String[] split = authHeader.trim().split("\\s+");
            if (split == null || split.length != 2) {
                return null;
            }
            credentials = split[1];
        }
        try {
            String val = new String(Base64.decode(credentials));
            int seperatorIndex = val.indexOf(":");
            if (seperatorIndex == -1) {
                return new String[]{val};
            }
            String user = val.substring(0, seperatorIndex);
            String pw = val.substring(seperatorIndex + 1);
            return new String[]{user, pw};
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse credentials.", e);
        }
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

