/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.logging.Logger;
import org.keycloak.authentication.requiredactions.util.UpdateProfileContext;

public class ProfileBean {
    private static final Logger logger = Logger.getLogger(ProfileBean.class);
    private UpdateProfileContext user;
    private MultivaluedMap<String, String> formData;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public ProfileBean(UpdateProfileContext user, MultivaluedMap<String, String> formData) {
        this.user = user;
        this.formData = formData;
        Map<String, List<String>> modelAttrs = user.getAttributes();
        if (modelAttrs != null) {
            for (Map.Entry<String, List<String>> attr : modelAttrs.entrySet()) {
                List<String> attrValue = attr.getValue();
                if (attrValue != null && attrValue.size() > 0) {
                    this.attributes.put(attr.getKey(), attrValue.get(0));
                }
                if (attrValue == null || attrValue.size() <= 1) continue;
                logger.warnf("There are more values for attribute '%s' of user '%s' . Will display just first value", (Object)attr.getKey(), (Object)user.getUsername());
            }
        }
        if (formData != null) {
            for (String key : formData.keySet()) {
                if (!key.startsWith("user.attributes.")) continue;
                String attribute = key.substring("user.attributes.".length());
                this.attributes.put(attribute, (String)formData.getFirst((Object)key));
            }
        }
    }

    public boolean isEditUsernameAllowed() {
        return this.user.isEditUsernameAllowed();
    }

    public String getUsername() {
        return this.formData != null ? (String)this.formData.getFirst((Object)"username") : this.user.getUsername();
    }

    public String getFirstName() {
        return this.formData != null ? (String)this.formData.getFirst((Object)"firstName") : this.user.getFirstName();
    }

    public String getLastName() {
        return this.formData != null ? (String)this.formData.getFirst((Object)"lastName") : this.user.getLastName();
    }

    public String getEmail() {
        return this.formData != null ? (String)this.formData.getFirst((Object)"email") : this.user.getEmail();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

