/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.resource;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authorization.admin.ResourceSetService;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.protection.resource.UmaResourceRepresentation;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.services.ErrorResponseException;

public class ResourceService {
    private final ResourceServer resourceServer;
    private final ResourceSetService resourceManager;
    private final KeycloakSession session;
    private final Identity identity;

    public ResourceService(KeycloakSession session, ResourceServer resourceServer, Identity identity, ResourceSetService resourceManager) {
        this.session = session;
        this.identity = identity;
        this.resourceServer = resourceServer;
        this.resourceManager = resourceManager;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(UmaResourceRepresentation resource) {
        String ownerId;
        this.checkResourceServerSettings();
        if (resource == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ResourceOwnerRepresentation owner = resource.getOwner();
        if (owner == null) {
            owner = new ResourceOwnerRepresentation();
            resource.setOwner(owner);
        }
        if ((ownerId = owner.getId()) == null) {
            ownerId = this.identity.getId();
        }
        owner.setId(ownerId);
        ResourceRepresentation newResource = this.resourceManager.create(resource);
        this.resourceManager.audit(resource, resource.getId(), OperationType.CREATE);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new UmaResourceRepresentation(newResource)).build();
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="id") String id, ResourceRepresentation resource) {
        return this.resourceManager.update(id, resource);
    }

    @Path(value="/{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        this.checkResourceServerSettings();
        return this.resourceManager.delete(id);
    }

    @Path(value="/{id}")
    @GET
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="id") String id) {
        return this.resourceManager.findById(id, UmaResourceRepresentation::new);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response find(@QueryParam(value="_id") String id, @QueryParam(value="name") String name, @QueryParam(value="uri") String uri, @QueryParam(value="owner") String owner, @QueryParam(value="type") String type, @QueryParam(value="scope") String scope, @QueryParam(value="matchingUri") Boolean matchingUri, @QueryParam(value="deep") Boolean deep, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        if (deep != null && deep.booleanValue()) {
            return this.resourceManager.find(id, name, uri, owner, type, scope, matchingUri, deep, firstResult, maxResult);
        }
        return this.resourceManager.find(id, name, uri, owner, type, scope, matchingUri, deep, firstResult, maxResult, (resource, deep1) -> resource.getId());
    }

    private void checkResourceServerSettings() {
        if (!this.resourceServer.isAllowRemoteResourceManagement()) {
            throw new ErrorResponseException("not_supported", "Remote management is disabled.", Response.Status.BAD_REQUEST);
        }
    }
}

