/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.models.sessions.infinispan.util.InfinispanUtil;

public class RemoteCacheProvider {
    public static final String SCRIPT_CACHE_NAME = "___script_cache";
    protected static final Logger logger = Logger.getLogger(RemoteCacheProvider.class);
    private final Config.Scope config;
    private final EmbeddedCacheManager cacheManager;
    private final Map<String, RemoteCache> availableCaches = new HashMap<String, RemoteCache>();
    private final Map<String, RemoteCacheManager> managedManagers = new HashMap<String, RemoteCacheManager>();

    public RemoteCacheProvider(Config.Scope config, EmbeddedCacheManager cacheManager) {
        this.config = config;
        this.cacheManager = cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCache getRemoteCache(String cacheName) {
        if (this.availableCaches.get(cacheName) == null) {
            RemoteCacheProvider remoteCacheProvider = this;
            synchronized (remoteCacheProvider) {
                if (this.availableCaches.get(cacheName) == null) {
                    RemoteCache remoteCache = this.loadRemoteCache(cacheName);
                    this.availableCaches.put(cacheName, remoteCache);
                }
            }
        }
        return this.availableCaches.get(cacheName);
    }

    public void stop() {
        logger.debugf("Shutdown %d registered secured remoteCache managers", this.managedManagers.size());
        for (RemoteCacheManager mgr : this.managedManagers.values()) {
            mgr.stop();
        }
    }

    protected synchronized RemoteCache loadRemoteCache(String cacheName) {
        RemoteCache remoteCache = InfinispanUtil.getRemoteCache(this.cacheManager.getCache(cacheName));
        Boolean remoteStoreSecurity = this.config.getBoolean("remoteStoreSecurityEnabled");
        if (remoteStoreSecurity == null) {
            try {
                logger.debugf("Detecting remote security settings of HotRod server, cache %s. Disable by explicitly setting \"remoteStoreSecurityEnabled\" property in spi=connectionsInfinispan/provider=default", (Object)cacheName);
                remoteStoreSecurity = false;
                RemoteCache scriptCache = remoteCache.getRemoteCacheManager().getCache(SCRIPT_CACHE_NAME);
                if (scriptCache == null) {
                    logger.debug((Object)"Cannot detect remote security settings of HotRod server, disabling.");
                } else {
                    scriptCache.containsKey((Object)"");
                }
            }
            catch (HotRodClientException ex) {
                logger.debug((Object)"Seems that HotRod server requires authentication, enabling.");
                remoteStoreSecurity = true;
            }
        }
        if (remoteStoreSecurity.booleanValue()) {
            logger.infof("Remote store security for cache %s is enabled. Disable by setting \"remoteStoreSecurityEnabled\" property to \"false\" in spi=connectionsInfinispan/provider=default", (Object)cacheName);
            RemoteCacheManager securedMgr = this.getOrCreateSecuredRemoteCacheManager(this.config, cacheName, remoteCache.getRemoteCacheManager());
            return securedMgr.getCache(remoteCache.getName());
        }
        logger.infof("Remote store security for cache %s is disabled. If server fails to connect to remote JDG server, enable it.", (Object)cacheName);
        return remoteCache;
    }

    protected RemoteCacheManager getOrCreateSecuredRemoteCacheManager(Config.Scope config, String cacheName, RemoteCacheManager origManager) {
        String serverName = config.get("remoteStoreSecurityServerName", "keycloak-jdg-server");
        String realm = config.get("remoteStoreSecurityRealm", "AllowScriptManager");
        String username = config.get("remoteStoreSecurityUsername", "___script_manager");
        String password = config.get("remoteStoreSecurityPassword", "not-so-secret-password");
        Configuration origConfig = origManager.getConfiguration();
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder().read(origConfig);
        String securedHotRodEndpoint = origConfig.servers().stream().map(serverConfiguration -> serverConfiguration.host() + ":" + serverConfiguration.port()).collect(Collectors.joining(";"));
        if (this.managedManagers.containsKey(securedHotRodEndpoint)) {
            return this.managedManagers.get(securedHotRodEndpoint);
        }
        logger.infof("Creating secured RemoteCacheManager for Server: '%s', Cache: '%s', Realm: '%s', Username: '%s', Secured HotRod endpoint: '%s'", new Object[]{serverName, cacheName, realm, username, securedHotRodEndpoint});
        try {
            Field serversField = cfgBuilder.getClass().getDeclaredField("servers");
            Reflections.setAccessible((AccessibleObject)serversField);
            List origServers = (List)Reflections.getFieldValue((Field)serversField, (Object)cfgBuilder, List.class);
            origServers.clear();
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
        Configuration newConfig = cfgBuilder.addServers(securedHotRodEndpoint).security().authentication().serverName(serverName).saslMechanism("DIGEST-MD5").callbackHandler((CallbackHandler)new LoginHandler(username, password.toCharArray(), realm)).enable().build();
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(newConfig);
        this.managedManagers.put(securedHotRodEndpoint, remoteCacheManager);
        return remoteCacheManager;
    }

    private static class LoginHandler
    implements CallbackHandler {
        private final String login;
        private final char[] password;
        private final String realm;

        private LoginHandler(String login, char[] password, String realm) {
            this.login = login;
            this.password = password;
            this.realm = realm;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.login);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password);
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    ((RealmCallback)callback).setText(this.realm);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

