/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.HardcodedLDAPRoleStorageMapper;

public class HardcodedLDAPRoleStorageMapperFactory
extends AbstractLDAPStorageMapperFactory {
    public static final String PROVIDER_ID = "hardcoded-ldap-role-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    @Override
    public String getHelpText() {
        return "When user is imported from LDAP, he will be automatically added into this configured role.";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        String roleName = (String)config.getConfig().getFirst((Object)"role");
        if (roleName == null) {
            throw new ComponentValidationException("Role can't be null", new Object[0]);
        }
        RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
        if (role == null) {
            throw new ComponentValidationException("There is no role corresponding to configured value", new Object[0]);
        }
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new HardcodedLDAPRoleStorageMapper(mapperModel, federationProvider);
    }

    static {
        ProviderConfigProperty roleAttr = HardcodedLDAPRoleStorageMapperFactory.createConfigProperty("role", "Role", "Role to grant to user.  Click 'Select Role' button to browse roles, or just type it in the textbox.  To reference an application role the syntax is appname.approle, i.e. myapp.myrole", "Role", null);
        configProperties.add(roleAttr);
    }
}

