/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.logging;

import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYMSG", length=4)
public interface MessagingLogger
extends BasicLogger {
    public static final MessagingLogger ROOT_LOGGER = (MessagingLogger)Logger.getMessageLogger(MessagingLogger.class, (String)"org.jboss.as.messaging");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="Element %s is deprecated and will not be taken into account")
    public void deprecatedXMLElement(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Attribute %s is deprecated and will not be taken into account")
    public void deprecatedXMLAttribute(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="Attribute %s of the resource at %s is deprecated and setting its value will not be taken into account")
    public void deprecatedAttribute(String var1, PathAddress var2);

    @Message(id=14, value="Can not change the clustered attribute to false: The hornetq-server resource at %s has cluster-connection children resources and will remain clustered.")
    public String canNotChangeClusteredAttribute(PathAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="Element %s is deprecated and %s will be used in its place")
    public void deprecatedXMLElement(String var1, String var2);

    @Message(id=19, value="Alternative attribute of (%s) is already defined.")
    public String altAttributeAlreadyDefined(String var1);

    @Message(id=20, value="All attribute definitions must have the same xml name -- found %s but already had %s")
    public IllegalArgumentException attributeDefinitionsMustMatch(String var1, String var2);

    @Message(id=21, value="All attribute definitions must have unique names -- already found %s")
    public IllegalArgumentException attributeDefinitionsNotUnique(String var1);

    @Message(id=23, value="Operation cannot include both parameter %s and parameter %s")
    public String cannotIncludeOperationParameters(String var1, String var2);

    @Message(id=34, value="Ignoring unhandled element: %s, at: %s")
    public XMLStreamException ignoringUnhandledElement(Element var1, String var2);

    @Message(id=35, value="Illegal element %s: cannot be used when %s is used")
    public String illegalElement(String var1, String var2);

    @Message(id=36, value="Illegal value %s for element %s")
    public String illegalValue(Object var1, String var2);

    @Message(id=-1, value="Illegal value %s for element %s as it could not be converted to required type %s")
    public String illegalValue(Object var1, String var2, ModelType var3);

    @Message(id=38, value="%s is invalid")
    public String invalid(Object var1);

    @Message(id=40, value="Operation must include parameter %s or parameter %s")
    public String invalidOperationParameters(String var1, String var2);

    @Message(id=44, value="Multiple %s children found; only one is allowed")
    public IllegalStateException multipleChildrenFound(String var1);

    @Message(id=45, value="%s is required")
    public String required(Object var1);

    @Message(id=46, value="Either %s or %s is required")
    public String required(Object var1, Object var2);

    @Message(id=51, value="Implement support for element %s")
    public UnsupportedOperationException unsupportedElement(String var1);

    @Message(id=59, value="Only one of %s or %s is required")
    public String onlyOneRequired(Object var1, Object var2);

    @Message(id=67, value="The broadcast group '%s' defines reference to nonexistent connector '%s'. Available connectors '%s'.")
    public OperationFailedException wrongConnectorRefInBroadCastGroup(String var1, String var2, Collection<String> var3);

    @Message(id=69, value="Attribute (%s) can not been undefined as the resource does not define any alternative to this attribute.")
    public String undefineAttributeWithoutAlternative(String var1);

    @Message(id=70, value="Attributes %s is an alias for attribute %s; both cannot be set with conflicting values.")
    public OperationFailedException inconsistentStatisticsSettings(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=71, value="There is no resource matching the expiry-address %s for the address-settings %s, expired messages from destinations matching this address-setting will be lost!")
    public void noMatchingExpiryAddress(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=72, value="There is no resource matching the dead-letter-address %s for the address-settings %s, undelivered messages from destinations matching this address-setting will be lost!")
    public void noMatchingDeadLetterAddress(String var1, String var2);

    @Message(id=76, value="Parameter %s contains duplicate elements [%s]")
    public OperationFailedException duplicateElements(String var1, ModelNode var2);

    @Message(id=79, value="The migrate operation can not be performed: the server must be in admin-only mode")
    public OperationFailedException migrateOperationAllowedOnlyInAdminOnly();

    @Message(id=80, value="Can not migrate attribute %s to resource %s. Use instead the socket-binding attribute to configure this broadcast-group.")
    public String couldNotMigrateBroadcastGroupAttribute(String var1, PathAddress var2);

    @Message(id=81, value="Migration failed, see results for more details.")
    public String migrationFailed();

    @Message(id=82, value="Classes providing the %s are discarded during the migration. To use them in the new messaging-activemq subsystem, you will have to extend the Artemis-based Interceptor.")
    public String couldNotMigrateInterceptors(String var1);

    @Message(id=83, value="Can not migrate the HA configuration of %s. Its shared-store and backup attributes holds expressions and it is not possible to determine unambiguously how to create the corresponding ha-policy for the messaging-activemq's server.")
    public String couldNotMigrateHA(PathAddress var1);

    @Message(id=84, value="Can not migrate attribute %s to resource %s. Use instead the socket-binding attribute to configure this discovery-group.")
    public String couldNotMigrateDiscoveryGroupAttribute(String var1, PathAddress var2);

    @Message(id=85, value="Can not create a legacy-connection-factory based on connection-factory %s. It uses a HornetQ in-vm connector that is not compatible with Artemis in-vm connector ")
    public String couldNotCreateLegacyConnectionFactoryUsingInVMConnector(PathAddress var1);

    @Message(id=86, value="Can not migrate attribute %s to resource %s. The attribute uses an expression that can be resolved differently depending on system properties. After migration, this attribute must be added back with an actual value instead of the expression.")
    public String couldNotMigrateResourceAttributeWithExpression(String var1, PathAddress var2);

    @Message(id=87, value="Can not migrate attribute %s to resource %s. This attribute is not supported by the new messaging-activemq subsystem.")
    public String couldNotMigrateUnsupportedAttribute(String var1, PathAddress var2);

    @Message(id=88, value="Can not migrate attribute failback-delay to resource %s. Artemis detects failback deterministically and it no longer requires to specify a delay for failback to occur.")
    public String couldNotMigrateFailbackDelayAttribute(PathAddress var1);
}

