/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DownloadAlongPanel
extends JPanel {
    private final String prefOsm;
    private final String prefGps;
    private final String prefDist;
    private final String prefArea;
    private final String prefNear;
    private final JCheckBox cbDownloadOsmData;
    private final JCheckBox cbDownloadGpxData;
    private final JSpinner buffer;
    private final JSpinner maxRect;
    private final JList<String> downloadNear;

    public DownloadAlongPanel(String prefOsm, String prefGps, String prefDist, String prefArea, String prefNear) {
        super(new GridBagLayout());
        this.prefOsm = prefOsm;
        this.prefGps = prefGps;
        this.prefDist = prefDist;
        this.prefArea = prefArea;
        this.prefNear = prefNear;
        this.cbDownloadOsmData = new JCheckBox(I18n.tr("OpenStreetMap data", new Object[0]), Config.getPref().getBoolean(prefOsm, true));
        this.cbDownloadOsmData.setToolTipText(I18n.tr("Select to download OSM data.", new Object[0]));
        this.add((Component)this.cbDownloadOsmData, GBC.std().insets(1, 5, 1, 5));
        this.cbDownloadGpxData = new JCheckBox(I18n.tr("Raw GPS data", new Object[0]), Config.getPref().getBoolean(prefGps, false));
        this.cbDownloadGpxData.setToolTipText(I18n.tr("Select to download GPS traces.", new Object[0]));
        this.add((Component)this.cbDownloadGpxData, GBC.eol().insets(5, 5, 1, 5));
        this.add((Component)new JLabel(I18n.tr("Download everything within:", new Object[0])), GBC.std());
        this.buffer = new JSpinner(new SpinnerNumberModel(Config.getPref().getDouble(prefDist, 50.0), 10.0, 5000.0, 1.0));
        this.add((Component)this.buffer, GBC.std().insets(5, 5, 5, 5));
        this.add((Component)new JLabel(I18n.tr("meters", new Object[0])), GBC.eol());
        this.add((Component)new JLabel(I18n.tr("Maximum area per request:", new Object[0])), GBC.std());
        this.maxRect = new JSpinner(new SpinnerNumberModel(Config.getPref().getDouble(prefArea, 20.0), 0.01, 25.0, 1.0)){

            @Override
            public Dimension getPreferredSize() {
                return DownloadAlongPanel.this.buffer.getPreferredSize();
            }
        };
        this.add((Component)this.maxRect, GBC.std().insets(5, 5, 5, 5));
        this.add((Component)new JLabel("km\u00b2"), GBC.eol());
        if (prefNear != null) {
            this.add((Component)new JLabel(I18n.tr("Download near:", new Object[0])), GBC.eol());
            this.downloadNear = new JList<String>(new String[]{I18n.tr("track only", new Object[0]), I18n.tr("waypoints only", new Object[0]), I18n.tr("track and waypoints", new Object[0])});
            this.downloadNear.setSelectedIndex(Config.getPref().getInt(prefNear, 0));
            this.add(this.downloadNear, GBC.eol());
        } else {
            this.downloadNear = null;
        }
    }

    public final double getDistance() {
        return (Double)this.buffer.getValue();
    }

    public final double getArea() {
        return (Double)this.maxRect.getValue();
    }

    public final int getNear() {
        return this.downloadNear.getSelectedIndex();
    }

    public boolean isDownloadOsmData() {
        return this.cbDownloadOsmData.isSelected();
    }

    public boolean isDownloadGpxData() {
        return this.cbDownloadGpxData.isSelected();
    }

    protected final void rememberSettings() {
        Config.getPref().putBoolean(this.prefOsm, this.isDownloadOsmData());
        Config.getPref().putBoolean(this.prefGps, this.isDownloadGpxData());
        Config.getPref().putDouble(this.prefDist, this.getDistance());
        Config.getPref().putDouble(this.prefArea, this.getArea());
        if (this.prefNear != null) {
            Config.getPref().putInt(this.prefNear, this.getNear());
        }
    }

    protected final void addChangeListener(ChangeListener listener) {
        this.cbDownloadGpxData.addChangeListener(listener);
        this.cbDownloadOsmData.addChangeListener(listener);
    }

    public int showInDownloadDialog(String title, String helpTopic) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Download", new Object[0]), new ImageProvider("download"), I18n.tr("Click to download", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Download as new layer", new Object[0]), new ImageProvider("download_new_layer"), I18n.tr("Click to download into a new data layer", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to cancel", new Object[0]), null)};
        this.addChangeListener(e -> options[0].setEnabled(this.isDownloadOsmData() || this.isDownloadGpxData()));
        int ret = HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), this, title, 3, null, options, options[0], helpTopic);
        if (0 == ret || 1 == ret) {
            this.rememberSettings();
        }
        return ret;
    }
}

