/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public class DefaultExtendsDescriptor
implements ExtendsDescriptor {
    private ModuleDescriptor parent;
    private String location;
    private List extendsTypes;
    private boolean local;

    public DefaultExtendsDescriptor(ModuleDescriptor parent, String location, String[] types) {
        this(parent, location, types, false);
    }

    public DefaultExtendsDescriptor(ModuleDescriptor parent, String location, String[] types, boolean local) {
        this.parent = parent;
        this.location = location;
        this.local = local;
        this.extendsTypes = new ArrayList(types.length);
        for (int i = 0; i < types.length; ++i) {
            this.extendsTypes.add(types[i]);
        }
    }

    @Override
    public ModuleRevisionId getParentRevisionId() {
        return this.parent.getModuleRevisionId();
    }

    @Override
    public ModuleRevisionId getResolvedParentRevisionId() {
        return this.parent.getResolvedModuleRevisionId();
    }

    @Override
    public ModuleDescriptor getParentMd() {
        return this.parent;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String[] getExtendsTypes() {
        return this.extendsTypes.toArray(new String[this.extendsTypes.size()]);
    }

    @Override
    public boolean isAllInherited() {
        return this.extendsTypes.contains("all");
    }

    @Override
    public boolean isInfoInherited() {
        return this.isAllInherited() || this.extendsTypes.contains("info");
    }

    @Override
    public boolean isDescriptionInherited() {
        return this.isAllInherited() || this.extendsTypes.contains("description");
    }

    @Override
    public boolean areConfigurationsInherited() {
        return this.isAllInherited() || this.extendsTypes.contains("configurations");
    }

    @Override
    public boolean areDependenciesInherited() {
        return this.isAllInherited() || this.extendsTypes.contains("dependencies");
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }
}

