/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.ReflectionMethodConstructorInjectionPoint;
import io.micronaut.context.exceptions.CircularDependencyException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.ProxyBeanDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

@Internal
public class DefaultBeanResolutionContext
extends LinkedHashMap<String, Object>
implements BeanResolutionContext {
    private final BeanContext context;
    private final BeanDefinition rootDefinition;
    private final BeanResolutionContext.Path path;
    private final Map<BeanIdentifier, Object> inFlightBeans = new HashMap<BeanIdentifier, Object>(2);

    @Internal
    public DefaultBeanResolutionContext(BeanContext context, BeanDefinition rootDefinition) {
        this.context = context;
        this.rootDefinition = rootDefinition;
        this.path = new DefaultPath();
    }

    @Override
    public BeanContext getContext() {
        return this.context;
    }

    @Override
    public BeanDefinition getRootDefinition() {
        return this.rootDefinition;
    }

    @Override
    public BeanResolutionContext.Path getPath() {
        return this.path;
    }

    @Override
    public <T> void addInFlightBean(BeanIdentifier beanIdentifier, T instance) {
        this.inFlightBeans.put(beanIdentifier, instance);
    }

    @Override
    @Nullable
    public <T> T getInFlightBean(BeanIdentifier beanIdentifier) {
        return (T)this.inFlightBeans.get(beanIdentifier);
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        Object value = this.get(name);
        if (value != null && conversionContext.getArgument().getType().isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    static abstract class AbstractSegment
    implements BeanResolutionContext.Segment {
        private final BeanDefinition declaringComponent;
        private final String name;
        private final Argument argument;

        AbstractSegment(BeanDefinition declaringClass, String name, Argument argument) {
            this.declaringComponent = declaringClass;
            this.name = name;
            this.argument = argument;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public BeanDefinition getDeclaringType() {
            return this.declaringComponent;
        }

        @Override
        public Argument getArgument() {
            return this.argument;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractSegment that = (AbstractSegment)o;
            return this.declaringComponent.equals(that.declaringComponent) && this.name.equals(that.name) && this.argument.equals(that.argument);
        }

        public int hashCode() {
            int result = this.declaringComponent.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.argument.hashCode();
            return result;
        }

        void outputArguments(BeanDefinition declaringType, StringBuilder baseString) {
            Argument<?>[] arguments = declaringType.getConstructor().getArguments();
            this.outputArguments(baseString, arguments);
        }

        void outputArguments(StringBuilder baseString, Argument[] arguments) {
            baseString.append('(');
            for (int i = 0; i < arguments.length; ++i) {
                Argument argument = arguments[i];
                boolean isInjectedArgument = argument.equals(this.getArgument());
                if (isInjectedArgument) {
                    baseString.append('[');
                }
                baseString.append(argument.toString());
                if (isInjectedArgument) {
                    baseString.append(']');
                }
                if (i == arguments.length - 1) continue;
                baseString.append(',');
            }
            baseString.append(')');
        }
    }

    static class FieldSegment
    extends AbstractSegment {
        FieldSegment(BeanDefinition declaringClass, FieldInjectionPoint fieldInjectionPoint) {
            super(declaringClass, fieldInjectionPoint.getName(), fieldInjectionPoint.asArgument());
        }

        public String toString() {
            return this.getDeclaringType().getBeanType().getSimpleName() + "." + this.getName();
        }
    }

    static class MethodSegment
    extends AbstractSegment {
        private final MethodInjectionPoint methodInjectionPoint;

        MethodSegment(BeanDefinition declaringType, MethodInjectionPoint methodInjectionPoint, Argument argument) {
            super(declaringType, methodInjectionPoint.getName(), argument);
            this.methodInjectionPoint = methodInjectionPoint;
        }

        public String toString() {
            StringBuilder baseString = new StringBuilder(this.methodInjectionPoint.getDeclaringBean().getBeanType().getSimpleName()).append('.');
            baseString.append(this.getName());
            this.outputArguments(baseString, this.methodInjectionPoint.getArguments());
            return baseString.toString();
        }
    }

    static class ConstructorSegment
    extends AbstractSegment {
        ConstructorSegment(BeanDefinition declaringClass, Argument argument) {
            super(declaringClass, declaringClass.getBeanType().getName(), argument);
        }

        public String toString() {
            ConstructorInjectionPoint constructorInjectionPoint = this.getDeclaringType().getConstructor();
            if (constructorInjectionPoint instanceof MethodInjectionPoint) {
                MethodInjectionPoint methodInjectionPoint = (MethodInjectionPoint)((Object)constructorInjectionPoint);
                StringBuilder baseString = new StringBuilder(methodInjectionPoint.getDeclaringBean().getBeanType().getSimpleName()).append('.');
                baseString.append(methodInjectionPoint.getName());
                this.outputArguments(baseString, methodInjectionPoint.getArguments());
                return baseString.toString();
            }
            StringBuilder baseString = new StringBuilder("new ");
            BeanDefinition declaringType = this.getDeclaringType();
            baseString.append(declaringType.getBeanType().getSimpleName());
            this.outputArguments(declaringType, baseString);
            return baseString.toString();
        }
    }

    class DefaultPath
    extends LinkedList<BeanResolutionContext.Segment>
    implements BeanResolutionContext.Path {
        public static final String RIGHT_ARROW = " --> ";

        DefaultPath() {
        }

        @Override
        public String toString() {
            Iterator i = this.descendingIterator();
            StringBuilder path = new StringBuilder();
            while (i.hasNext()) {
                path.append(((BeanResolutionContext.Segment)i.next()).toString());
                if (!i.hasNext()) continue;
                path.append(RIGHT_ARROW);
            }
            return path.toString();
        }

        @Override
        public String toCircularString() {
            Iterator i = this.descendingIterator();
            StringBuilder path = new StringBuilder();
            String ls = System.getProperty("line.separator");
            while (i.hasNext()) {
                String segmentString = ((BeanResolutionContext.Segment)i.next()).toString();
                path.append(segmentString);
                if (i.hasNext()) {
                    path.append(RIGHT_ARROW);
                    continue;
                }
                int totalLength = path.length() - 3;
                String spaces = String.join((CharSequence)"", Collections.nCopies(totalLength, " "));
                path.append(ls).append("^").append(spaces).append("|").append(ls).append("|").append(spaces).append("|").append(ls).append("|").append(spaces).append("|").append(ls).append('+');
                path.append(String.join((CharSequence)"", Collections.nCopies(totalLength, "-"))).append('+');
            }
            return path.toString();
        }

        @Override
        public Optional<BeanResolutionContext.Segment> currentSegment() {
            return Optional.ofNullable(this.peek());
        }

        @Override
        public BeanResolutionContext.Path pushConstructorResolve(BeanDefinition declaringType, Argument argument) {
            ConstructorInjectionPoint constructor = declaringType.getConstructor();
            if (constructor instanceof ReflectionMethodConstructorInjectionPoint) {
                MethodSegment methodSegment = new MethodSegment(declaringType, (MethodInjectionPoint)((Object)constructor), argument);
                if (this.contains(methodSegment)) {
                    throw new CircularDependencyException((BeanResolutionContext)DefaultBeanResolutionContext.this, argument, "Circular dependency detected");
                }
                DefaultBeanResolutionContext.this.path.push(methodSegment);
            } else {
                ConstructorSegment constructorSegment = new ConstructorSegment(declaringType, argument);
                this.detectCircularDependency(declaringType, argument, constructorSegment);
            }
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushMethodArgumentResolve(BeanDefinition declaringType, MethodInjectionPoint methodInjectionPoint, Argument argument) {
            MethodSegment methodSegment = new MethodSegment(declaringType, methodInjectionPoint, argument);
            if (this.contains(methodSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)DefaultBeanResolutionContext.this, methodInjectionPoint, argument, "Circular dependency detected");
            }
            this.push(methodSegment);
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushFieldResolve(BeanDefinition declaringType, FieldInjectionPoint fieldInjectionPoint) {
            FieldSegment fieldSegment = new FieldSegment(declaringType, fieldInjectionPoint);
            if (this.contains(fieldSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)DefaultBeanResolutionContext.this, fieldInjectionPoint, "Circular dependency detected");
            }
            this.push(fieldSegment);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void detectCircularDependency(BeanDefinition declaringType, Argument argument, BeanResolutionContext.Segment constructorSegment) {
            if (this.contains(constructorSegment)) {
                BeanResolutionContext.Segment last = (BeanResolutionContext.Segment)this.peek();
                if (last == null) throw new CircularDependencyException((BeanResolutionContext)DefaultBeanResolutionContext.this, argument, "Circular dependency detected");
                BeanDefinition declaringBean = last.getDeclaringType();
                if (!declaringBean.equals(declaringType)) {
                    if (declaringType instanceof ProxyBeanDefinition) {
                        if (!((ProxyBeanDefinition)declaringType).getTargetDefinitionType().equals(declaringBean.getClass())) {
                            throw new CircularDependencyException((BeanResolutionContext)DefaultBeanResolutionContext.this, argument, "Circular dependency detected");
                        }
                        this.push(constructorSegment);
                        return;
                    } else {
                        if (!(declaringBean instanceof ProxyBeanDefinition)) throw new CircularDependencyException((BeanResolutionContext)DefaultBeanResolutionContext.this, argument, "Circular dependency detected");
                        if (!((ProxyBeanDefinition)declaringBean).getTargetDefinitionType().equals(declaringType.getClass())) {
                            throw new CircularDependencyException((BeanResolutionContext)DefaultBeanResolutionContext.this, argument, "Circular dependency detected");
                        }
                        this.push(constructorSegment);
                    }
                    return;
                } else {
                    this.push(constructorSegment);
                }
                return;
            } else {
                this.push(constructorSegment);
            }
        }
    }
}

