/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class ModuleDependencyMetadataWrapper
implements ModuleDependencyMetadata {
    private final DependencyMetadata delegate;
    private final boolean isTransitive;

    public ModuleDependencyMetadataWrapper(DependencyMetadata delegate) {
        this.delegate = delegate;
        this.isTransitive = delegate.isTransitive();
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.delegate.getArtifacts();
    }

    @Override
    public ModuleDependencyMetadata withRequestedVersion(VersionConstraint requestedVersion) {
        ModuleComponentSelector selector = this.getSelector();
        ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getModuleIdentifier(), requestedVersion, selector.getAttributes(), selector.getRequestedCapabilities());
        return new ModuleDependencyMetadataWrapper(this.delegate.withTarget((ComponentSelector)newSelector));
    }

    @Override
    public ModuleDependencyMetadata withReason(String reason) {
        return new ModuleDependencyMetadataWrapper(this.delegate.withReason(reason));
    }

    @Override
    public ModuleDependencyMetadata withEndorseStrictVersions(boolean endorse) {
        if (this.delegate instanceof ModuleDependencyMetadata) {
            return new ModuleDependencyMetadataWrapper(((ModuleDependencyMetadata)this.delegate).withEndorseStrictVersions(endorse));
        }
        return this;
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        return this.delegate.withTarget(target);
    }

    @Override
    public ModuleComponentSelector getSelector() {
        return (ModuleComponentSelector)this.delegate.getSelector();
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.delegate.getExcludes();
    }

    @Override
    public List<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema, Collection<? extends Capability> explicitRequestedCapabilities) {
        return this.delegate.selectConfigurations(consumerAttributes, targetComponent, consumerSchema, explicitRequestedCapabilities);
    }

    @Override
    public boolean isChanging() {
        return this.delegate.isChanging();
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive;
    }

    @Override
    public boolean isConstraint() {
        return this.delegate.isConstraint();
    }

    @Override
    public boolean isEndorsingStrictVersions() {
        return this.delegate.isEndorsingStrictVersions();
    }

    @Override
    public String getReason() {
        return this.delegate.getReason();
    }
}

