/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.pico;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.kotlin.org.picocontainer.ComponentMonitor;
import org.jetbrains.kotlin.org.picocontainer.Parameter;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.org.picocontainer.PicoInitializationException;
import org.jetbrains.kotlin.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.kotlin.org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.jetbrains.kotlin.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.CyclicDependencyException;
import org.jetbrains.kotlin.org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.defaults.NotConcreteRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.jetbrains.kotlin.org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class CachingConstructorInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private static final ThreadLocal<Set<CachingConstructorInjectionComponentAdapter>> ourGuard = new ThreadLocal();
    private Object myInstance;

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (componentKey == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(0);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(1);
        }
        super(componentKey, componentImplementation, parameters2, allowNonPublicClasses, DefaultPicoContainer.DEFAULT_DELEGATING_COMPONENT_MONITOR, DefaultPicoContainer.DEFAULT_LIFECYCLE_STRATEGY);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters2) {
        if (componentKey == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(2);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(3);
        }
        this(componentKey, componentImplementation, parameters2, false);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (componentKey == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(4);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(5);
        }
        this(componentKey, componentImplementation, (Parameter[])null);
    }

    @Override
    public Object getComponentInstance(@NotNull PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object instance;
        if (container == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(6);
        }
        if ((instance = this.myInstance) == null) {
            this.myInstance = instance = this.instantiateGuarded(container, this.getComponentImplementation());
        }
        return instance;
    }

    @NotNull
    private Object instantiateGuarded(@NotNull PicoContainer container, @NotNull Class<?> stackFrame) {
        Object object;
        Set<CachingConstructorInjectionComponentAdapter> currentStack;
        if (container == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(7);
        }
        if (stackFrame == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(8);
        }
        if ((currentStack = ourGuard.get()) == null) {
            currentStack = ContainerUtil.newIdentityTroveSet();
            ourGuard.set(currentStack);
        }
        if (currentStack.contains(this)) {
            throw new CyclicDependencyException(stackFrame);
        }
        try {
            currentStack.add(this);
            Object object2 = this.doGetComponentInstance(container);
            object = object2;
        }
        catch (CyclicDependencyException e) {
            e.push(stackFrame);
            throw e;
        }
        finally {
            currentStack.remove(this);
        }
        if (object == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    private Object doGetComponentInstance(@NotNull PicoContainer guardedContainer) {
        Object object;
        Constructor constructor;
        if (guardedContainer == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(10);
        }
        try {
            constructor = this.getGreediestSatisfiableConstructor(guardedContainer);
        }
        catch (AmbiguousComponentResolutionException e) {
            e.setComponent(this.getComponentImplementation());
            throw e;
        }
        ComponentMonitor componentMonitor = this.currentMonitor();
        try {
            Object[] parameters2 = this.getConstructorArguments(guardedContainer, constructor);
            componentMonitor.instantiating(constructor);
            long startTime = System.currentTimeMillis();
            Object inst = this.newInstance(constructor, parameters2);
            componentMonitor.instantiated(constructor, System.currentTimeMillis() - startTime);
            object = inst;
        }
        catch (InvocationTargetException e) {
            componentMonitor.instantiationFailed(constructor, e);
            ExceptionUtil.rethrowUnchecked(e.getTargetException());
            throw new PicoInvocationTargetInitializationException(e.getTargetException());
        }
        catch (InstantiationException e) {
            componentMonitor.instantiationFailed(constructor, e);
            throw new PicoInitializationException("Should never get here");
        }
        catch (IllegalAccessException e) {
            componentMonitor.instantiationFailed(constructor, e);
            throw new PicoInitializationException(e);
        }
        if (object == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(11);
        }
        return object;
    }

    @NotNull
    private Object[] getConstructorArguments(PicoContainer container, @NotNull Constructor ctor) {
        if (ctor == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(12);
        }
        Class[] parameterTypes = ctor.getParameterTypes();
        Object[] result2 = new Object[parameterTypes.length];
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
        for (int i = 0; i < currentParameters.length; ++i) {
            result2[i] = currentParameters[i].resolveInstance(container, this, parameterTypes[i]);
        }
        if (result2 == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(13);
        }
        return result2;
    }

    @Override
    @NotNull
    protected Constructor getGreediestSatisfiableConstructor(@NotNull PicoContainer container) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (container == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(14);
        }
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        HashSet<List<Class>> unsatisfiableDependencyTypes = new HashSet<List<Class>>();
        List<Constructor> sortedMatchingConstructors = this.getSortedMatchingConstructors();
        Constructor greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Class unsatisfiedDependencyType = null;
        for (Constructor constructor : sortedMatchingConstructors) {
            boolean failedDependency = false;
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                if (currentParameters[j].isResolvable(container, this, parameterTypes[j])) continue;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                unsatisfiedDependencyType = parameterTypes[j];
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    Constructor constructor2 = greediestConstructor;
                    if (constructor2 == null) {
                        CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(15);
                    }
                    return constructor2;
                }
                conflicts.add(constructor);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiedDependencyType, unsatisfiableDependencyTypes, container);
        }
        if (greediestConstructor == null) {
            HashSet<Constructor<?>> nonMatching = ContainerUtil.newHashSet(this.getConstructors());
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + nonMatching + " or the constructors were not accessible for '" + this.getComponentImplementation() + "'");
        }
        Constructor constructor = greediestConstructor;
        if (constructor == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(16);
        }
        return constructor;
    }

    private List<Constructor> getSortedMatchingConstructors() {
        ArrayList<Constructor> matchingConstructors = new ArrayList<Constructor>();
        for (Constructor<?> constructor : this.getConstructors()) {
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length || !this.allowNonPublicClasses && (constructor.getModifiers() & 1) == 0) continue;
            matchingConstructors.add(constructor);
        }
        if (this.parameters == null) {
            matchingConstructors.sort((arg0, arg1) -> arg1.getParameterTypes().length - arg0.getParameterTypes().length);
        }
        return matchingConstructors;
    }

    @NotNull
    private Constructor<?>[] getConstructors() {
        Constructor[] constructorArray = AccessController.doPrivileged(() -> this.getComponentImplementation().getDeclaredConstructors());
        if (constructorArray == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(17);
        }
        return constructorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
            case 6: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrame";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/pico/CachingConstructorInjectionComponentAdapter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guardedContainer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/pico/CachingConstructorInjectionComponentAdapter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateGuarded";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetComponentInstance";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorArguments";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGreediestSatisfiableConstructor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstance";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "instantiateGuarded";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGetComponentInstance";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorArguments";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getGreediestSatisfiableConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

