define(["events","appStorage","wakeOnLan"],function(events,appStorage,wakeOnLan){"use strict";function replaceAll(originalString,strReplace,strWith){var reg=new RegExp(strReplace,"ig");return originalString.replace(reg,strWith)}function paramsToString(params){var values=[];for(var key in params){var value=params[key];null!=value&&""!==value&&values.push(encodeURIComponent(key)+"="+encodeURIComponent(value))}return values.join("&")}function fetchWithTimeout(url,options,timeoutMs){return new Promise(function(resolve,reject){var timeout=setTimeout(reject,timeoutMs);(options=options||{}).credentials="same-origin",fetch(url,options).then(function(response){clearTimeout(timeout),resolve(response)},function(error){clearTimeout(timeout),reject(error)})})}function getFetchPromise(request){var headers=request.headers||{};"json"===request.dataType&&(headers.accept="application/json");var fetchRequest={headers:headers,method:request.type,credentials:"same-origin"},contentType=request.contentType;return request.data&&("string"==typeof request.data?fetchRequest.body=request.data:(fetchRequest.body=paramsToString(request.data),contentType=contentType||"application/x-www-form-urlencoded; charset=UTF-8")),contentType&&(headers["Content-Type"]=contentType),request.timeout?fetchWithTimeout(request.url,fetchRequest,request.timeout):fetch(request.url,fetchRequest)}function ApiClient(serverAddress,appName,appVersion,deviceName,deviceId,devicePixelRatio){if(!serverAddress)throw new Error("Must supply a serverAddress");console.log("ApiClient serverAddress: "+serverAddress),console.log("ApiClient appName: "+appName),console.log("ApiClient appVersion: "+appVersion),console.log("ApiClient deviceName: "+deviceName),console.log("ApiClient deviceId: "+deviceId),this._serverInfo={},this._serverAddress=serverAddress,this._deviceId=deviceId,this._deviceName=deviceName,this._appName=appName,this._appVersion=appVersion,this._devicePixelRatio=devicePixelRatio}function setSavedEndpointInfo(instance,info){instance._endPointInfo=info}function onNetworkChanged(instance,resetAddress){if(resetAddress){instance.connected=!1;var serverInfo=instance.serverInfo(),newAddress=function(instance,serverInfo){if(serverInfo.LocalAddress&&allowAddress(instance,serverInfo.LocalAddress))return serverInfo.LocalAddress;if(serverInfo.ManualAddress&&allowAddress(instance,serverInfo.ManualAddress))return serverInfo.ManualAddress;if(serverInfo.RemoteAddress&&allowAddress(instance,serverInfo.RemoteAddress))return serverInfo.RemoteAddress;return null}(instance,serverInfo);newAddress&&(instance._serverAddress=newAddress)}setSavedEndpointInfo(instance,null)}function tryReconnectToUrl(instance,url,delay){return console.log("tryReconnectToUrl: "+url),setTimeoutPromise(delay).then(function(){return fetchWithTimeout(instance.getUrl("system/info/public",null,url),{method:"GET",accept:"application/json"},15e3).then(function(){return url})})}function allowAddress(instance,address){return!instance.rejectInsecureAddresses||0===address.indexOf("https:")}function setTimeoutPromise(timeout){return new Promise(function(resolve,reject){setTimeout(resolve,timeout)})}function tryReconnectInternal(instance){var addresses=[],addressesStrings=[],serverInfo=instance.serverInfo();if(serverInfo.LocalAddress&&-1===addressesStrings.indexOf(serverInfo.LocalAddress)&&allowAddress(instance,serverInfo.LocalAddress)&&(addresses.push({url:serverInfo.LocalAddress,timeout:0}),addressesStrings.push(addresses[addresses.length-1].url)),serverInfo.ManualAddress&&-1===addressesStrings.indexOf(serverInfo.ManualAddress)&&allowAddress(instance,serverInfo.ManualAddress)&&(addresses.push({url:serverInfo.ManualAddress,timeout:100}),addressesStrings.push(addresses[addresses.length-1].url)),serverInfo.RemoteAddress&&-1===addressesStrings.indexOf(serverInfo.RemoteAddress)&&allowAddress(instance,serverInfo.RemoteAddress)&&(addresses.push({url:serverInfo.RemoteAddress,timeout:200}),addressesStrings.push(addresses[addresses.length-1].url)),console.log("tryReconnect: "+addressesStrings.join("|")),!addressesStrings.length)return Promise.reject();for(var promises=[],i=0,length=addresses.length;i<length;i++)promises.push(tryReconnectToUrl(instance,addresses[i].url,addresses[i].timeout));return function(promises){return new Promise(function(resolve,reject){for(var rejections=0,numPromises=promises.length,onReject=function(err){numPromises<=++rejections&&reject(err)},i=0;i<numPromises;i++)promises[i].then(resolve,onReject)})}(promises).then(function(url){return instance.serverAddress(url),Promise.resolve(url)})}function getUserCacheKey(userId,serverId){return"user-"+userId+"-"+serverId}function getCachedUser(instance,userId){var serverId=instance.serverId();if(!serverId)return null;var json=appStorage.getItem(getUserCacheKey(userId,serverId));if(json){var user=JSON.parse(json);return user&&setUserProperties(user),user}return null}function saveUserInCache(user){setUserProperties(user),user.DateLastFetched=Date.now(),appStorage.setItem(getUserCacheKey(user.Id,user.ServerId),JSON.stringify(user))}function removeCachedUser(userId,serverId){appStorage.removeItem(getUserCacheKey(userId,serverId))}ApiClient.prototype.appName=function(){return this._appName},ApiClient.prototype.setRequestHeaders=function(headers,includeAccessToken){var currentServerInfo=this.serverInfo(),appName=this._appName,accessToken=currentServerInfo.AccessToken,values=[];if(appName&&values.push('Client="'+appName+'"'),this._deviceName&&values.push('Device="'+this._deviceName+'"'),this._deviceId&&values.push('DeviceId="'+this._deviceId+'"'),this._appVersion&&values.push('Version="'+this._appVersion+'"'),accessToken&&!1!==includeAccessToken&&values.push('Token="'+accessToken+'"'),values.length){var auth="MediaBrowser "+values.join(", ");headers["X-Emby-Authorization"]=auth}},ApiClient.prototype.appVersion=function(){return this._appVersion},ApiClient.prototype.deviceName=function(){return this._deviceName},ApiClient.prototype.deviceId=function(){return this._deviceId},ApiClient.prototype.serverAddress=function(val){if(null!=val){if(0!==val.toLowerCase().indexOf("http"))throw new Error("Invalid url: "+val);this._serverAddress=val,onNetworkChanged(this)}return this._serverAddress},ApiClient.prototype.onNetworkChanged=function(){onNetworkChanged(this,!0)},ApiClient.prototype.getUrl=function(name,params,serverAddress){if(!name)throw new Error("Url name cannot be empty");var url=serverAddress||this._serverAddress;if(!url)throw new Error("serverAddress is yet not set");var lowered=url.toLowerCase();return-1===lowered.indexOf("/emby")&&-1===lowered.indexOf("/mediabrowser")&&(url+="/emby"),"/"!==name.charAt(0)&&(url+="/"),url+=name,(params=params&&paramsToString(params))&&(url+="?"+params),url},ApiClient.prototype.fetchWithFailover=function(request,enableReconnection){console.log("Requesting "+request.url),request.timeout=3e4;var instance=this;return getFetchPromise(request).then(function(response){return instance.connected=!0,response.status<400?"json"===request.dataType||"application/json"===request.headers.accept?response.json():"text"===request.dataType||0===(response.headers.get("Content-Type")||"").toLowerCase().indexOf("text/")?response.text():response:Promise.reject(response)},function(error){if(error?console.log("Request failed to "+request.url+" "+(error.status||"")+" "+error.toString()):console.log("Request timed out to "+request.url),error&&error.status||!enableReconnection)throw console.log("Reporting request failure"),error;console.log("Attempting reconnection");var previousServerAddress=instance.serverAddress();return function tryReconnect(instance,retryCount){retryCount=retryCount||0;var promise=tryReconnectInternal(instance);if(2<=retryCount)return promise;return promise.catch(function(err){return console.log("error in tryReconnectInternal: "+(err||"")),setTimeoutPromise(500).then(function(){return tryReconnect(instance,retryCount+1)})})}(instance).then(function(newServerAddress){return console.log("Reconnect succeeded"),instance.connected=!0,instance.enableWebSocketAutoConnect&&instance.ensureWebSocket(),request.url=request.url.replace(previousServerAddress,newServerAddress),instance.fetchWithFailover(request,!1)})})},ApiClient.prototype.fetch=function(request,includeAuthorization,includeAccessToken){if(!request)throw new Error("Request cannot be null");return request.headers=request.headers||{},!1!==includeAuthorization&&this.setRequestHeaders(request.headers,includeAccessToken),!1===this.enableAutomaticNetworking||"GET"!==request.type?(console.log("Requesting url without automatic networking: "+request.url),getFetchPromise(request).then(function(response){return response.status<400?"json"===request.dataType||"application/json"===request.headers.accept?response.json():"text"===request.dataType||0===(response.headers.get("Content-Type")||"").toLowerCase().indexOf("text/")?response.text():response:Promise.reject(response)})):this.fetchWithFailover(request,!0)},ApiClient.prototype.setAuthenticationInfo=function(accessKey,userId){this._serverInfo.AccessToken=accessKey,this._serverInfo.UserId!==userId&&(this._userViewsPromise=null),this._serverInfo.UserId=userId,refreshWakeOnLanInfoIfNeeded(this)},ApiClient.prototype.serverInfo=function(info){if(info){var currentUserId=this.getCurrentUserId();this._serverInfo=info,currentUserId!==this.getCurrentUserId()&&(this._userViewsPromise=null)}return this._serverInfo},ApiClient.prototype.getCurrentUserName=function(){var userId=this.getCurrentUserId();if(!userId)return null;var user=getCachedUser(this,userId);return null==user?null:user.Name},ApiClient.prototype.getCurrentUserId=function(){return this._serverInfo.UserId},ApiClient.prototype.accessToken=function(){return this._serverInfo.AccessToken},ApiClient.prototype.serverId=function(){return this.serverInfo().Id},ApiClient.prototype.serverName=function(){return this.serverInfo().Name},ApiClient.prototype.ajax=function(request,includeAuthorization,includeAccessToken){if(!request)throw new Error("Request cannot be null");return this.fetch(request,includeAuthorization,includeAccessToken)},ApiClient.prototype.getCurrentUser=function(enableCache){var userId=this.getCurrentUserId();return userId?this.getUser(userId,enableCache):Promise.reject()},ApiClient.prototype.isLoggedIn=function(){var info=this.serverInfo();return!!(info&&info.UserId&&info.AccessToken)},ApiClient.prototype.logout=function(){this.closeWebSocket();var done=function(){this.setAuthenticationInfo(null,null)}.bind(this);if(this.accessToken()){var url=this.getUrl("Sessions/Logout");return this.ajax({type:"POST",url:url}).then(done,done)}return done(),Promise.resolve()},ApiClient.prototype.authenticateUserByName=function(name,password){if(!name)return Promise.reject();var url=this.getUrl("Users/authenticatebyname"),instance=this,postData={Username:name,Pw:password||""};return instance.ajax({type:"POST",url:url,data:JSON.stringify(postData),dataType:"json",contentType:"application/json"}).then(function(result){instance._userViewsPromise=null,saveUserInCache(result.User);function afterOnAuthenticated(){return refreshWakeOnLanInfoIfNeeded(instance),result}return instance.onAuthenticated?instance.onAuthenticated(instance,result).then(afterOnAuthenticated):(afterOnAuthenticated(),result)})},ApiClient.prototype.ensureWebSocket=function(){if(this.connected&&!this.isWebSocketOpenOrConnecting()&&this.isWebSocketSupported())try{this.openWebSocket()}catch(err){console.log("Error opening web socket: "+err)}};var messageIdsReceived={};function onMessageReceivedInternal(instance,msg){var messageId=msg.MessageId;if(messageId){if(messageIdsReceived[messageId])return;messageIdsReceived[messageId]=!0}var msgType=msg.MessageType;if("UserUpdated"===msgType||"UserConfigurationUpdated"===msgType||"UserPolicyUpdated"===msgType){var user=msg.Data;user.Id===instance.getCurrentUserId()&&(saveUserInCache(user),instance._userViewsPromise=null)}else"LibraryChanged"===msgType&&(instance._userViewsPromise=null);events.trigger(instance,"message",[msg])}function detectBitrateWithEndpointInfo(instance,endpointInfo){if(endpointInfo.IsInNetwork)return 14e7;if(instance.getMaxBandwidth){var maxRate=instance.getMaxBandwidth();if(maxRate)return maxRate}return 15e5}function getRemoteImagePrefix(instance,options){var urlPrefix;return options.artist?(urlPrefix="Artists/"+instance.encodeName(options.artist),delete options.artist):options.person?(urlPrefix="Persons/"+instance.encodeName(options.person),delete options.person):options.genre?(urlPrefix="Genres/"+instance.encodeName(options.genre),delete options.genre):options.musicGenre?(urlPrefix="MusicGenres/"+instance.encodeName(options.musicGenre),delete options.musicGenre):options.gameGenre?(urlPrefix="GameGenres/"+instance.encodeName(options.gameGenre),delete options.gameGenre):options.studio?(urlPrefix="Studios/"+instance.encodeName(options.studio),delete options.studio):(urlPrefix="Items/"+options.itemId,delete options.itemId),urlPrefix}function mapVirtualFolder(item){item.Type="VirtualFolder",item.Id=item.ItemId,item.IsFolder=!0}function setUsersProperties(response){return response.forEach(setUserProperties),Promise.resolve(response)}function setUserProperties(user){user.Type="User"}function normalizeImageOptions(instance,options){var ratio=instance._devicePixelRatio||1;ratio&&(options.minScale&&(ratio=Math.max(options.minScale,ratio)),options.width&&(options.width=Math.round(options.width*ratio)),options.height&&(options.height=Math.round(options.height*ratio)),options.maxWidth&&(options.maxWidth=Math.round(options.maxWidth*ratio)),options.maxHeight&&(options.maxHeight=Math.round(options.maxHeight*ratio))),options.quality=options.quality||instance.getDefaultImageQuality(options.type),instance.normalizeImageOptions&&instance.normalizeImageOptions(options)}function mapPrefix(i){return{Name:i}}ApiClient.prototype.openWebSocket=function(){var accessToken=this.accessToken();if(!accessToken)throw new Error("Cannot open web socket without access token.");var url=this.getUrl("socket");url=replaceAll(url=replaceAll(url=replaceAll(url,"emby/socket","embywebsocket"),"https:","wss:"),"http:","ws:"),url+="?api_key="+accessToken,url+="&deviceId="+this.deviceId(),console.log("opening web socket with url: "+url);var webSocket=new WebSocket(url);webSocket.onmessage=function(msg){onMessageReceivedInternal(this,msg=JSON.parse(msg.data))}.bind(this),webSocket.onopen=function(){console.log("web socket connection opened"),events.trigger(this,"websocketopen");var list=this.messageListeners;if(list)for(var i=0,length=(list=list.slice(0)).length;i<length;i++)this.startMessageListener(list[i],"0,2000")}.bind(this),webSocket.onerror=function(){events.trigger(this,"websocketerror")}.bind(this),function(apiClient,socket){socket.onclose=function(){console.log("web socket closed"),apiClient._webSocket===socket&&(console.log("nulling out web socket"),apiClient._webSocket=null),setTimeout(function(){events.trigger(apiClient,"websocketclose")},0)}}(this,webSocket),this._webSocket=webSocket},ApiClient.prototype.closeWebSocket=function(){var socket=this._webSocket;socket&&socket.readyState===WebSocket.OPEN&&socket.close()},ApiClient.prototype.sendWebSocketMessage=function(name,data){console.log("Sending web socket message: "+name);var msg={MessageType:name};data&&(msg.Data=data),msg=JSON.stringify(msg),this._webSocket.send(msg)},ApiClient.prototype.startMessageListener=function(name,options){this.sendMessage(name+"Start",options);var list=this.messageListeners;list||(this.messageListeners=list=[]),-1===list.indexOf(name)&&list.push(name)},ApiClient.prototype.stopMessageListener=function(name){this.sendMessage(name+"Stop");var list=this.messageListeners;list&&-1!==list.indexOf(name)&&(this.messageListeners=list=list.filter(function(n){return n!==name}))},ApiClient.prototype.sendMessage=function(name,data){this.isWebSocketOpen()&&this.sendWebSocketMessage(name,data)},ApiClient.prototype.isMessageChannelOpen=function(){return this.isWebSocketOpen()},ApiClient.prototype.isWebSocketOpen=function(){var socket=this._webSocket;return!!socket&&socket.readyState===WebSocket.OPEN},ApiClient.prototype.isWebSocketOpenOrConnecting=function(){var socket=this._webSocket;return!!socket&&(socket.readyState===WebSocket.OPEN||socket.readyState===WebSocket.CONNECTING)},ApiClient.prototype.get=function(url){return this.ajax({type:"GET",url:url})},ApiClient.prototype.getText=function(url,includeAuthorization){return this.fetch({url:url,type:"GET",dataType:"text"},includeAuthorization)},ApiClient.prototype.getJSON=function(url,includeAuthorization){return this.fetch({url:url,type:"GET",dataType:"json",headers:{accept:"application/json"}},includeAuthorization)},ApiClient.prototype.updateServerInfo=function(server,serverUrl){if(null==server)throw new Error("server cannot be null");if(this.serverInfo(server),!serverUrl)throw new Error("serverUrl cannot be null. serverInfo: "+JSON.stringify(server));console.log("Setting server address to "+serverUrl),this.serverAddress(serverUrl)},ApiClient.prototype.isWebSocketSupported=function(){try{return null!=WebSocket}catch(err){return!1}},ApiClient.prototype.clearAuthenticationInfo=function(){this.setAuthenticationInfo(null,null)},ApiClient.prototype.encodeName=function(name){var val=paramsToString({name:name=(name=(name=name.split("/").join("-")).split("&").join("-")).split("?").join("-")});return val.substring(val.indexOf("=")+1).replace("'","%27")},ApiClient.prototype.getProductNews=function(options){options=options||{};var url=this.getUrl("News/Product",options);return this.getJSON(url)},ApiClient.prototype.detectBitrate=function(force){var instance=this;return this.getEndpointInfo().then(function(info){return detectBitrateWithEndpointInfo(instance,info)},function(info){return detectBitrateWithEndpointInfo(instance,{})})},ApiClient.prototype.getItem=function(userId,itemId){if(!itemId)throw new Error("null itemId");var url=userId?this.getUrl("Users/"+userId+"/Items/"+itemId):this.getUrl("Items/"+itemId);return this.getJSON(url)},ApiClient.prototype.getRootFolder=function(userId){if(!userId)throw new Error("null userId");var url=this.getUrl("Users/"+userId+"/Items/Root");return this.getJSON(url)},ApiClient.prototype.getNotificationSummary=function(userId){if(!userId)throw new Error("null userId");var url=this.getUrl("Notifications/"+userId+"/Summary");return this.getJSON(url)},ApiClient.prototype.getNotifications=function(userId,options){if(!userId)throw new Error("null userId");var url=this.getUrl("Notifications/"+userId,options||{});return this.getJSON(url)},ApiClient.prototype.markNotificationsRead=function(userId,idList,isRead){if(!userId)throw new Error("null userId");if(!idList)throw new Error("null idList");var suffix=isRead?"Read":"Unread",params={UserId:userId,Ids:idList.join(",")},url=this.getUrl("Notifications/"+userId+"/"+suffix,params);return this.ajax({type:"POST",url:url})},ApiClient.prototype.getRemoteImageProviders=function(options){if(!options)throw new Error("null options");var urlPrefix=getRemoteImagePrefix(this,options),url=this.getUrl(urlPrefix+"/RemoteImages/Providers",options);return this.getJSON(url)},ApiClient.prototype.getAvailableRemoteImages=function(options){if(!options)throw new Error("null options");var urlPrefix=getRemoteImagePrefix(this,options),url=this.getUrl(urlPrefix+"/RemoteImages",options);return this.getJSON(url)},ApiClient.prototype.downloadRemoteImage=function(options){if(!options)throw new Error("null options");var urlPrefix=getRemoteImagePrefix(this,options),url=this.getUrl(urlPrefix+"/RemoteImages/Download",options);return this.ajax({type:"POST",url:url})},ApiClient.prototype.getRecordingFolders=function(userId){var url=this.getUrl("LiveTv/Recordings/Folders",{userId:userId});return this.getJSON(url)},ApiClient.prototype.getLiveTvInfo=function(options){var url=this.getUrl("LiveTv/Info",options||{});return this.getJSON(url)},ApiClient.prototype.getLiveTvGuideInfo=function(options){var url=this.getUrl("LiveTv/GuideInfo",options||{});return this.getJSON(url)},ApiClient.prototype.getLiveTvChannel=function(id,userId){if(!id)throw new Error("null id");var options={};userId&&(options.userId=userId);var url=this.getUrl("LiveTv/Channels/"+id,options);return this.getJSON(url)},ApiClient.prototype.getLiveTvChannels=function(options){var url=this.getUrl("LiveTv/Channels",options||{});return this.getJSON(url)},ApiClient.prototype.getLiveTvPrograms=function(options){return(options=options||{}).channelIds&&1800<options.channelIds.length?this.ajax({type:"POST",url:this.getUrl("LiveTv/Programs"),data:JSON.stringify(options),contentType:"application/json",dataType:"json"}):this.ajax({type:"GET",url:this.getUrl("LiveTv/Programs",options),dataType:"json"})},ApiClient.prototype.getLiveTvRecommendedPrograms=function(options){return options=options||{},this.ajax({type:"GET",url:this.getUrl("LiveTv/Programs/Recommended",options),dataType:"json"})},ApiClient.prototype.getLiveTvRecordings=function(options){var url=this.getUrl("LiveTv/Recordings",options||{});return this.getJSON(url)},ApiClient.prototype.getLiveTvRecordingSeries=function(options){var url=this.getUrl("LiveTv/Recordings/Series",options||{});return this.getJSON(url)},ApiClient.prototype.getLiveTvRecordingGroups=function(options){var url=this.getUrl("LiveTv/Recordings/Groups",options||{});return this.getJSON(url)},ApiClient.prototype.getLiveTvRecordingGroup=function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/Recordings/Groups/"+id);return this.getJSON(url)},ApiClient.prototype.getLiveTvRecording=function(id,userId){if(!id)throw new Error("null id");var options={};userId&&(options.userId=userId);var url=this.getUrl("LiveTv/Recordings/"+id,options);return this.getJSON(url)},ApiClient.prototype.getLiveTvProgram=function(id,userId){if(!id)throw new Error("null id");var options={};userId&&(options.userId=userId);var url=this.getUrl("LiveTv/Programs/"+id,options);return this.getJSON(url)},ApiClient.prototype.deleteLiveTvRecording=function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/Recordings/"+id);return this.ajax({type:"DELETE",url:url})},ApiClient.prototype.cancelLiveTvTimer=function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/Timers/"+id);return this.ajax({type:"DELETE",url:url})},ApiClient.prototype.getLiveTvTimers=function(options){var url=this.getUrl("LiveTv/Timers",options||{});return this.getJSON(url)},ApiClient.prototype.getLiveTvTimer=function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/Timers/"+id);return this.getJSON(url)},ApiClient.prototype.getNewLiveTvTimerDefaults=function(options){options=options||{};var url=this.getUrl("LiveTv/Timers/Defaults",options);return this.getJSON(url)},ApiClient.prototype.createLiveTvTimer=function(item){if(!item)throw new Error("null item");var url=this.getUrl("LiveTv/Timers");return this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"})},ApiClient.prototype.updateLiveTvTimer=function(item){if(!item)throw new Error("null item");var url=this.getUrl("LiveTv/Timers/"+item.Id);return this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"})},ApiClient.prototype.resetLiveTvTuner=function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/Tuners/"+id+"/Reset");return this.ajax({type:"POST",url:url})},ApiClient.prototype.getLiveTvSeriesTimers=function(options){var url=this.getUrl("LiveTv/SeriesTimers",options||{});return this.getJSON(url)},ApiClient.prototype.getLiveTvSeriesTimer=function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/SeriesTimers/"+id);return this.getJSON(url)},ApiClient.prototype.cancelLiveTvSeriesTimer=function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/SeriesTimers/"+id);return this.ajax({type:"DELETE",url:url})},ApiClient.prototype.createLiveTvSeriesTimer=function(item){if(!item)throw new Error("null item");var url=this.getUrl("LiveTv/SeriesTimers");return this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"})},ApiClient.prototype.updateLiveTvSeriesTimer=function(item){if(!item)throw new Error("null item");var url=this.getUrl("LiveTv/SeriesTimers/"+item.Id);return this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"})},ApiClient.prototype.getRegistrationInfo=function(feature){var url=this.getUrl("Registrations/"+feature);return this.getJSON(url)},ApiClient.prototype.getSystemInfo=function(){var url=this.getUrl("System/Info"),instance=this;return this.getJSON(url).then(function(info){return instance.setSystemInfo(info),Promise.resolve(info)})},ApiClient.prototype.getSyncStatus=function(itemId){var url=this.getUrl("Sync/"+itemId+"/Status");return this.ajax({url:url,type:"POST",dataType:"json",contentType:"application/json",data:JSON.stringify({TargetId:this.deviceId()})})},ApiClient.prototype.getPublicSystemInfo=function(){var url=this.getUrl("System/Info/Public"),instance=this;return this.getJSON(url).then(function(info){return instance.setSystemInfo(info),Promise.resolve(info)})},ApiClient.prototype.getInstantMixFromItem=function(itemId,options){var url=this.getUrl("Items/"+itemId+"/InstantMix",options);return this.getJSON(url)},ApiClient.prototype.getEpisodes=function(itemId,options){var url=this.getUrl("Shows/"+itemId+"/Episodes",options);return this.getJSON(url)},ApiClient.prototype.getDisplayPreferences=function(id,userId,app){var url=this.getUrl("DisplayPreferences/"+id,{userId:userId,client:app});return this.getJSON(url)},ApiClient.prototype.updateDisplayPreferences=function(id,obj,userId,app){var url=this.getUrl("DisplayPreferences/"+id,{userId:userId,client:app});return this.ajax({type:"POST",url:url,data:JSON.stringify(obj),contentType:"application/json"})},ApiClient.prototype.getSeasons=function(itemId,options){var url=this.getUrl("Shows/"+itemId+"/Seasons",options);return this.getJSON(url)},ApiClient.prototype.getSimilarItems=function(itemId,options){var url=this.getUrl("Items/"+itemId+"/Similar",options);return this.getJSON(url)},ApiClient.prototype.getCultures=function(){var url=this.getUrl("Localization/cultures");return this.getJSON(url)},ApiClient.prototype.getCountries=function(){var url=this.getUrl("Localization/countries");return this.getJSON(url)},ApiClient.prototype.getPlaybackInfo=function(itemId,options,deviceProfile){var postData={DeviceProfile:deviceProfile};return this.ajax({url:this.getUrl("Items/"+itemId+"/PlaybackInfo",options),type:"POST",data:JSON.stringify(postData),contentType:"application/json",dataType:"json"})},ApiClient.prototype.getLiveStreamMediaInfo=function(liveStreamId){var postData={LiveStreamId:liveStreamId};return this.ajax({url:this.getUrl("LiveStreams/MediaInfo"),type:"POST",data:JSON.stringify(postData),contentType:"application/json",dataType:"json"})},ApiClient.prototype.getIntros=function(itemId){return this.getJSON(this.getUrl("Users/"+this.getCurrentUserId()+"/Items/"+itemId+"/Intros"))},ApiClient.prototype.getDirectoryContents=function(path,options){if(!path)throw new Error("null path");if("string"!=typeof path)throw new Error("invalid path");(options=options||{}).path=path;var url=this.getUrl("Environment/DirectoryContents",options);return this.getJSON(url)},ApiClient.prototype.getNetworkShares=function(path){if(!path)throw new Error("null path");var options={};options.path=path;var url=this.getUrl("Environment/NetworkShares",options);return this.getJSON(url)},ApiClient.prototype.getParentPath=function(path){if(!path)throw new Error("null path");var options={};options.path=path;var url=this.getUrl("Environment/ParentPath",options);return this.ajax({type:"GET",url:url,dataType:"text"})},ApiClient.prototype.getDrives=function(){var url=this.getUrl("Environment/Drives");return this.getJSON(url)},ApiClient.prototype.getNetworkDevices=function(){var url=this.getUrl("Environment/NetworkDevices");return this.getJSON(url)},ApiClient.prototype.cancelPackageInstallation=function(installationId){if(!installationId)throw new Error("null installationId");var url=this.getUrl("Packages/Installing/"+installationId);return this.ajax({type:"DELETE",url:url})},ApiClient.prototype.refreshItem=function(itemId,options){if(!itemId)throw new Error("null itemId");var url=this.getUrl("Items/"+itemId+"/Refresh",options||{});return this.ajax({type:"POST",url:url})},ApiClient.prototype.installPlugin=function(name,guid,updateClass,version){if(!name)throw new Error("null name");if(!updateClass)throw new Error("null updateClass");var options={updateClass:updateClass,AssemblyGuid:guid};version&&(options.version=version);var url=this.getUrl("Packages/Installed/"+name,options);return this.ajax({type:"POST",url:url})},ApiClient.prototype.restartServer=function(){var url=this.getUrl("System/Restart");return this.ajax({type:"POST",url:url})},ApiClient.prototype.shutdownServer=function(){var url=this.getUrl("System/Shutdown");return this.ajax({type:"POST",url:url})},ApiClient.prototype.getPackageInfo=function(name,guid){if(!name)throw new Error("null name");var options={AssemblyGuid:guid},url=this.getUrl("Packages/"+name,options);return this.getJSON(url)},ApiClient.prototype.getAvailableApplicationUpdate=function(){var url=this.getUrl("Packages/Updates",{PackageType:"System"});return this.getJSON(url)},ApiClient.prototype.getAvailablePluginUpdates=function(){var url=this.getUrl("Packages/Updates",{PackageType:"UserInstalled"});return this.getJSON(url)},ApiClient.prototype.getVirtualFolders=function(){var url="Library/VirtualFolders";url=this.getUrl(url);var serverId=this.serverId();return this.getJSON(url).then(function(items){for(var i=0,length=items.length;i<length;i++){var item=items[i];mapVirtualFolder(item),item.ServerId=serverId}return items})},ApiClient.prototype.getPhysicalPaths=function(){var url=this.getUrl("Library/PhysicalPaths");return this.getJSON(url)},ApiClient.prototype.getServerConfiguration=function(){var url=this.getUrl("System/Configuration");return this.getJSON(url)},ApiClient.prototype.getDevicesOptions=function(){var url=this.getUrl("System/Configuration/devices");return this.getJSON(url)},ApiClient.prototype.getContentUploadHistory=function(){var url=this.getUrl("Devices/CameraUploads",{DeviceId:this.deviceId()});return this.getJSON(url)},ApiClient.prototype.getNamedConfiguration=function(name){var url=this.getUrl("System/Configuration/"+name);return this.getJSON(url)},ApiClient.prototype.getHardwareAccelerations=function(){var url=this.getUrl("Encoding/HardwareAccelerations");return this.getJSON(url)},ApiClient.prototype.getVideoCodecInformation=function(){var url=this.getUrl("Encoding/CodecInformation/Video");return this.getJSON(url)},ApiClient.prototype.getScheduledTasks=function(options){options=options||{};var url=this.getUrl("ScheduledTasks",options);return this.getJSON(url)},ApiClient.prototype.startScheduledTask=function(id){if(!id)throw new Error("null id");var url=this.getUrl("ScheduledTasks/Running/"+id);return this.ajax({type:"POST",url:url})},ApiClient.prototype.getScheduledTask=function(id){if(!id)throw new Error("null id");var url=this.getUrl("ScheduledTasks/"+id);return this.getJSON(url)},ApiClient.prototype.getNextUpEpisodes=function(options){var url=this.getUrl("Shows/NextUp",options);return this.getJSON(url)},ApiClient.prototype.stopScheduledTask=function(id){if(!id)throw new Error("null id");var url=this.getUrl("ScheduledTasks/Running/"+id);return this.ajax({type:"DELETE",url:url})},ApiClient.prototype.getPluginConfiguration=function(id){if(!id)throw new Error("null Id");var url=this.getUrl("Plugins/"+id+"/Configuration");return this.getJSON(url)},ApiClient.prototype.getAvailablePlugins=function(options){(options=options||{}).PackageType="UserInstalled";var url=this.getUrl("Packages",options);return this.getJSON(url)},ApiClient.prototype.uninstallPlugin=function(id){if(!id)throw new Error("null Id");var url=this.getUrl("Plugins/"+id);return this.ajax({type:"DELETE",url:url})},ApiClient.prototype.removeVirtualFolder=function(virtualFolder,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");var url="Library/VirtualFolders";return url=this.getUrl(url,{refreshLibrary:!!refreshLibrary,id:virtualFolder.Id,name:virtualFolder.Name}),this.ajax({type:"DELETE",url:url})},ApiClient.prototype.addVirtualFolder=function(name,type,refreshLibrary,libraryOptions){if(!name)throw new Error("null name");var options={};type&&(options.collectionType=type),options.refreshLibrary=!!refreshLibrary,options.name=name;var url="Library/VirtualFolders";return url=this.getUrl(url,options),this.ajax({type:"POST",url:url,data:JSON.stringify({LibraryOptions:libraryOptions}),contentType:"application/json"})},ApiClient.prototype.updateVirtualFolderOptions=function(id,libraryOptions){if(!id)throw new Error("null name");var url="Library/VirtualFolders/LibraryOptions";return url=this.getUrl(url),this.ajax({type:"POST",url:url,data:JSON.stringify({Id:id,LibraryOptions:libraryOptions}),contentType:"application/json"})},ApiClient.prototype.renameVirtualFolder=function(virtualFolder,newName,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");var url="Library/VirtualFolders/Name";url=this.getUrl(url,{refreshLibrary:!!refreshLibrary,newName:newName,name:virtualFolder.Name,Id:virtualFolder.Id});var instance=this;return this.ajax({type:"POST",url:url}).then(function(){instance._userViewsPromise=null})},ApiClient.prototype.addMediaPath=function(virtualFolder,mediaPath,networkSharePath,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");if(!mediaPath)throw new Error("null mediaPath");var url="Library/VirtualFolders/Paths",pathInfo={Path:mediaPath};networkSharePath&&(pathInfo.NetworkPath=networkSharePath),url=this.getUrl(url,{refreshLibrary:!!refreshLibrary});var instance=this;return this.ajax({type:"POST",url:url,data:JSON.stringify({Name:virtualFolder.Name,PathInfo:pathInfo,Id:virtualFolder.Id}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null})},ApiClient.prototype.updateMediaPath=function(virtualFolder,pathInfo){if(!virtualFolder)throw new Error("null virtualFolder");if(!pathInfo)throw new Error("null pathInfo");var url="Library/VirtualFolders/Paths/Update";url=this.getUrl(url);var instance=this;return this.ajax({type:"POST",url:url,data:JSON.stringify({Name:virtualFolder.Name,PathInfo:pathInfo,Id:virtualFolder.Id}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null})},ApiClient.prototype.removeMediaPath=function(virtualFolder,mediaPath,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");if(!mediaPath)throw new Error("null mediaPath");var url="Library/VirtualFolders/Paths",instance=this;return url=this.getUrl(url,{refreshLibrary:!!refreshLibrary,path:mediaPath,name:virtualFolder.Name,Id:virtualFolder.Id}),this.ajax({type:"DELETE",url:url}).then(function(){instance._userViewsPromise=null})},ApiClient.prototype.deleteUser=function(id){if(!id)throw new Error("null id");var url=this.getUrl("Users/"+id),serverId=this.serverId();return this.ajax({type:"DELETE",url:url}).then(function(){removeCachedUser(id,serverId)})},ApiClient.prototype.deleteUserImage=function(userId,imageType,imageIndex){if(!userId)throw new Error("null userId");if(!imageType)throw new Error("null imageType");var url=this.getUrl("Users/"+userId+"/Images/"+imageType);null!=imageIndex&&(url+="/"+imageIndex);var serverId=this.serverId();return this.ajax({type:"DELETE",url:url}).then(function(){removeCachedUser(userId,serverId)})},ApiClient.prototype.deleteItemImage=function(itemId,imageType,imageIndex){if(!imageType)throw new Error("null imageType");var url=this.getUrl("Items/"+itemId+"/Images");return url+="/"+imageType,null!=imageIndex&&(url+="/"+imageIndex),this.ajax({type:"DELETE",url:url})},ApiClient.prototype.deleteItem=function(itemId){if(!itemId)throw new Error("null itemId");var url=this.getUrl("Items/"+itemId);return this.ajax({type:"DELETE",url:url})},ApiClient.prototype.stopActiveEncodings=function(playSessionId){var options={deviceId:this.deviceId()};playSessionId&&(options.PlaySessionId=playSessionId);var url=this.getUrl("Videos/ActiveEncodings",options);return this.ajax({type:"DELETE",url:url})},ApiClient.prototype.reportCapabilities=function(options){var url=this.getUrl("Sessions/Capabilities/Full");return this.ajax({type:"POST",url:url,data:JSON.stringify(options),contentType:"application/json"})},ApiClient.prototype.updateItemImageIndex=function(itemId,imageType,imageIndex,newIndex){if(!imageType)throw new Error("null imageType");var options={newIndex:newIndex},url=this.getUrl("Items/"+itemId+"/Images/"+imageType+"/"+imageIndex+"/Index",options);return this.ajax({type:"POST",url:url})},ApiClient.prototype.getItemImageInfos=function(itemId){var url=this.getUrl("Items/"+itemId+"/Images");return this.getJSON(url)},ApiClient.prototype.getCriticReviews=function(itemId,options){if(!itemId)throw new Error("null itemId");var url=this.getUrl("Items/"+itemId+"/CriticReviews",options);return this.getJSON(url)},ApiClient.prototype.getItemDownloadUrl=function(itemId,mediaSourceId){if(!itemId)throw new Error("itemId cannot be empty");var url="Items/"+itemId+"/Download";return this.getUrl(url,{api_key:this.accessToken(),mediaSourceId:mediaSourceId})},ApiClient.prototype.getSessions=function(options){var url=this.getUrl("Sessions",options);return this.getJSON(url)},ApiClient.prototype.uploadUserImage=function(userId,imageType,file){if(!userId)throw new Error("null userId");if(!imageType)throw new Error("null imageType");if(!file)throw new Error("File must be an image.");if("image/png"!==file.type&&"image/jpeg"!==file.type&&"image/jpeg"!==file.type)throw new Error("File must be an image.");var instance=this,serverId=this.serverId();return new Promise(function(resolve,reject){var reader=new FileReader;reader.onerror=function(){reject()},reader.onabort=function(){reject()},reader.onload=function(e){var data=e.target.result.split(",")[1],url=instance.getUrl("Users/"+userId+"/Images/"+imageType);instance.ajax({type:"POST",url:url,data:data,contentType:"image/"+file.name.substring(file.name.lastIndexOf(".")+1)}).then(function(){removeCachedUser(userId,serverId),resolve()},reject)},reader.readAsDataURL(file)})},ApiClient.prototype.uploadItemImage=function(itemId,imageType,file){if(!itemId)throw new Error("null itemId");if(!imageType)throw new Error("null imageType");if(!file)throw new Error("File must be an image.");if("image/png"!==file.type&&"image/jpeg"!==file.type&&"image/jpeg"!==file.type)throw new Error("File must be an image.");var url=this.getUrl("Items/"+itemId+"/Images");url+="/"+imageType;var instance=this;return new Promise(function(resolve,reject){var reader=new FileReader;reader.onerror=function(){reject()},reader.onabort=function(){reject()},reader.onload=function(e){var data=e.target.result.split(",")[1];instance.ajax({type:"POST",url:url,data:data,contentType:"image/"+file.name.substring(file.name.lastIndexOf(".")+1)}).then(resolve,reject)},reader.readAsDataURL(file)})},ApiClient.prototype.getInstalledPlugins=function(){var url=this.getUrl("Plugins",{});return this.getJSON(url)},ApiClient.prototype.getUser=function(id,enableCache){if(!id)throw new Error("Must supply a userId");var cachedUser;if(!1!==enableCache&&(cachedUser=getCachedUser(this,id))&&Date.now()-(cachedUser.DateLastFetched||0)<=6e4)return Promise.resolve(cachedUser);var instance=this,url=this.getUrl("Users/"+id),serverPromise=this.getJSON(url).then(function(user){return saveUserInCache(user),user},function(response){if((!response||!response.status)&&instance.accessToken()){var user=getCachedUser(instance,id);if(user)return Promise.resolve(user)}throw response});return!1!==enableCache&&cachedUser?Promise.resolve(cachedUser):serverPromise},ApiClient.prototype.getStudio=function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("Studios/"+this.encodeName(name),options);return this.getJSON(url)},ApiClient.prototype.getGenre=function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("Genres/"+this.encodeName(name),options);return this.getJSON(url)},ApiClient.prototype.getMusicGenre=function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("MusicGenres/"+this.encodeName(name),options);return this.getJSON(url)},ApiClient.prototype.getGameGenre=function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("GameGenres/"+this.encodeName(name),options);return this.getJSON(url)},ApiClient.prototype.getArtist=function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("Artists/"+this.encodeName(name),options);return this.getJSON(url)},ApiClient.prototype.getPerson=function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("Persons/"+this.encodeName(name),options);return this.getJSON(url)},ApiClient.prototype.getPublicUsers=function(){var url=this.getUrl("users/public");return this.ajax({type:"GET",url:url,dataType:"json"},!0,!1).then(setUsersProperties)},ApiClient.prototype.getUsers=function(options){var url=this.getUrl("users",options||{});return this.getJSON(url).then(setUsersProperties)},ApiClient.prototype.getParentalRatings=function(){var url=this.getUrl("Localization/ParentalRatings");return this.getJSON(url)},ApiClient.prototype.getDefaultImageQuality=function(imageType){return"backdrop"===imageType.toLowerCase()?80:90},ApiClient.prototype.getUserImageUrl=function(userId,options){if(!userId)throw new Error("null userId");var url="Users/"+userId+"/Images/"+(options=options||{}).type;return null!=options.index&&(url+="/"+options.index),normalizeImageOptions(this,options),delete options.type,delete options.index,this.getUrl(url,options)},ApiClient.prototype.getImageUrl=function(itemId,options){if(!itemId)throw new Error("itemId cannot be empty");var url="Items/"+itemId+"/Images/"+(options=options||{}).type;return null!=options.index&&(url+="/"+options.index),options.quality=options.quality||this.getDefaultImageQuality(options.type),this.normalizeImageOptions&&this.normalizeImageOptions(options),delete options.type,delete options.index,this.getUrl(url,options)},ApiClient.prototype.getScaledImageUrl=function(itemId,options){if(!itemId)throw new Error("itemId cannot be empty");var url="Items/"+itemId+"/Images/"+(options=options||{}).type;return null!=options.index&&(url+="/"+options.index),normalizeImageOptions(this,options),delete options.type,delete options.index,delete options.minScale,this.getUrl(url,options)},ApiClient.prototype.getThumbImageUrl=function(item,options){if(!item)throw new Error("null item");return(options=options||{}).imageType="thumb",item.ImageTags&&item.ImageTags.Thumb?(options.tag=item.ImageTags.Thumb,this.getImageUrl(item.Id,options)):item.ParentThumbItemId?(options.tag=item.ImageTags.ParentThumbImageTag,this.getImageUrl(item.ParentThumbItemId,options)):null},ApiClient.prototype.updateUserPassword=function(userId,currentPassword,newPassword){if(!userId)return Promise.reject();var url=this.getUrl("Users/"+userId+"/Password"),serverId=this.serverId();return this.ajax({type:"POST",url:url,data:JSON.stringify({CurrentPw:currentPassword||"",NewPw:newPassword}),contentType:"application/json"}).then(function(){return removeCachedUser(userId,serverId),Promise.resolve()})},ApiClient.prototype.updateEasyPassword=function(userId,newPassword){if(userId){var url=this.getUrl("Users/"+userId+"/EasyPassword"),serverId=this.serverId();return this.ajax({type:"POST",url:url,data:{NewPw:newPassword}}).then(function(){return removeCachedUser(userId,serverId),Promise.resolve()})}Promise.reject()},ApiClient.prototype.resetUserPassword=function(userId){if(!userId)throw new Error("null userId");var url=this.getUrl("Users/"+userId+"/Password"),serverId=this.serverId(),postData={resetPassword:!0};return this.ajax({type:"POST",url:url,data:postData}).then(function(){return removeCachedUser(userId,serverId),Promise.resolve()})},ApiClient.prototype.resetEasyPassword=function(userId){if(!userId)throw new Error("null userId");var url=this.getUrl("Users/"+userId+"/EasyPassword"),serverId=this.serverId(),postData={resetPassword:!0};return this.ajax({type:"POST",url:url,data:postData}).then(function(){return removeCachedUser(userId,serverId),Promise.resolve()})},ApiClient.prototype.updateServerConfiguration=function(configuration){if(!configuration)throw new Error("null configuration");var url=this.getUrl("System/Configuration");return this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"})},ApiClient.prototype.updateNamedConfiguration=function(name,configuration){if(!configuration)throw new Error("null configuration");var url=this.getUrl("System/Configuration/"+name);return this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"})},ApiClient.prototype.updateItem=function(item){if(!item)throw new Error("null item");var url=this.getUrl("Items/"+item.Id);return this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"})},ApiClient.prototype.updatePluginSecurityInfo=function(info){var url=this.getUrl("Plugins/SecurityInfo");return this.ajax({type:"POST",url:url,data:JSON.stringify(info),contentType:"application/json"})},ApiClient.prototype.createUser=function(name){var url=this.getUrl("Users/New");return this.ajax({type:"POST",url:url,data:{Name:name},dataType:"json"})},ApiClient.prototype.updateUser=function(user){if(!user)throw new Error("null user");var url=this.getUrl("Users/"+user.Id);return this.ajax({type:"POST",url:url,data:JSON.stringify(user),contentType:"application/json"})},ApiClient.prototype.updateUserPolicy=function(userId,policy){if(!userId)throw new Error("null userId");if(!policy)throw new Error("null policy");var url=this.getUrl("Users/"+userId+"/Policy"),instance=this;return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),removeCachedUser(userId,instance.serverId()),this.ajax({type:"POST",url:url,data:JSON.stringify(policy),contentType:"application/json"}).then(function(){return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),removeCachedUser(userId,instance.serverId()),Promise.resolve()})},ApiClient.prototype.updateUserConfiguration=function(userId,configuration){if(!userId)throw new Error("null userId");if(!configuration)throw new Error("null configuration");var url=this.getUrl("Users/"+userId+"/Configuration"),instance=this;return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),removeCachedUser(userId,instance.serverId()),this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"}).then(function(){return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),removeCachedUser(userId,instance.serverId()),Promise.resolve()})},ApiClient.prototype.updateScheduledTaskTriggers=function(id,triggers){if(!id)throw new Error("null id");if(!triggers)throw new Error("null triggers");var url=this.getUrl("ScheduledTasks/"+id+"/Triggers");return this.ajax({type:"POST",url:url,data:JSON.stringify(triggers),contentType:"application/json"})},ApiClient.prototype.updatePluginConfiguration=function(id,configuration){if(!id)throw new Error("null Id");if(!configuration)throw new Error("null configuration");var url=this.getUrl("Plugins/"+id+"/Configuration");return this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"})},ApiClient.prototype.getAncestorItems=function(itemId,userId){if(!itemId)throw new Error("null itemId");var options={};userId&&(options.userId=userId);var url=this.getUrl("Items/"+itemId+"/Ancestors",options);return this.getJSON(url)},ApiClient.prototype.getItems=function(userId,options){var url;return url="string"===(typeof userId).toString().toLowerCase()?this.getUrl("Users/"+userId+"/Items",options):this.getUrl("Items",options),this.getJSON(url)},ApiClient.prototype.getResumableItems=function(userId,options){return this.getJSON(this.getUrl("Users/"+userId+"/Items/Resume",options))},ApiClient.prototype.getMovieRecommendations=function(options){return this.getJSON(this.getUrl("Movies/Recommendations",options))},ApiClient.prototype.getUpcomingEpisodes=function(options){return this.getJSON(this.getUrl("Shows/Upcoming",options))},ApiClient.prototype.getUserViews=function(options,userId){var currentUserId=this.getCurrentUserId(),enableCache=!((userId=userId||currentUserId)!==currentUserId||options&&options.IncludeHidden);if(enableCache&&this._userViewsPromise)return this._userViewsPromise;var url=this.getUrl("Users/"+userId+"/Views",options),self=this,promise=this.getJSON(url).then(function(result){return Promise.resolve(result)},function(){self._userViewsPromise=null});return enableCache&&(this._userViewsPromise=promise),promise},ApiClient.prototype.getArtists=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Artists",options);return this.getJSON(url)},ApiClient.prototype.getAlbumArtists=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Artists/AlbumArtists",options);return this.getJSON(url)},ApiClient.prototype.getGenres=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Genres",options);return this.getJSON(url)},ApiClient.prototype.getMusicGenres=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("MusicGenres",options);return this.getJSON(url)},ApiClient.prototype.getGameGenres=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("GameGenres",options);return this.getJSON(url)},ApiClient.prototype.getPeople=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Persons",options);return this.getJSON(url)},ApiClient.prototype.getThumbnails=function(itemId,options){if(!this.isMinServerVersion("4.1.0.26"))return Promise.resolve({Thumbnails:[]});var url=this.getUrl("Items/"+itemId+"/ThumbnailSet",options);return this.getJSON(url)},ApiClient.prototype.getDeleteInfo=function(itemId,options){if(!this.isMinServerVersion("4.1.0.15"))return Promise.resolve({Paths:[]});var url=this.getUrl("Items/"+itemId+"/DeleteInfo",options);return this.getJSON(url)},ApiClient.prototype.getStudios=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Studios",options);return this.getJSON(url)},ApiClient.prototype.getOfficialRatings=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("OfficialRatings",options);return this.getJSON(url)},ApiClient.prototype.getYears=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Years",options);return this.getJSON(url)},ApiClient.prototype.getTags=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Tags",options);return this.getJSON(url)},ApiClient.prototype.getContainers=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Containers",options);return this.getJSON(url)},ApiClient.prototype.getAudioCodecs=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("AudioCodecs",options);return this.getJSON(url)},ApiClient.prototype.getVideoCodecs=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("VideoCodecs",options);return this.getJSON(url)},ApiClient.prototype.getSubtitleCodecs=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("SubtitleCodecs",options);return this.getJSON(url)},ApiClient.prototype.getDefaultPrefixes=function(){return Promise.resolve(["#","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"].map(mapPrefix))},ApiClient.prototype.getPrefixes=function(userId,options){if(!userId)throw new Error("null userId");if(!this.isMinServerVersion("3.6.0.85"))return this.getDefaultPrefixes();(options=options||{}).userId=userId;var url=this.getUrl("Items/Prefixes",options);return this.getJSON(url)},ApiClient.prototype.getArtistPrefixes=function(userId,options){if(!userId)throw new Error("null userId");if(!this.isMinServerVersion("3.6.0.85"))return this.getDefaultPrefixes();(options=options||{}).userId=userId;var url=this.getUrl("Artists/Prefixes",options);return this.getJSON(url)},ApiClient.prototype.getLocalTrailers=function(userId,itemId){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/"+userId+"/Items/"+itemId+"/LocalTrailers");return this.getJSON(url)},ApiClient.prototype.getGameSystems=function(){var options={},userId=this.getCurrentUserId();userId&&(options.userId=userId);var url=this.getUrl("Games/SystemSummaries",options);return this.getJSON(url)},ApiClient.prototype.getAdditionalVideoParts=function(userId,itemId){if(!itemId)throw new Error("null itemId");var options={};userId&&(options.userId=userId);var url=this.getUrl("Videos/"+itemId+"/AdditionalParts",options);return this.getJSON(url)},ApiClient.prototype.getThemeMedia=function(itemId,options){var url=this.getUrl("Items/"+itemId+"/ThemeMedia",options);return this.getJSON(url)};var startingPlaySession=Date.now();function getCachedWakeOnLanInfo(instance){var serverId=instance.serverId(),json=appStorage.getItem("server-"+serverId+"-wakeonlaninfo");return json?JSON.parse(json):[]}function refreshWakeOnLanInfoIfNeeded(instance){wakeOnLan.isSupported()&&instance.accessToken()&&!1!==instance.enableAutomaticBitrateDetection&&(console.log("refreshWakeOnLanInfoIfNeeded"),setTimeout(function(){var instance=this;console.log("refreshWakeOnLanInfo"),instance.getWakeOnLanInfo().then(function(info){var serverId=instance.serverId();return appStorage.setItem("server-"+serverId+"-wakeonlaninfo",JSON.stringify(info)),info},function(err){return[]})}.bind(instance),1e4))}return ApiClient.prototype.getAudioStreamUrl=function(item,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){var url="Audio/"+item.Id+"/universal";return startingPlaySession++,this.getUrl(url,{UserId:this.getCurrentUserId(),DeviceId:this.deviceId(),MaxStreamingBitrate:maxBitrate,Container:directPlayContainers,TranscodingContainer:transcodingProfile.Container||null,TranscodingProtocol:transcodingProfile.Protocol||null,AudioCodec:transcodingProfile.AudioCodec,MaxAudioSampleRate:maxAudioSampleRate,MaxAudioBitDepth:maxAudioBitDepth,api_key:this.accessToken(),PlaySessionId:startingPlaySession,StartTimeTicks:startPosition||0,EnableRedirection:!0,EnableRemoteMedia:enableRemoteMedia})},ApiClient.prototype.getSpecialFeatures=function(userId,itemId){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/"+userId+"/Items/"+itemId+"/SpecialFeatures");return this.getJSON(url)},ApiClient.prototype.getDateParamValue=function(date){function formatDigit(i){return i<10?"0"+i:i}var d=date;return""+d.getFullYear()+formatDigit(d.getMonth()+1)+formatDigit(d.getDate())+formatDigit(d.getHours())+formatDigit(d.getMinutes())+formatDigit(d.getSeconds())},ApiClient.prototype.markPlayed=function(userId,itemId,date){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var options={};date&&(options.DatePlayed=this.getDateParamValue(date));var url=this.getUrl("Users/"+userId+"/PlayedItems/"+itemId,options);return this.ajax({type:"POST",url:url,dataType:"json"})},ApiClient.prototype.markUnplayed=function(userId,itemId){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/"+userId+"/PlayedItems/"+itemId);return this.ajax({type:"DELETE",url:url,dataType:"json"})},ApiClient.prototype.updateFavoriteStatus=function(userId,itemId,isFavorite){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/"+userId+"/FavoriteItems/"+itemId),method=isFavorite?"POST":"DELETE";return this.ajax({type:method,url:url,dataType:"json"})},ApiClient.prototype.updateUserItemRating=function(userId,itemId,likes){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/"+userId+"/Items/"+itemId+"/Rating",{likes:likes});return this.ajax({type:"POST",url:url,dataType:"json"})},ApiClient.prototype.getItemCounts=function(userId){var options={};userId&&(options.userId=userId);var url=this.getUrl("Items/Counts",options);return this.getJSON(url)},ApiClient.prototype.clearUserItemRating=function(userId,itemId){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/"+userId+"/Items/"+itemId+"/Rating");return this.ajax({type:"DELETE",url:url,dataType:"json"})},ApiClient.prototype.reportPlaybackStart=function(options){if(!options)throw new Error("null options");this.lastPlaybackProgressReport=0,this.lastPlaybackProgressReportTicks=null;var url=this.getUrl("Sessions/Playing");return this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:url})},ApiClient.prototype.reportPlaybackProgress=function(options){if(!options)throw new Error("null options");var newPositionTicks=options.PositionTicks;if("timeupdate"===(options.EventName||"timeupdate")){var now=Date.now(),msSinceLastReport=now-(this.lastPlaybackProgressReport||0);if(msSinceLastReport<=1e4){if(!newPositionTicks)return Promise.resolve();var expectedReportTicks=1e4*msSinceLastReport+(this.lastPlaybackProgressReportTicks||0);if(Math.abs((newPositionTicks||0)-expectedReportTicks)<5e7)return Promise.resolve()}this.lastPlaybackProgressReport=now}else this.lastPlaybackProgressReport=0;this.lastPlaybackProgressReportTicks=newPositionTicks;var url=this.getUrl("Sessions/Playing/Progress");return this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:url})},ApiClient.prototype.reportOfflineActions=function(actions){if(!actions)throw new Error("null actions");var url=this.getUrl("Sync/OfflineActions");return this.ajax({type:"POST",data:JSON.stringify(actions),contentType:"application/json",url:url})},ApiClient.prototype.syncData=function(data){if(!data)throw new Error("null data");var url=this.getUrl("Sync/Data");return this.ajax({type:"POST",data:JSON.stringify(data),contentType:"application/json",url:url,dataType:"json"})},ApiClient.prototype.getReadySyncItems=function(deviceId){if(!deviceId)throw new Error("null deviceId");var url=this.getUrl("Sync/Items/Ready",{TargetId:deviceId});return this.getJSON(url)},ApiClient.prototype.reportSyncJobItemTransferred=function(syncJobItemId){if(!syncJobItemId)throw new Error("null syncJobItemId");var url=this.getUrl("Sync/JobItems/"+syncJobItemId+"/Transferred");return this.ajax({type:"POST",url:url})},ApiClient.prototype.cancelSyncItems=function(itemIds,targetId){if(!itemIds)throw new Error("null itemIds");var url=this.getUrl("Sync/"+(targetId||this.deviceId())+"/Items",{ItemIds:itemIds.join(",")});return this.ajax({type:"DELETE",url:url})},ApiClient.prototype.reportPlaybackStopped=function(options){if(!options)throw new Error("null options");this.lastPlaybackProgressReport=0,this.lastPlaybackProgressReportTicks=null;var url=this.getUrl("Sessions/Playing/Stopped");return this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:url})},ApiClient.prototype.sendPlayCommand=function(sessionId,options){if(!sessionId)throw new Error("null sessionId");if(!options)throw new Error("null options");var url=this.getUrl("Sessions/"+sessionId+"/Playing",options);return this.ajax({type:"POST",url:url})},ApiClient.prototype.sendCommand=function(sessionId,command){if(!sessionId)throw new Error("null sessionId");if(!command)throw new Error("null command");var ajaxOptions={type:"POST",url:this.getUrl("Sessions/"+sessionId+"/Command")};return ajaxOptions.data=JSON.stringify(command),ajaxOptions.contentType="application/json",this.ajax(ajaxOptions)},ApiClient.prototype.sendMessageCommand=function(sessionId,options){if(!sessionId)throw new Error("null sessionId");if(!options)throw new Error("null options");var ajaxOptions={type:"POST",url:this.getUrl("Sessions/"+sessionId+"/Message")};return ajaxOptions.data=JSON.stringify(options),ajaxOptions.contentType="application/json",this.ajax(ajaxOptions)},ApiClient.prototype.sendPlayStateCommand=function(sessionId,command,options){if(!sessionId)throw new Error("null sessionId");if(!command)throw new Error("null command");var url=this.getUrl("Sessions/"+sessionId+"/Playing/"+command,options||{});return this.ajax({type:"POST",url:url})},ApiClient.prototype.createPackageReview=function(review){var url=this.getUrl("Packages/Reviews/"+review.id,review);return this.ajax({type:"POST",url:url})},ApiClient.prototype.getPackageReviews=function(packageId,minRating,maxRating,limit){if(!packageId)throw new Error("null packageId");var options={};minRating&&(options.MinRating=minRating),maxRating&&(options.MaxRating=maxRating),limit&&(options.Limit=limit);var url=this.getUrl("Packages/"+packageId+"/Reviews",options);return this.getJSON(url)},ApiClient.prototype.getSavedEndpointInfo=function(){return this._endPointInfo},ApiClient.prototype.getEndpointInfo=function(){var savedValue=this._endPointInfo;if(savedValue)return Promise.resolve(savedValue);var instance=this;return this.getJSON(this.getUrl("System/Endpoint")).then(function(endPointInfo){return setSavedEndpointInfo(instance,endPointInfo),endPointInfo})},ApiClient.prototype.getWakeOnLanInfo=function(){return this.getJSON(this.getUrl("System/WakeOnLanInfo"))},ApiClient.prototype.getLatestItems=function(options){return options=options||{},this.getJSON(this.getUrl("Users/"+this.getCurrentUserId()+"/Items/Latest",options))},ApiClient.prototype.supportsWakeOnLan=function(){return!!wakeOnLan.isSupported()&&0<getCachedWakeOnLanInfo(this).length},ApiClient.prototype.wakeOnLan=function(){var infos=getCachedWakeOnLanInfo(this);return new Promise(function(resolve,reject){!function sendNextWakeOnLan(infos,index,resolve){if(index>=infos.length)return void resolve();var info=infos[index];console.log("sending wakeonlan to "+info.MacAddress);wakeOnLan.send(info).then(function(result){sendNextWakeOnLan(infos,index+1,resolve)},function(){sendNextWakeOnLan(infos,index+1,resolve)})}(infos,0,resolve)})},ApiClient.prototype.setSystemInfo=function(info){this._serverVersion=info.Version},ApiClient.prototype.serverVersion=function(){return this._serverVersion},ApiClient.prototype.isMinServerVersion=function(version){var serverVersion=this.serverVersion();return!!serverVersion&&0<=function(a,b){a=a.split("."),b=b.split(".");for(var i=0,length=Math.max(a.length,b.length);i<length;i++){var aVal=parseInt(a[i]||"0"),bVal=parseInt(b[i]||"0");if(aVal<bVal)return-1;if(bVal<aVal)return 1}return 0}(serverVersion,version)},ApiClient.prototype.handleMessageReceived=function(msg){onMessageReceivedInternal(this,msg)},ApiClient});