/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class AutoDateHistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Numeric, AutoDateHistogramAggregationBuilder> {
    public static final String NAME = "auto_date_histogram";
    private static final ParseField NUM_BUCKETS_FIELD = new ParseField("buckets", new String[0]);
    private static final ParseField MINIMUM_INTERVAL_FIELD = new ParseField("minimum_interval", new String[0]);
    private static final ObjectParser<AutoDateHistogramAggregationBuilder, Void> PARSER = new ObjectParser("auto_date_histogram");
    public static final Map<Rounding.DateTimeUnit, String> ALLOWED_INTERVALS;
    private int numBuckets = 10;
    private String minimumIntervalExpression;

    static RoundingInfo[] buildRoundings(ZoneId timeZone, String minimumInterval) {
        int indexToSliceFrom = 0;
        RoundingInfo[] roundings = new RoundingInfo[]{new RoundingInfo(Rounding.DateTimeUnit.SECOND_OF_MINUTE, timeZone, 1000L, "s", 1, 5, 10, 30), new RoundingInfo(Rounding.DateTimeUnit.MINUTES_OF_HOUR, timeZone, 60000L, "m", 1, 5, 10, 30), new RoundingInfo(Rounding.DateTimeUnit.HOUR_OF_DAY, timeZone, 3600000L, "h", 1, 3, 12), new RoundingInfo(Rounding.DateTimeUnit.DAY_OF_MONTH, timeZone, 86400000L, "d", 1, 7), new RoundingInfo(Rounding.DateTimeUnit.MONTH_OF_YEAR, timeZone, 2592000000L, "M", 1, 3), new RoundingInfo(Rounding.DateTimeUnit.YEAR_OF_CENTURY, timeZone, 31536000000L, "y", 1, 5, 10, 20, 50, 100)};
        for (int i = 0; i < roundings.length; ++i) {
            RoundingInfo roundingInfo = roundings[i];
            if (!roundingInfo.getDateTimeUnit().equals(minimumInterval)) continue;
            indexToSliceFrom = i;
            break;
        }
        return Arrays.copyOfRange(roundings, indexToSliceFrom, roundings.length);
    }

    public static AutoDateHistogramAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (AutoDateHistogramAggregationBuilder)PARSER.parse(parser, (Object)new AutoDateHistogramAggregationBuilder(aggregationName), null);
    }

    public String getMinimumIntervalExpression() {
        return this.minimumIntervalExpression;
    }

    public AutoDateHistogramAggregationBuilder setMinimumIntervalExpression(String minimumIntervalExpression) {
        if (minimumIntervalExpression != null && !ALLOWED_INTERVALS.containsValue(minimumIntervalExpression)) {
            throw new IllegalArgumentException(MINIMUM_INTERVAL_FIELD.getPreferredName() + " must be one of [" + ALLOWED_INTERVALS.values().toString() + "]");
        }
        this.minimumIntervalExpression = minimumIntervalExpression;
        return this;
    }

    public AutoDateHistogramAggregationBuilder(String name) {
        super(name, ValuesSourceType.NUMERIC, ValueType.DATE);
    }

    public AutoDateHistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.NUMERIC, ValueType.DATE);
        this.numBuckets = in.readVInt();
        if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
            this.minimumIntervalExpression = in.readOptionalString();
        }
    }

    protected AutoDateHistogramAggregationBuilder(AutoDateHistogramAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.numBuckets = clone.numBuckets;
        this.minimumIntervalExpression = clone.minimumIntervalExpression;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new AutoDateHistogramAggregationBuilder(this, factoriesBuilder, metaData);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numBuckets);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalString(this.minimumIntervalExpression);
        }
    }

    @Override
    public String getType() {
        return NAME;
    }

    public AutoDateHistogramAggregationBuilder setNumBuckets(int numBuckets) {
        if (numBuckets <= 0) {
            throw new IllegalArgumentException(NUM_BUCKETS_FIELD.getPreferredName() + " must be greater than 0 for [" + this.name + "]");
        }
        this.numBuckets = numBuckets;
        return this;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Numeric> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        RoundingInfo[] roundings = AutoDateHistogramAggregationBuilder.buildRoundings(this.timeZone(), this.getMinimumIntervalExpression());
        int maxRoundingInterval = Arrays.stream(roundings, 0, roundings.length - 1).map(rounding -> rounding.innerIntervals).flatMapToInt(Arrays::stream).boxed().reduce(Integer::max).get();
        Settings settings = context.getQueryShardContext().getIndexSettings().getNodeSettings();
        int maxBuckets = MultiBucketConsumerService.MAX_BUCKET_SETTING.get(settings);
        int bucketCeiling = maxBuckets / maxRoundingInterval;
        if (this.numBuckets > bucketCeiling) {
            throw new IllegalArgumentException(NUM_BUCKETS_FIELD.getPreferredName() + " must be less than " + bucketCeiling);
        }
        return new AutoDateHistogramAggregatorFactory(this.name, config, this.numBuckets, roundings, context, parent, subFactoriesBuilder, this.metaData);
    }

    static Rounding createRounding(Rounding.DateTimeUnit interval, ZoneId timeZone) {
        Rounding.Builder tzRoundingBuilder = Rounding.builder(interval);
        if (timeZone != null) {
            tzRoundingBuilder.timeZone(timeZone);
        }
        Rounding rounding = tzRoundingBuilder.build();
        return rounding;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NUM_BUCKETS_FIELD.getPreferredName(), this.numBuckets);
        builder.field(MINIMUM_INTERVAL_FIELD.getPreferredName(), this.minimumIntervalExpression);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numBuckets, this.minimumIntervalExpression);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AutoDateHistogramAggregationBuilder other = (AutoDateHistogramAggregationBuilder)obj;
        return Objects.equals(this.numBuckets, other.numBuckets) && Objects.equals(this.minimumIntervalExpression, other.minimumIntervalExpression);
    }

    static {
        ValuesSourceParserHelper.declareNumericFields(PARSER, true, true, true);
        PARSER.declareInt(AutoDateHistogramAggregationBuilder::setNumBuckets, NUM_BUCKETS_FIELD);
        PARSER.declareStringOrNull(AutoDateHistogramAggregationBuilder::setMinimumIntervalExpression, MINIMUM_INTERVAL_FIELD);
        ALLOWED_INTERVALS = new HashMap<Rounding.DateTimeUnit, String>();
        ALLOWED_INTERVALS.put(Rounding.DateTimeUnit.YEAR_OF_CENTURY, "year");
        ALLOWED_INTERVALS.put(Rounding.DateTimeUnit.MONTH_OF_YEAR, "month");
        ALLOWED_INTERVALS.put(Rounding.DateTimeUnit.DAY_OF_MONTH, "day");
        ALLOWED_INTERVALS.put(Rounding.DateTimeUnit.HOUR_OF_DAY, "hour");
        ALLOWED_INTERVALS.put(Rounding.DateTimeUnit.MINUTES_OF_HOUR, "minute");
        ALLOWED_INTERVALS.put(Rounding.DateTimeUnit.SECOND_OF_MINUTE, "second");
    }

    public static class RoundingInfo
    implements Writeable {
        final Rounding rounding;
        final int[] innerIntervals;
        final long roughEstimateDurationMillis;
        final String unitAbbreviation;
        final String dateTimeUnit;

        public RoundingInfo(Rounding.DateTimeUnit dateTimeUnit, ZoneId timeZone, long roughEstimateDurationMillis, String unitAbbreviation, int ... innerIntervals) {
            this.rounding = AutoDateHistogramAggregationBuilder.createRounding(dateTimeUnit, timeZone);
            this.roughEstimateDurationMillis = roughEstimateDurationMillis;
            this.unitAbbreviation = unitAbbreviation;
            this.innerIntervals = innerIntervals;
            Objects.requireNonNull(dateTimeUnit, "dateTimeUnit cannot be null");
            if (!ALLOWED_INTERVALS.containsKey((Object)dateTimeUnit)) {
                throw new IllegalArgumentException("dateTimeUnit must be one of " + ALLOWED_INTERVALS.keySet().toString());
            }
            this.dateTimeUnit = ALLOWED_INTERVALS.get((Object)dateTimeUnit);
        }

        public RoundingInfo(StreamInput in) throws IOException {
            this.rounding = Rounding.read(in);
            this.roughEstimateDurationMillis = in.readVLong();
            this.innerIntervals = in.readIntArray();
            this.unitAbbreviation = in.readString();
            this.dateTimeUnit = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.rounding.writeTo(out);
            out.writeVLong(this.roughEstimateDurationMillis);
            out.writeIntArray(this.innerIntervals);
            out.writeString(this.unitAbbreviation);
            out.writeString(this.dateTimeUnit);
        }

        public int getMaximumInnerInterval() {
            return this.innerIntervals[this.innerIntervals.length - 1];
        }

        public String getDateTimeUnit() {
            return this.dateTimeUnit;
        }

        public long getRoughEstimateDurationMillis() {
            return this.roughEstimateDurationMillis;
        }

        public int hashCode() {
            return Objects.hash(this.rounding, Arrays.hashCode(this.innerIntervals), this.dateTimeUnit);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            RoundingInfo other = (RoundingInfo)obj;
            return Objects.equals(this.rounding, other.rounding) && Objects.deepEquals(this.innerIntervals, other.innerIntervals) && Objects.equals(this.dateTimeUnit, other.dateTimeUnit);
        }
    }
}

