/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core;

import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;

public class EJBBean
extends ModuleArtifactDelegate {
    public static final String EJB_11 = "1.1";
    public static final String EJB_20 = "2.0";
    public static final String EJB_21 = "2.1";
    public static final String EJB_30 = "3.0";
    private String jndiName;
    private String interfaceName;
    private boolean local;
    private boolean remote;
    private String version;

    public EJBBean(IModule module, String jndiName, boolean remote, boolean local) {
        super(module);
        this.jndiName = jndiName;
        this.remote = remote;
        this.local = local;
        this.version = EJB_21;
    }

    public EJBBean(IModule module, String jndiName, boolean remote, boolean local, String version) {
        super(module);
        this.jndiName = jndiName;
        this.remote = remote;
        this.local = local;
        this.version = version;
    }

    public EJBBean(IModule module, String jndiName, boolean remote, boolean local, String version, String interfaceName) {
        super(module);
        this.jndiName = jndiName;
        this.remote = remote;
        this.local = local;
        this.version = version;
        this.interfaceName = interfaceName;
    }

    public EJBBean() {
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public boolean hasRemoteInterface() {
        return this.remote;
    }

    public boolean hasLocalInterface() {
        return this.local;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        String ejbName = this.interfaceName != null && this.interfaceName.length() > 0 ? this.interfaceName : this.jndiName;
        return NLS.bind((String)Messages.artifactEJB, (Object)ejbName);
    }

    public void deserialize(String s) {
        int ind = s.indexOf("//");
        super.deserialize(s.substring(0, ind));
        this.local = 'T' == s.charAt(ind + 2);
        this.remote = 'T' == s.charAt(ind + 3);
        this.jndiName = s.substring(ind + 4);
    }

    public String serialize() {
        StringBuffer sb = new StringBuffer(super.serialize());
        sb.append("//");
        if (this.local) {
            sb.append("T");
        } else {
            sb.append("F");
        }
        if (this.remote) {
            sb.append("T");
        } else {
            sb.append("F");
        }
        sb.append(this.jndiName);
        return sb.toString();
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }
}

