/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output;

import java.util.Map;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebuggerCommand;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessage;

public class ScopeMessage
extends DebuggerMessage {
    public ScopeMessage(Ref scopeRef) {
        super(DebuggerCommand.SCOPE.value);
        scopeRef.fillJson(this.getArguments());
        this.putArgument("inlineRefs", true);
    }

    public static abstract class Host {
        public static Host createFrame(final int frameNumber) {
            return new Host(){

                @Override
                void fillJson(Map<? super String, ? super Object> object) {
                    object.put("frameNumber", (Object)frameNumber);
                }
            };
        }

        public static Host createFunction(final long functionHandle) {
            return new Host(){

                @Override
                void fillJson(Map<? super String, ? super Object> object) {
                    object.put("functionHandle", (Object)functionHandle);
                }
            };
        }

        abstract void fillJson(Map<? super String, ? super Object> var1);
    }

    public static class Ref {
        private final int scopeNumber;
        private final Host host;

        public Ref(int scopeNumber, Host host) {
            this.scopeNumber = scopeNumber;
            this.host = host;
        }

        void fillJson(Map<? super String, ? super Object> object) {
            object.put("number", (Object)this.scopeNumber);
            this.host.fillJson(object);
        }
    }
}

