/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.security;

import java.sql.ResultSet;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ExasolSystemGrant
implements DBAPrivilege {
    private ExasolDataSource dataSource;
    private Boolean adminOption;
    private String sysPrivilege;
    private Boolean isPersisted;
    private String grantee;

    public ExasolSystemGrant(ExasolDataSource dataSource, ResultSet resultSet) throws DBException {
        this.dataSource = dataSource;
        this.sysPrivilege = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PRIVILEGE");
        this.adminOption = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"ADMIN_OPTION");
        this.isPersisted = true;
        this.grantee = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTEE");
    }

    @Property(viewable=true, order=10)
    public String getSystemPrivilege() {
        return this.sysPrivilege;
    }

    @Property(viewable=true, order=20)
    public Boolean getAdminOption() {
        return this.adminOption;
    }

    @Property(hidden=true, multiline=true)
    public String getDescription() {
        return "";
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(hidden=true)
    public String getName() {
        return this.grantee;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }
}

