/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.util.function.Consumer;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.DeferredPromiseImpl;
import org.osgi.util.promise.FailedPromiseImpl;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.ResolvedPromiseImpl;
import org.osgi.util.promise.Success;

abstract class PromiseImpl<T>
implements Promise<T> {
    private final PromiseFactory factory;
    private final ConcurrentLinkedQueue<Runnable> callbacks;

    PromiseImpl(PromiseFactory factory) {
        this.factory = Objects.requireNonNull(factory);
        this.callbacks = new ConcurrentLinkedQueue();
    }

    <V> DeferredPromiseImpl<V> deferred() {
        return new DeferredPromiseImpl(this.factory);
    }

    <V> ResolvedPromiseImpl<V> resolved(V v) {
        return new ResolvedPromiseImpl<V>(v, this.factory);
    }

    <V> FailedPromiseImpl<V> failed(Throwable f) {
        return new FailedPromiseImpl(f, this.factory);
    }

    @Override
    public Promise<T> onResolve(Runnable callback) {
        Objects.requireNonNull(callback);
        if (this.factory.allowCurrentThread() && this.isDone()) {
            try {
                callback.run();
            }
            catch (Throwable t) {
                PromiseImpl.uncaughtException(t);
            }
        } else {
            this.callbacks.offer(callback);
            this.notifyCallbacks();
        }
        return this;
    }

    void notifyCallbacks() {
        if (!this.isDone()) {
            return;
        }
        Runnable callback = this.callbacks.poll();
        while (callback != null) {
            try {
                try {
                    this.factory.executor().execute(callback);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    callback.run();
                }
            }
            catch (Throwable t) {
                PromiseImpl.uncaughtException(t);
            }
            callback = this.callbacks.poll();
        }
    }

    ScheduledFuture<?> schedule(Runnable operation, long delay, TimeUnit unit) {
        try {
            try {
                return this.factory.scheduledExecutor().schedule(operation, delay, unit);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                operation.run();
            }
        }
        catch (Throwable t) {
            PromiseImpl.uncaughtException(t);
        }
        return null;
    }

    static void uncaughtException(Throwable t) {
        try {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, t);
        }
        catch (Throwable throwable) {}
    }

    @Override
    public Promise<T> onSuccess(Consumer<? super T> success) {
        return this.onResolve(new OnSuccess(success));
    }

    @Override
    public Promise<T> onFailure(Consumer<? super Throwable> failure) {
        return this.onResolve(new OnFailure(failure));
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success, Failure failure) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Then<T>(this, success, failure));
        return chained.orDone();
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success) {
        return this.then(success, null);
    }

    @Override
    public Promise<T> thenAccept(Consumer<? super T> consumer) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.ThenAccept(this, consumer));
        return chained.orDone();
    }

    @Override
    public Promise<T> filter(Predicate<? super T> predicate) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Filter(this, predicate));
        return chained.orDone();
    }

    @Override
    public <R> Promise<R> map(Function<? super T, ? extends R> mapper) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Map<T>(this, mapper));
        return chained.orDone();
    }

    @Override
    public <R> Promise<R> flatMap(Function<? super T, Promise<? extends R>> mapper) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.FlatMap<T>(this, mapper));
        return chained.orDone();
    }

    @Override
    public Promise<T> recover(Function<Promise<?>, ? extends T> recovery) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Recover(this, recovery));
        return chained.orDone();
    }

    @Override
    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> recovery) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.RecoverWith(this, recovery));
        return chained.orDone();
    }

    @Override
    public Promise<T> fallbackTo(Promise<? extends T> fallback) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.FallbackTo(this, fallback));
        return chained.orDone();
    }

    @Override
    public Promise<T> timeout(long millis) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Timeout(this, millis));
        return chained.orDone();
    }

    @Override
    public Promise<T> delay(long millis) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(deferredPromiseImpl.new DeferredPromiseImpl.Delay(this, millis));
        return chained.orDone();
    }

    abstract Result<T> collect();

    static <R> Result<R> collect(Promise<? extends R> promise) {
        if (promise instanceof PromiseImpl) {
            PromiseImpl impl = (PromiseImpl)promise;
            return impl.collect();
        }
        if (!promise.isDone()) {
            return new Result((Throwable)((Object)new AssertionError((Object)"promise not resolved")));
        }
        boolean interrupted = Thread.interrupted();
        try {
            Throwable fail = promise.getFailure();
            if (fail == null) {
                Result<R> result = new Result<R>(promise.getValue());
                return result;
            }
            Result result = new Result(fail);
            return result;
        }
        catch (Throwable e) {
            Result result = new Result(e);
            return result;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private final class OnFailure
    implements Runnable {
        private final Consumer<? super Throwable> failure;

        OnFailure(Consumer<? super Throwable> failure) {
            this.failure = Objects.requireNonNull(failure);
        }

        @Override
        public void run() {
            Result result = PromiseImpl.this.collect();
            if (result.fail != null) {
                try {
                    this.failure.accept(result.fail);
                }
                catch (Throwable e) {
                    PromiseImpl.uncaughtException(e);
                }
            }
        }
    }

    private final class OnSuccess
    implements Runnable {
        private final Consumer<? super T> success;

        OnSuccess(Consumer<? super T> success) {
            this.success = Objects.requireNonNull(success);
        }

        @Override
        public void run() {
            Result result = PromiseImpl.this.collect();
            if (result.fail == null) {
                try {
                    this.success.accept(result.value);
                }
                catch (Throwable e) {
                    PromiseImpl.uncaughtException(e);
                }
            }
        }
    }

    static final class Result<P> {
        P value;
        Throwable fail;

        Result(P value) {
            this.value = value;
            this.fail = null;
        }

        Result(Throwable fail) {
            this.value = null;
            this.fail = fail;
        }
    }
}

