/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.dialogs.BaseWizard;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.task.EditTaskConfigurationDialog;
import org.jkiss.dbeaver.ui.task.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.ui.task.TaskConfigurationWizardPageTask;

public abstract class TaskConfigurationWizard
extends BaseWizard
implements IWorkbenchWizard {
    private DBTTask currentTask;
    private IStructuredSelection currentSelection;

    protected TaskConfigurationWizard() {
    }

    protected TaskConfigurationWizard(@Nullable DBTTask task) {
        this.currentTask = task;
    }

    protected abstract String getDefaultWindowTitle();

    public boolean isTaskEditor() {
        return this.currentTask != null;
    }

    public abstract String getTaskTypeId();

    public abstract void saveTaskState(DBRProgressMonitor var1, Map<String, Object> var2);

    public IStructuredSelection getCurrentSelection() {
        return this.currentSelection;
    }

    public DBTTask getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(DBTTask currentTask) {
        this.currentTask = currentTask;
        this.updateWizardTitle();
        this.getContainer().updateButtons();
    }

    public DBPProject getProject() {
        return this.currentTask != null ? this.currentTask.getProject() : NavigatorUtils.getSelectedProject();
    }

    protected void updateWizardTitle() {
        String wizTitle = this.getDefaultWindowTitle();
        if (this.isTaskEditor()) {
            TaskConfigurationWizardPageTask taskPage = this.getContainer() == null ? null : this.getContainer().getTaskPage();
            wizTitle = String.valueOf(wizTitle) + " - [" + (taskPage == null ? this.currentTask.getName() : taskPage.getTaskName()) + "]";
        }
        this.setWindowTitle(wizTitle);
    }

    public TaskConfigurationWizardDialog getContainer() {
        return (TaskConfigurationWizardDialog)super.getContainer();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.updateWizardTitle();
        this.setNeedsProgressMonitor(true);
        this.currentSelection = currentSelection;
        this.getContainer().addPageChangedListener(event -> this.updateWizardTitle());
    }

    public void addPages() {
        super.addPages();
        if (this.isCurrentTaskSaved()) {
            this.addPage((IWizardPage)new TaskConfigurationWizardPageTask(this.getCurrentTask()));
        }
    }

    public boolean isCurrentTaskSaved() {
        return this.getCurrentTask() != null && this.getCurrentTask().getProject().getTaskManager().getTaskById(this.getCurrentTask().getId()) != null;
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (this.isPageValid(page) && !page.isPageComplete()) {
                return false;
            }
            ++n2;
        }
        TaskConfigurationWizardPageTask taskPage = this.getContainer().getTaskPage();
        return taskPage == null || taskPage.isPageComplete();
    }

    public boolean performFinish() {
        if (this.currentTask != null) {
            this.saveTask();
        }
        return true;
    }

    protected boolean isPageValid(IWizardPage page) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveTask() {
        DBTTask currentTask = this.getCurrentTask();
        if (currentTask == null) {
            DBTTaskType taskType = TaskRegistry.getInstance().getTaskType(this.getTaskTypeId());
            if (taskType == null) {
                DBWorkbench.getPlatformUI().showError("No task type", "Can't find task type " + this.getTaskTypeId());
                return;
            }
            EditTaskConfigurationDialog dialog = new EditTaskConfigurationDialog(this.getContainer().getShell(), this.getProject(), taskType);
            if (dialog.open() != 0) return;
            currentTask = dialog.getTask();
            this.setCurrentTask(currentTask);
        } else {
            TaskConfigurationWizardPageTask taskPage = this.getContainer().getTaskPage();
            if (taskPage != null) {
                taskPage.saveSettings();
            }
        }
        try {
            DBTTask theTask = currentTask;
            this.getRunnableContext().run(true, true, monitor -> {
                try {
                    this.saveTaskState(monitor, theTask.getProperties());
                    theTask.getProject().getTaskManager().updateTaskConfiguration(theTask);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
            return;
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Tsk save error", "Error saving task configuration", e.getTargetException());
            return;
        }
        catch (InterruptedException interruptedException) {}
    }
}

