# is-git-url [![NPM version](https://img.shields.io/npm/v/is-git-url.svg?style=flat)](https://www.npmjs.com/package/is-git-url) [![NPM monthly downloads](https://img.shields.io/npm/dm/is-git-url.svg?style=flat)](https://npmjs.org/package/is-git-url) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/is-git-url.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/is-git-url)

> Regex to validate that a URL is a git url.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save is-git-url
```

Install with [yarn](https://yarnpkg.com):

```sh
$ yarn add is-git-url
```

## Usage

```js
var isGitUrl = require('is-git-url');

isGitUrl('git://github.com/jonschlinkert/is-git-url.git');
//=> true

isGitUrl('https://github.com/jonschlinkert/');
//=> false
```

Edit on [debuggex](https://www.debuggex.com/r/WeYxcD7Ghp5ekrPR/0#cheatsheet)

![image](https://cloud.githubusercontent.com/assets/383994/2627089/bd37da5c-bdf9-11e3-9c26-d2b02f46bc24.png)

See [http://git-scm.com/book/ch4-1.html](http://git-scm.com/book/ch4-1.html) for more info.

## About

### Related projects

* [git-branch](https://www.npmjs.com/package/git-branch): Get the current branch for a local git repository. | [homepage](https://github.com/jonschlinkert/git-branch "Get the current branch for a local git repository.")
* [git-repo-name](https://www.npmjs.com/package/git-repo-name): Get the repository name from the git remote origin URL. | [homepage](https://github.com/jonschlinkert/git-repo-name "Get the repository name from the git remote origin URL.")
* [git-username](https://www.npmjs.com/package/git-username): Get the username from a git remote origin URL. | [homepage](https://github.com/jonschlinkert/git-username "Get the username from a git remote origin URL.")
* [github-contributors](https://www.npmjs.com/package/github-contributors): Generate a markdown or JSON list of contributors for a project using the GitHub API. | [homepage](https://github.com/jonschlinkert/github-contributors "Generate a markdown or JSON list of contributors for a project using the GitHub API.")
* [parse-github-url](https://www.npmjs.com/package/parse-github-url): Parse a github URL into an object. | [homepage](https://github.com/jonschlinkert/parse-github-url "Parse a github URL into an object.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** | 
| --- | --- |
| 17 | [jonschlinkert](https://github.com/jonschlinkert) |
| 2 | [tunnckoCore](https://github.com/tunnckoCore) |
| 1 | [dcadenas](https://github.com/dcadenas) |
| 1 | [quaertym](https://github.com/quaertym) |
| 1 | [LoicMahieu](https://github.com/LoicMahieu) |

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.5.0, on April 17, 2017._