"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const project_1 = require("./project");
function getProjectTargets(projectOrHost, projectName = '') {
    const project = project_1.isWorkspaceProject(projectOrHost)
        ? projectOrHost
        : project_1.getProject(projectOrHost, projectName);
    const projectTargets = project.targets || project.architect;
    if (!projectTargets) {
        throw new Error('Project target not found.');
    }
    return projectTargets;
}
exports.getProjectTargets = getProjectTargets;
function targetBuildNotFoundError() {
    return new schematics_1.SchematicsException(`Project target "build" not found.`);
}
exports.targetBuildNotFoundError = targetBuildNotFoundError;
//# sourceMappingURL=data:application/json;base64,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