"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes2 = require("../prop-types");

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function getIconClass(icon, animation) {
  return (0, _classnames["default"])('github-PushPull-icon', 'icon', `icon-${icon}`, {
    [`animate-${animation}`]: !!animation
  });
}

class PushPullView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "onClickPush", clickEvent => {
      if (this.props.isSyncing) {
        return;
      }

      this.props.push({
        force: clickEvent.metaKey || clickEvent.ctrlKey,
        setUpstream: !this.props.currentRemote.isPresent()
      });
    });

    _defineProperty(this, "onClickPull", clickEvent => {
      if (this.props.isSyncing) {
        return;
      }

      this.props.pull();
    });

    _defineProperty(this, "onClickPushPull", clickEvent => {
      if (this.props.isSyncing) {
        return;
      }

      if (clickEvent.metaKey || clickEvent.ctrlKey) {
        this.props.push({
          force: true
        });
      } else {
        this.props.pull();
      }
    });

    _defineProperty(this, "onClickPublish", clickEvent => {
      if (this.props.isSyncing) {
        return;
      }

      this.props.push({
        setUpstream: !this.props.currentRemote.isPresent()
      });
    });

    _defineProperty(this, "onClickFetch", clickEvent => {
      if (this.props.isSyncing) {
        return;
      }

      this.props.fetch();
    });

    this.refTileNode = new _refHolder["default"]();
  }

  getTileStates() {
    const modKey = process.platform === 'darwin' ? 'Cmd' : 'Ctrl';
    return {
      fetching: {
        tooltip: 'Fetching from remote',
        icon: 'sync',
        text: 'Fetching',
        iconAnimation: 'rotate'
      },
      pulling: {
        tooltip: 'Pulling from remote',
        icon: 'arrow-down',
        text: 'Pulling',
        iconAnimation: 'down'
      },
      pushing: {
        tooltip: 'Pushing to remote',
        icon: 'arrow-up',
        text: 'Pushing',
        iconAnimation: 'up'
      },
      ahead: {
        onClick: this.onClickPush,
        tooltip: `Click to push<br />${modKey}-click to force push<br />Right-click for more`,
        icon: 'arrow-up',
        text: `Push ${this.props.aheadCount}`
      },
      behind: {
        onClick: this.onClickPull,
        tooltip: 'Click to pull<br />Right-click for more',
        icon: 'arrow-down',
        text: `Pull ${this.props.behindCount}`
      },
      aheadBehind: {
        onClick: this.onClickPushPull,
        tooltip: `Click to pull<br />${modKey}-click to force push<br />Right-click for more`,
        icon: 'arrow-down',
        text: `Pull ${this.props.behindCount}`,
        secondaryIcon: 'arrow-up',
        secondaryText: `${this.props.aheadCount} `
      },
      published: {
        onClick: this.onClickFetch,
        tooltip: 'Click to fetch<br />Right-click for more',
        icon: 'sync',
        text: 'Fetch'
      },
      unpublished: {
        onClick: this.onClickPublish,
        tooltip: 'Click to set up a remote tracking branch<br />Right-click for more',
        icon: 'cloud-upload',
        text: 'Publish'
      },
      noRemote: {
        tooltip: 'There is no remote named "origin"',
        icon: 'stop',
        text: 'No remote'
      },
      detached: {
        tooltip: 'Create a branch if you wish to push your work anywhere',
        icon: 'stop',
        text: 'Not on branch'
      }
    };
  }

  render() {
    const isAhead = this.props.aheadCount > 0;
    const isBehind = this.props.behindCount > 0;
    const isUnpublished = !this.props.currentRemote.isPresent();
    const isDetached = this.props.currentBranch.isDetached();
    const isFetching = this.props.isFetching;
    const isPulling = this.props.isPulling;
    const isPushing = this.props.isPushing;
    const hasOrigin = !!this.props.originExists;
    const tileStates = this.getTileStates();
    let tileState;

    if (isFetching) {
      tileState = tileStates.fetching;
    } else if (isPulling) {
      tileState = tileStates.pulling;
    } else if (isPushing) {
      tileState = tileStates.pushing;
    } else if (isAhead && !isBehind && !isUnpublished) {
      tileState = tileStates.ahead;
    } else if (isBehind && !isAhead && !isUnpublished) {
      tileState = tileStates.behind;
    } else if (isBehind && isAhead && !isUnpublished) {
      tileState = tileStates.aheadBehind;
    } else if (!isBehind && !isAhead && !isUnpublished && !isDetached) {
      tileState = tileStates.published;
    } else if (isUnpublished && !isDetached && hasOrigin) {
      tileState = tileStates.unpublished;
    } else if (isUnpublished && !isDetached && !hasOrigin) {
      tileState = tileStates.noRemote;
    } else if (isDetached) {
      tileState = tileStates.detached;
    }

    return _react["default"].createElement("div", {
      onClick: tileState.onClick,
      ref: this.refTileNode.setter,
      className: (0, _classnames["default"])('github-PushPull', 'inline-block', {
        'github-branch-detached': isDetached
      })
    }, tileState && _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("span", null, tileState.secondaryText && _react["default"].createElement("span", {
      className: "secondary"
    }, _react["default"].createElement("span", {
      className: getIconClass(tileState.secondaryIcon)
    }), tileState.secondaryText), _react["default"].createElement("span", {
      className: getIconClass(tileState.icon, tileState.iconAnimation)
    }), tileState.text), _react["default"].createElement(_tooltip["default"], {
      key: "tooltip",
      manager: this.props.tooltipManager,
      target: this.refTileNode,
      title: `<div style="text-align: left; line-height: 1.2em;">${tileState.tooltip}</div>`,
      showDelay: atom.tooltips.hoverDefaults.delay.show,
      hideDelay: atom.tooltips.hoverDefaults.delay.hide
    })));
  }

}

exports["default"] = PushPullView;

_defineProperty(PushPullView, "propTypes", {
  currentBranch: _propTypes2.BranchPropType.isRequired,
  currentRemote: _propTypes2.RemotePropType.isRequired,
  isSyncing: _propTypes["default"].bool,
  isFetching: _propTypes["default"].bool,
  isPulling: _propTypes["default"].bool,
  isPushing: _propTypes["default"].bool,
  behindCount: _propTypes["default"].number,
  aheadCount: _propTypes["default"].number,
  push: _propTypes["default"].func.isRequired,
  pull: _propTypes["default"].func.isRequired,
  fetch: _propTypes["default"].func.isRequired,
  originExists: _propTypes["default"].bool,
  tooltipManager: _propTypes["default"].object.isRequired
});

_defineProperty(PushPullView, "defaultProps", {
  isSyncing: false,
  isFetching: false,
  isPulling: false,
  isPushing: false,
  behindCount: 0,
  aheadCount: 0
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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