"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _classnames = _interopRequireDefault(require("classnames"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = require("./atom-text-editor");

var _marker = require("./marker");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const decorationPropTypes = {
  type: _propTypes["default"].oneOf(['line', 'line-number', 'highlight', 'overlay', 'gutter', 'block']).isRequired,
  className: _propTypes["default"].string,
  style: _propTypes["default"].string,
  onlyHead: _propTypes["default"].bool,
  onlyEmpty: _propTypes["default"].bool,
  onlyNonEmpty: _propTypes["default"].bool,
  omitEmptyLastRow: _propTypes["default"].bool,
  position: _propTypes["default"].oneOf(['head', 'tail', 'before', 'after']),
  order: _propTypes["default"].number,
  avoidOverflow: _propTypes["default"].bool,
  gutterName: _propTypes["default"].string
};

class BareDecoration extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "observeParents", () => {
      this.decorationHolder.map(decoration => decoration.destroy());
      const editorValid = this.props.editorHolder.map(editor => !editor.isDestroyed()).getOr(false);
      const decorableValid = this.props.decorableHolder.map(decorable => !decorable.isDestroyed()).getOr(false); // Ensure the Marker or MarkerLayer corresponds to the context's TextEditor

      const decorableMatches = this.props.decorableHolder.map(decorable => this.props.editorHolder.map(editor => {
        const layer = decorable.layer || decorable;
        const displayLayer = editor.getMarkerLayer(layer.id);

        if (!displayLayer) {
          return false;
        }

        if (displayLayer !== layer && displayLayer.bufferMarkerLayer !== layer) {
          return false;
        }

        return true;
      }).getOr(false)).getOr(false);

      if (!editorValid || !decorableValid || !decorableMatches) {
        return;
      } // delay decoration creation when it's a gutter type;
      // instead wait for the Gutter to be added to the editor first


      if (this.props.type === 'gutter') {
        if (!this.props.gutterName) {
          throw new Error('You are trying to decorate a gutter but did not supply gutterName prop.');
        }

        this.props.editorHolder.map(editor => {
          this.gutterSub = editor.observeGutters(gutter => {
            if (gutter.name === this.props.gutterName) {
              this.createDecoration();
            }
          });
          return null;
        });
        return;
      }

      this.createDecoration();
    });

    this.decorationHolder = new _refHolder["default"]();
    this.editorSub = new _eventKit.Disposable();
    this.decorableSub = new _eventKit.Disposable();
    this.gutterSub = new _eventKit.Disposable();
    this.domNode = null;
    this.item = null;

    if (['gutter', 'overlay', 'block'].includes(this.props.type)) {
      this.domNode = document.createElement('div');
      this.domNode.className = (0, _classnames["default"])('react-atom-decoration', this.props.className);
    }
  }

  usesItem() {
    return this.domNode !== null;
  }

  componentDidMount() {
    this.editorSub = this.props.editorHolder.observe(this.observeParents);
    this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.editorSub.dispose();
      this.editorSub = this.props.editorHolder.observe(this.observeParents);
    }

    if (this.props.decorableHolder !== prevProps.decorableHolder) {
      this.decorableSub.dispose();
      this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
    }

    if (Object.keys(decorationPropTypes).some(key => this.props[key] !== prevProps[key])) {
      this.decorationHolder.map(decoration => decoration.destroy());
      this.createDecoration();
    }
  }

  render() {
    if (this.usesItem()) {
      return _reactDom["default"].createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  createDecoration() {
    if (this.usesItem() && !this.item) {
      this.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    const opts = this.getDecorationOpts(this.props);
    const editor = this.props.editorHolder.get();
    const decorable = this.props.decorableHolder.get();
    this.decorationHolder.setter(editor[this.props.decorateMethod](decorable, opts));
  }

  componentWillUnmount() {
    this.decorationHolder.map(decoration => decoration.destroy());
    this.editorSub.dispose();
    this.decorableSub.dispose();
    this.gutterSub.dispose();
  }

  getDecorationOpts(props) {
    return _objectSpread({}, (0, _helpers.extractProps)(props, decorationPropTypes, {
      className: 'class'
    }), {
      item: this.item
    });
  }

}

_defineProperty(BareDecoration, "propTypes", _objectSpread({
  editorHolder: _propTypes2.RefHolderPropType.isRequired,
  decorableHolder: _propTypes2.RefHolderPropType.isRequired,
  decorateMethod: _propTypes["default"].oneOf(['decorateMarker', 'decorateMarkerLayer']),
  itemHolder: _propTypes2.RefHolderPropType,
  children: _propTypes["default"].node
}, decorationPropTypes));

_defineProperty(BareDecoration, "defaultProps", {
  decorateMethod: 'decorateMarker'
});

class Decoration extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.state = {
      editorHolder: _refHolder["default"].on(this.props.editor),
      decorableHolder: _refHolder["default"].on(this.props.decorable)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    const decorableChanged = state.decorableHolder.map(decorable => decorable !== props.decorable).getOr(props.decorable !== undefined);

    if (!editorChanged && !decorableChanged) {
      return null;
    }

    const nextState = {};

    if (editorChanged) {
      nextState.editorHolder = _refHolder["default"].on(props.editor);
    }

    if (decorableChanged) {
      nextState.decorableHolder = _refHolder["default"].on(props.decorable);
    }

    return nextState;
  }

  render() {
    return _react["default"].createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react["default"].createElement(_marker.DecorableContext.Consumer, null, decorable => {
      let holder = null;
      let decorateMethod = null;

      if (!this.state.decorableHolder.isEmpty()) {
        holder = this.state.decorableHolder;
        decorateMethod = this.props.decorateMethod;
      } else {
        holder = decorable.holder;
        decorateMethod = decorable.decorateMethod;
      }

      return _react["default"].createElement(BareDecoration, _extends({
        editorHolder: editorHolder || this.state.editorHolder,
        decorableHolder: holder,
        decorateMethod: decorateMethod
      }, this.props));
    }));
  }

}

exports["default"] = Decoration;

_defineProperty(Decoration, "propTypes", {
  editor: _propTypes["default"].object,
  decorable: _propTypes["default"].object,
  decorateMethod: _propTypes["default"].oneOf(['decorateMarker', 'decorateMarkerLayer'])
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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