/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.io.XInputStream;
import com.sun.star.script.framework.container.Parcel;
import com.sun.star.script.framework.container.ScriptEntry;
import com.sun.star.script.framework.io.UCBStreamHandler;
import com.sun.star.script.framework.io.XInputStreamImpl;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.UnoRuntime;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ScriptMetaData
extends ScriptEntry {
    private boolean hasSource = false;
    private static final String locationPlaceHolder = "";
    private String source;
    private final Parcel parent;
    private static final String SHARE = "vnd.sun.star.expand:$BRAND_BASE_DIR/$BRAND_SHARE_SUBDIR";
    private static final String USER = "vnd.sun.star.expand:${$BRAND_INI_DIR/" + PathUtils.BOOTSTRAP_NAME + "::UserInstallation}/user";
    private static final String UNO_USER_PACKAGES1 = "vnd.sun.star.expand:$UNO_USER_PACKAGES_CACHE";
    private static final String UNO_USER_PACKAGES2 = USER + "/uno_packages";
    private static final String UNO_SHARED_PACKAGES1 = "$UNO_SHARED_PACKAGES_CACHE";
    private static final String UNO_SHARED_PACKAGES2 = "vnd.sun.star.expand:$BRAND_BASE_DIR/$BRAND_SHARE_SUBDIR/uno_packages";

    public ScriptMetaData(Parcel parent, ScriptEntry entry, String source) {
        super(entry);
        this.parent = parent;
        if (source != null) {
            this.hasSource = true;
            this.source = source;
        }
    }

    public boolean hasSource() {
        return this.hasSource;
    }

    public String getSource() {
        return this.source != null && this.hasSource ? this.source : null;
    }

    public byte[] getSourceBytes() {
        return this.source != null && this.hasSource ? this.source.getBytes() : null;
    }

    public String getScriptFullURL() {
        String url = "vnd.sun.star.script:" + this.parent.getName() + "." + this.getLanguageName() + "?language=" + this.getLanguage() + "&location=" + this.getParcelLocation();
        return url;
    }

    public String getShortFormScriptURL() {
        String url = "vnd.sun.star.script:" + this.parent.getName() + "." + this.getLanguageName() + "?language=" + this.getLanguage() + "&location=" + this.getLocationPlaceHolder();
        return url;
    }

    public static String getLocationPlaceHolder(String url, String pkgname) {
        String result = "Unknown";
        if (url.contains(UNO_USER_PACKAGES1) || url.contains(UNO_USER_PACKAGES2)) {
            result = PathUtils.make_url("user:uno_packages", pkgname);
        } else if (url.contains(UNO_SHARED_PACKAGES1) || url.contains(UNO_SHARED_PACKAGES2)) {
            result = PathUtils.make_url("share:uno_packages", pkgname);
        } else if (url.indexOf(SHARE) == 0) {
            result = "share";
        } else if (url.indexOf(USER) == 0) {
            result = "user";
        } else if (url.indexOf("vnd.sun.star.tdoc:") == 0) {
            result = "document";
        }
        return result;
    }

    public String getLocationPlaceHolder() {
        String placeHolder = "Unknown";
        String pathToParcel = this.parent.getPathToParcel();
        if (pathToParcel.contains(UNO_USER_PACKAGES1) || pathToParcel.contains(UNO_USER_PACKAGES2)) {
            placeHolder = "user:uno_packages";
            String unoPkg = this.parent.parent.getName();
            if (unoPkg != null) {
                placeHolder = PathUtils.make_url(placeHolder, unoPkg);
            }
        } else if (pathToParcel.contains(UNO_SHARED_PACKAGES1) || pathToParcel.contains(UNO_SHARED_PACKAGES2)) {
            placeHolder = "share:uno_packages";
            String unoPkg = this.parent.parent.getName();
            if (unoPkg != null) {
                placeHolder = PathUtils.make_url(placeHolder, unoPkg);
            }
        } else if (pathToParcel.indexOf(SHARE) == 0) {
            placeHolder = "share";
        } else if (pathToParcel.indexOf(USER) == 0) {
            placeHolder = "user";
        } else if (pathToParcel.indexOf("vnd.sun.star.tdoc:") == 0) {
            placeHolder = "document";
        }
        return placeHolder;
    }

    public String getParcelLocation() {
        return this.parent.getPathToParcel();
    }

    @Override
    public String toString() {
        return "\nParcelLocation = " + this.getParcelLocation() + "\nLocationPlaceHolder = " + locationPlaceHolder + super.toString();
    }

    public URL[] getClassPath() {
        try {
            URL url;
            String parcelPath;
            String classpath = this.getLanguageProperties().get("classpath");
            if (classpath == null) {
                classpath = locationPlaceHolder;
            }
            if (!(parcelPath = this.getParcelLocation()).endsWith("/")) {
                parcelPath = parcelPath + "/";
            }
            parcelPath = parcelPath.replace('\\', '/');
            ArrayList<URL> classPathVec = new ArrayList<URL>();
            StringTokenizer stk = new StringTokenizer(classpath, ":");
            while (stk.hasMoreElements()) {
                String relativeClasspath = stk.nextToken();
                String pathToProcess = PathUtils.make_url(parcelPath, relativeClasspath);
                URL url2 = this.createURL(pathToProcess);
                if (url2 == null) continue;
                classPathVec.add(url2);
            }
            if (classPathVec.isEmpty() && (url = this.createURL(parcelPath)) != null) {
                classPathVec.add(url);
            }
            return classPathVec.toArray(new URL[classPathVec.size()]);
        }
        catch (Exception e) {
            LogUtils.DEBUG("Failed to build class path " + e.toString());
            LogUtils.DEBUG(LogUtils.getTrace(e));
            return new URL[0];
        }
    }

    private URL createURL(String path) throws MalformedURLException {
        int indexOfColon = path.indexOf(58);
        String scheme = path.substring(0, indexOfColon);
        UCBStreamHandler handler = new UCBStreamHandler(scheme, this.parent.m_xSFA);
        path = path + "/ucb/";
        return new URL(null, path, handler);
    }

    public void loadSource() {
        block5: {
            try {
                int len;
                URL sourceUrl = this.getSourceURL();
                LogUtils.DEBUG("** In load source BUT not loading yet for " + sourceUrl);
                if (sourceUrl == null) break block5;
                StringBuilder buf = new StringBuilder();
                InputStream in = sourceUrl.openStream();
                byte[] contents = new byte[1024];
                while ((len = in.read(contents, 0, 1024)) != -1) {
                    buf.append(new String(contents, 0, len));
                }
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    LogUtils.DEBUG("** Failed to read scriot from url " + ignore.toString());
                }
                this.source = buf.toString();
                this.hasSource = true;
            }
            catch (IOException e) {
                LogUtils.DEBUG("** Failed to read scriot from url " + e.toString());
            }
        }
    }

    protected boolean writeSourceFile() {
        String sourceFilePath = this.parent.getPathToParcel() + "/" + this.getLanguageName();
        boolean result = false;
        try {
            XSimpleFileAccess2 xSFA2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)this.parent.m_xSFA);
            if (xSFA2 != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(this.getSourceBytes());
                XInputStreamImpl xis = new XInputStreamImpl(bis);
                xSFA2.writeFile(sourceFilePath, (XInputStream)xis);
                xis.closeInput();
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected boolean removeSourceFile() {
        String parcelLocation = this.parent.getPathToParcel();
        String sourceFilePath = parcelLocation + "/" + this.getLanguageName();
        boolean result = false;
        try {
            this.parent.m_xSFA.kill(sourceFilePath);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public URL getSourceURL() throws MalformedURLException {
        String sUrl = this.getParcelLocation();
        sUrl = PathUtils.make_url(sUrl, this.getLanguageName());
        LogUtils.DEBUG("Creating script url for " + sUrl);
        return this.createURL(sUrl);
    }
}

