/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.utilities.Assert;

public class SPARCRegisters {
    public static final SPARCRegister G0 = new SPARCRegister(0);
    public static final SPARCRegister G1 = new SPARCRegister(1);
    public static final SPARCRegister G2 = new SPARCRegister(2);
    public static final SPARCRegister G3 = new SPARCRegister(3);
    public static final SPARCRegister G4 = new SPARCRegister(4);
    public static final SPARCRegister G5 = new SPARCRegister(5);
    public static final SPARCRegister G6 = new SPARCRegister(6);
    public static final SPARCRegister G7 = new SPARCRegister(7);
    public static final SPARCRegister O0 = new SPARCRegister(8);
    public static final SPARCRegister O1 = new SPARCRegister(9);
    public static final SPARCRegister O2 = new SPARCRegister(10);
    public static final SPARCRegister O3 = new SPARCRegister(11);
    public static final SPARCRegister O4 = new SPARCRegister(12);
    public static final SPARCRegister O5 = new SPARCRegister(13);
    public static final SPARCRegister O6 = new SPARCRegister(14);
    public static final SPARCRegister O7 = new SPARCRegister(15);
    public static final SPARCRegister L0 = new SPARCRegister(16);
    public static final SPARCRegister L1 = new SPARCRegister(17);
    public static final SPARCRegister L2 = new SPARCRegister(18);
    public static final SPARCRegister L3 = new SPARCRegister(19);
    public static final SPARCRegister L4 = new SPARCRegister(20);
    public static final SPARCRegister L5 = new SPARCRegister(21);
    public static final SPARCRegister L6 = new SPARCRegister(22);
    public static final SPARCRegister L7 = new SPARCRegister(23);
    public static final SPARCRegister I0 = new SPARCRegister(24);
    public static final SPARCRegister I1 = new SPARCRegister(25);
    public static final SPARCRegister I2 = new SPARCRegister(26);
    public static final SPARCRegister I3 = new SPARCRegister(27);
    public static final SPARCRegister I4 = new SPARCRegister(28);
    public static final SPARCRegister I5 = new SPARCRegister(29);
    public static final SPARCRegister I6 = new SPARCRegister(30);
    public static final SPARCRegister I7 = new SPARCRegister(31);
    private static String[] registerNames = new String[32];
    public static final int NUM_REGISTERS = 32;
    private static SPARCRegister[] registers;
    public static final SPARCRegister FP;
    public static final SPARCRegister SP;
    public static final SPARCRegister Lesp;
    public static final SPARCRegister Lbcp;
    public static final SPARCRegister Lmethod;
    public static final SPARCRegister Llocals;
    public static final SPARCRegister Lmonitors;
    public static final SPARCRegister Lbyte_code;
    public static final SPARCRegister Lscratch;
    public static final SPARCRegister Lscratch2;
    public static final SPARCRegister LcpoolCache;
    public static final SPARCRegister OparamAddr;
    public static final SPARCRegister IsavedSP;
    public static final SPARCRegister IsizeCalleeParms;
    public static final SPARCRegister IdispatchAddress;
    public static final SPARCRegister IdispatchTables;

    public static int getNumRegisters() {
        return 32;
    }

    public static String getRegisterName(int regNum) {
        if (regNum < 0 || regNum >= 32) {
            return "[Illegal register " + regNum + "]";
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(regNum > -1 && regNum < 32, "invalid integer register number!");
        }
        return registerNames[regNum];
    }

    public static SPARCRegister getRegister(int regNum) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(regNum > -1 && regNum < 32, "invalid integer register number!");
        }
        return registers[regNum];
    }

    static {
        SPARCRegisters.registerNames[SPARCRegisters.G0.getNumber()] = "%g0";
        SPARCRegisters.registerNames[SPARCRegisters.G1.getNumber()] = "%g1";
        SPARCRegisters.registerNames[SPARCRegisters.G2.getNumber()] = "%g2";
        SPARCRegisters.registerNames[SPARCRegisters.G3.getNumber()] = "%g3";
        SPARCRegisters.registerNames[SPARCRegisters.G4.getNumber()] = "%g4";
        SPARCRegisters.registerNames[SPARCRegisters.G5.getNumber()] = "%g5";
        SPARCRegisters.registerNames[SPARCRegisters.G6.getNumber()] = "%g6";
        SPARCRegisters.registerNames[SPARCRegisters.G7.getNumber()] = "%g7";
        SPARCRegisters.registerNames[SPARCRegisters.O0.getNumber()] = "%o0";
        SPARCRegisters.registerNames[SPARCRegisters.O1.getNumber()] = "%o1";
        SPARCRegisters.registerNames[SPARCRegisters.O2.getNumber()] = "%o2";
        SPARCRegisters.registerNames[SPARCRegisters.O3.getNumber()] = "%o3";
        SPARCRegisters.registerNames[SPARCRegisters.O4.getNumber()] = "%o4";
        SPARCRegisters.registerNames[SPARCRegisters.O5.getNumber()] = "%o5";
        SPARCRegisters.registerNames[SPARCRegisters.O6.getNumber()] = "%sp";
        SPARCRegisters.registerNames[SPARCRegisters.O7.getNumber()] = "%o7";
        SPARCRegisters.registerNames[SPARCRegisters.I0.getNumber()] = "%i0";
        SPARCRegisters.registerNames[SPARCRegisters.I1.getNumber()] = "%i1";
        SPARCRegisters.registerNames[SPARCRegisters.I2.getNumber()] = "%i2";
        SPARCRegisters.registerNames[SPARCRegisters.I3.getNumber()] = "%i3";
        SPARCRegisters.registerNames[SPARCRegisters.I4.getNumber()] = "%i4";
        SPARCRegisters.registerNames[SPARCRegisters.I5.getNumber()] = "%i5";
        SPARCRegisters.registerNames[SPARCRegisters.I6.getNumber()] = "%fp";
        SPARCRegisters.registerNames[SPARCRegisters.I7.getNumber()] = "%i7";
        SPARCRegisters.registerNames[SPARCRegisters.L0.getNumber()] = "%l0";
        SPARCRegisters.registerNames[SPARCRegisters.L1.getNumber()] = "%l1";
        SPARCRegisters.registerNames[SPARCRegisters.L2.getNumber()] = "%l2";
        SPARCRegisters.registerNames[SPARCRegisters.L3.getNumber()] = "%l3";
        SPARCRegisters.registerNames[SPARCRegisters.L4.getNumber()] = "%l4";
        SPARCRegisters.registerNames[SPARCRegisters.L5.getNumber()] = "%l5";
        SPARCRegisters.registerNames[SPARCRegisters.L6.getNumber()] = "%l6";
        SPARCRegisters.registerNames[SPARCRegisters.L7.getNumber()] = "%l7";
        registers = new SPARCRegister[]{G0, G1, G2, G3, G4, G5, G6, G7, O0, O1, O2, O3, O4, O5, O6, O7, L0, L1, L2, L3, L4, L5, L6, L7, I0, I1, I2, I3, I4, I5, I6, I7};
        FP = I6;
        SP = O6;
        Lesp = L0;
        Lbcp = L1;
        Lmethod = L2;
        Llocals = L3;
        Lmonitors = L4;
        Lbyte_code = L5;
        Lscratch = L5;
        Lscratch2 = L6;
        LcpoolCache = L6;
        OparamAddr = O0;
        IsavedSP = I5;
        IsizeCalleeParms = I4;
        IdispatchAddress = I3;
        IdispatchTables = I2;
    }
}

