/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.IceGrid.AdapterDynamicInfo;
import com.zeroc.IceGrid.AdminPrx;
import com.zeroc.IceGrid.AdminSessionPrx;
import com.zeroc.IceGrid.ApplicationDescriptor;
import com.zeroc.IceGrid.FileIteratorPrx;
import com.zeroc.IceGrid.FileNotAvailableException;
import com.zeroc.IceGrid.NodeDescriptor;
import com.zeroc.IceGrid.NodeDynamicInfo;
import com.zeroc.IceGrid.NodeInfo;
import com.zeroc.IceGrid.NodeNotExistException;
import com.zeroc.IceGrid.NodeUnreachableException;
import com.zeroc.IceGrid.NodeUpdateDescriptor;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGrid.ServerDescriptor;
import com.zeroc.IceGrid.ServerDynamicInfo;
import com.zeroc.IceGrid.ServerInstanceDescriptor;
import com.zeroc.IceGrid.ServerState;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.LiveActions;
import com.zeroc.IceGridGUI.LiveDeployment.Communicator;
import com.zeroc.IceGridGUI.LiveDeployment.Editor;
import com.zeroc.IceGridGUI.LiveDeployment.NodeEditor;
import com.zeroc.IceGridGUI.LiveDeployment.Root;
import com.zeroc.IceGridGUI.LiveDeployment.Server;
import com.zeroc.IceGridGUI.LiveDeployment.ShowLogFileDialog;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.awt.Cursor;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;

class Node
extends Communicator {
    private final SortedMap<String, ApplicationData> _map = new TreeMap<String, ApplicationData>();
    private boolean _up = false;
    private NodeDynamicInfo _info;
    private boolean _windows = false;
    private LinkedList<Server> _servers = new LinkedList();
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon _nodeUp;
    private static Icon _nodeDown;
    private static NodeEditor _editor;
    private static JPopupMenu _popup;

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[25];
        actions[16] = this._up;
        actions[12] = this._up;
        actions[13] = this._up;
        actions[14] = this._up;
        actions[23] = this._up;
        actions[24] = this._up;
        return actions;
    }

    @Override
    public void retrieveOutput(final boolean stdout) {
        this.getRoot().openShowLogFileDialog(new ShowLogFileDialog.FileIteratorFactory(){

            @Override
            public FileIteratorPrx open(int count) throws FileNotAvailableException, NodeNotExistException, NodeUnreachableException {
                AdminSessionPrx session = Node.this.getRoot().getCoordinator().getSession();
                FileIteratorPrx result = stdout ? session.openNodeStdOut(Node.this._id, count) : session.openNodeStdErr(Node.this._id, count);
                return result;
            }

            @Override
            public String getTitle() {
                return "Node " + Node.this._id + " " + (stdout ? "stdout" : "stderr");
            }

            @Override
            public String getDefaultFilename() {
                return Node.this._id + (stdout ? ".out" : ".err");
            }
        });
    }

    @Override
    public void shutdownNode() {
        String prefix = "Shutting down node '" + this._id + "'...";
        this.getCoordinator().getStatusBar().setText(prefix);
        try {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this.getCoordinator().getAdmin().shutdownNodeAsync(this._id).whenComplete((result, ex) -> this.amiComplete(prefix, "Failed to shutdown " + this._id, (Throwable)ex));
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to shutdown " + this._id, e.toString());
        }
        finally {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void startAllServers() {
        for (Server server : this._servers) {
            if (!server.getAvailableActions()[0]) continue;
            server.start();
        }
    }

    @Override
    public void stopAllServers() {
        for (Server server : this._servers) {
            if (!server.getAvailableActions()[1]) continue;
            server.stop();
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        LiveActions la = this.getCoordinator().getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(12));
            _popup.add(la.get(13));
            _popup.add(la.get(14));
            _popup.addSeparator();
            _popup.add(la.get(23));
            _popup.add(la.get(24));
            _popup.addSeparator();
            _popup.add(la.get(16));
        }
        la.setTarget(this);
        return _popup;
    }

    @Override
    public Editor getEditor() {
        if (_editor == null) {
            _editor = new NodeEditor();
        }
        _editor.show(this);
        return _editor;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _nodeUp = Utils.getIcon("/icons/16x16/node_up.png");
            _nodeDown = Utils.getIcon("/icons/16x16/node_down.png");
        }
        if (this._up) {
            _cellRenderer.setToolTipText("Up and running");
            if (expanded) {
                _cellRenderer.setOpenIcon(_nodeUp);
            } else {
                _cellRenderer.setClosedIcon(_nodeUp);
            }
        } else {
            _cellRenderer.setToolTipText("Not running");
            if (expanded) {
                _cellRenderer.setOpenIcon(_nodeDown);
            } else {
                _cellRenderer.setClosedIcon(_nodeDown);
            }
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    protected CompletableFuture<ObjectPrx> getAdminAsync() {
        return this.getRoot().getCoordinator().getAdmin().getNodeAdminAsync(this._id);
    }

    @Override
    protected String getServerDisplayName() {
        return "Node " + this._id;
    }

    @Override
    protected String getDisplayName() {
        return "Node " + this._id;
    }

    @Override
    protected String getDefaultFileName() {
        return "node-" + this._id;
    }

    Node(Root parent, NodeDynamicInfo info) {
        super(parent, info.info.name, 2);
        this._childrenArray[0] = this._metrics;
        this._childrenArray[1] = this._servers;
        this.up(info, false);
    }

    Node(Root parent, ApplicationDescriptor appDesc, String nodeName, NodeDescriptor nodeDesc) {
        super(parent, nodeName, 2);
        this._childrenArray[0] = this._metrics;
        this._childrenArray[1] = this._servers;
        this.add(appDesc, nodeDesc);
    }

    Node(Root parent, ApplicationDescriptor appDesc, NodeUpdateDescriptor update) {
        super(parent, update.name, 2);
        this._childrenArray[0] = this._metrics;
        this._childrenArray[1] = this._servers;
        NodeDescriptor nodeDesc = new NodeDescriptor(update.variables, update.serverInstances, update.servers, update.loadFactor == null ? "" : update.loadFactor.value, update.description == null ? "" : update.description.value, update.propertySets);
        appDesc.nodes.put(this._id, nodeDesc);
        this.add(appDesc, nodeDesc);
    }

    Utils.ExpandedPropertySet expand(PropertySetDescriptor descriptor, String applicationName, Utils.Resolver resolver) {
        Utils.ExpandedPropertySet result = new Utils.ExpandedPropertySet();
        result.references = new Utils.ExpandedPropertySet[descriptor.references.length];
        int i = 0;
        for (String ref : descriptor.references) {
            result.references[i++] = this.expand(this.findNamedPropertySet(resolver.substitute(ref), applicationName), applicationName, resolver);
        }
        result.properties = descriptor.properties;
        return result;
    }

    PropertySetDescriptor findNamedPropertySet(String name, String applicationName) {
        ApplicationData appData = (ApplicationData)this._map.get(applicationName);
        if (appData != null) {
            NodeDescriptor descriptor = appData.descriptor;
            PropertySetDescriptor result = descriptor.propertySets.get(name);
            if (result != null) {
                return result;
            }
        }
        return this.getRoot().findNamedPropertySet(name, applicationName);
    }

    boolean hasServersFromApplication(String name) {
        return this._map.containsKey(name);
    }

    void add(ApplicationDescriptor appDesc, NodeDescriptor nodeDesc) {
        Utils.Resolver resolver;
        ApplicationData data = new ApplicationData();
        data.descriptor = nodeDesc;
        data.resolver = resolver = new Utils.Resolver(new Map[]{nodeDesc.variables, appDesc.variables});
        data.resolver.put("application", appDesc.name);
        data.resolver.put("node", this._id);
        this.putInfoVariables(data.resolver);
        this._map.put(appDesc.name, data);
        for (ServerInstanceDescriptor serverInstanceDescriptor : nodeDesc.serverInstances) {
            this.insertServer(this.createServer(appDesc, data.resolver, serverInstanceDescriptor));
        }
        for (ServerDescriptor serverDescriptor : nodeDesc.servers) {
            this.insertServer(this.createServer(appDesc, data.resolver, serverDescriptor));
        }
    }

    boolean remove(String appName) {
        this._map.remove(appName);
        if (this._map.isEmpty() && !this._up) {
            return true;
        }
        LinkedList<Server> toRemove = new LinkedList<Server>();
        int[] toRemoveIndices = new int[this._servers.size()];
        int i = 0;
        for (Server server : this._servers) {
            if (!server.getApplication().name.equals(appName)) continue;
            toRemove.add(server);
            toRemoveIndices[i++] = this.getIndex(server);
        }
        toRemoveIndices = this.resize(toRemoveIndices, toRemove.size());
        this._servers.removeAll(toRemove);
        this.getRoot().getTreeModel().nodesWereRemoved(this, toRemoveIndices, toRemove.toArray());
        return false;
    }

    void update(ApplicationDescriptor appDesc, NodeUpdateDescriptor update, boolean variablesChanged, Set<String> serviceTemplates, Set<String> serverTemplates) {
        ApplicationData data = (ApplicationData)this._map.get(appDesc.name);
        if (data == null) {
            if (update != null) {
                NodeDescriptor nodeDesc = new NodeDescriptor(update.variables, update.serverInstances, update.servers, update.loadFactor == null ? "" : update.loadFactor.value, update.description == null ? "" : update.description.value, update.propertySets);
                appDesc.nodes.put(this._id, nodeDesc);
                this.add(appDesc, nodeDesc);
            }
            return;
        }
        NodeDescriptor nodeDesc = data.descriptor;
        HashSet<Server> freshServers = new HashSet<Server>();
        if (update != null) {
            Server oldServer;
            if (update.description != null) {
                nodeDesc.description = update.description.value;
            }
            if (update.loadFactor != null) {
                nodeDesc.loadFactor = update.loadFactor.value;
            }
            nodeDesc.variables.keySet().removeAll(Arrays.asList(update.removeVariables));
            nodeDesc.variables.putAll(update.variables);
            if (!variablesChanged) {
                variablesChanged = update.removeVariables.length > 0 || !update.variables.isEmpty();
            }
            nodeDesc.propertySets.keySet().removeAll(Arrays.asList(update.removePropertySets));
            nodeDesc.propertySets.putAll(update.propertySets);
            for (String id : update.removeServers) {
                Server server = this.findServer(id);
                if (server == null) {
                    String errorMsg = "LiveDeployment/Node: unable to remove server '" + id + "'; please report this bug.";
                    this.getCoordinator().getCommunicator().getLogger().error(errorMsg);
                    continue;
                }
                server.removeCallbacks();
                this.removeDescriptor(nodeDesc, server);
                int index = this.getIndex(server);
                this._servers.remove(server);
                this.getRoot().getTreeModel().nodesWereRemoved(this, new int[]{index}, new Object[]{server});
            }
            for (ServerInstanceDescriptor desc : update.serverInstances) {
                Server server = this.createServer(appDesc, data.resolver, desc);
                oldServer = this.findServer(server.getId());
                if (oldServer == null) {
                    this.insertServer(server);
                    freshServers.add(server);
                    nodeDesc.serverInstances.add(desc);
                    continue;
                }
                this.removeDescriptor(nodeDesc, oldServer);
                oldServer.rebuild(server);
                oldServer.updateMetrics();
                freshServers.add(oldServer);
                nodeDesc.serverInstances.add(desc);
            }
            for (ServerDescriptor desc : update.servers) {
                Server server = this.createServer(appDesc, data.resolver, desc);
                oldServer = this.findServer(server.getId());
                if (oldServer == null) {
                    this.insertServer(server);
                    freshServers.add(server);
                    nodeDesc.servers.add(desc);
                    continue;
                }
                this.removeDescriptor(nodeDesc, oldServer);
                oldServer.rebuild(server);
                oldServer.updateMetrics();
                freshServers.add(oldServer);
                nodeDesc.servers.add(desc);
            }
        }
        if (variablesChanged || !serviceTemplates.isEmpty() || !serverTemplates.isEmpty()) {
            for (Server server : this._servers) {
                if (server.getApplication() != appDesc || freshServers.contains(server)) continue;
                server.rebuild(data.resolver, variablesChanged, serviceTemplates, serverTemplates);
            }
        }
    }

    NodeInfo getStaticInfo() {
        if (this._info == null) {
            return null;
        }
        return this._info.info;
    }

    boolean isRunningWindows() {
        return this._windows;
    }

    private boolean putInfoVariables(Utils.Resolver resolver) {
        if (this._info == null) {
            return false;
        }
        boolean updated = resolver.put("node.os", this._info.info.os);
        updated = resolver.put("node.hostname", this._info.info.hostname) || updated;
        updated = resolver.put("node.release", this._info.info.release) || updated;
        updated = resolver.put("node.version", this._info.info.version) || updated;
        updated = resolver.put("node.machine", this._info.info.machine) || updated;
        updated = resolver.put("node.datadir", this._info.info.dataDir) || updated;
        updated = resolver.put("node.data", this._info.info.dataDir) || updated;
        return updated;
    }

    void up(NodeDynamicInfo info, boolean fireEvent) {
        Server server;
        this._up = true;
        this._info = info;
        this._windows = info.info.os.toLowerCase().startsWith("windows");
        for (ApplicationData applicationData : this._map.values()) {
            if (!this.putInfoVariables(applicationData.resolver)) continue;
            String appName = applicationData.resolver.find("application");
            for (Server server2 : this._servers) {
                if (!server2.getApplication().name.equals(appName)) continue;
                server2.rebuild(applicationData.resolver, true, null, null);
            }
        }
        HashSet<Server> updatedServers = new HashSet<Server>();
        for (ServerDynamicInfo sinfo : this._info.servers) {
            server = this.findServer(sinfo.id);
            if (server == null) continue;
            server.update(sinfo.state, sinfo.pid, sinfo.enabled, true);
            updatedServers.add(server);
        }
        for (Server server3 : this._servers) {
            if (updatedServers.contains(server3)) continue;
            server3.update(ServerState.Inactive, 0, true, true);
        }
        Iterator iterator = this._servers.iterator();
        for (int updateCount = 0; iterator.hasNext() && updateCount < this._info.adapters.size(); updateCount += server.updateAdapters(this._info.adapters)) {
            server = (Server)iterator.next();
        }
        if (fireEvent) {
            this.getRoot().getTreeModel().nodeChanged(this);
        }
    }

    boolean down() {
        this._up = false;
        this._info.servers.clear();
        this._info.adapters.clear();
        if (this._showIceLogDialog != null) {
            this._showIceLogDialog.stopped();
        }
        if (this._servers.isEmpty()) {
            return true;
        }
        for (Server server : this._servers) {
            server.nodeDown();
        }
        this.getRoot().getTreeModel().nodeChanged(this);
        return false;
    }

    void updateServer(ServerDynamicInfo updatedInfo) {
        Server server;
        boolean destroyed;
        boolean bl = destroyed = updatedInfo.state == ServerState.Destroyed;
        if (this._info != null) {
            ListIterator<ServerDynamicInfo> p = this._info.servers.listIterator();
            boolean found = false;
            while (p.hasNext()) {
                ServerDynamicInfo sinfo = p.next();
                if (!sinfo.id.equals(updatedInfo.id)) continue;
                if (destroyed) {
                    p.remove();
                } else {
                    p.set(updatedInfo);
                }
                found = true;
                break;
            }
            if (!found && !destroyed) {
                this._info.servers.add(updatedInfo);
            }
        }
        if ((server = this.findServer(updatedInfo.id)) != null) {
            server.update(updatedInfo.state, updatedInfo.pid, updatedInfo.enabled, true);
        }
    }

    void updateAdapter(AdapterDynamicInfo updatedInfo) {
        Server server;
        if (this._info != null) {
            ListIterator<AdapterDynamicInfo> p = this._info.adapters.listIterator();
            boolean found = false;
            while (p.hasNext()) {
                AdapterDynamicInfo ainfo = p.next();
                if (!ainfo.id.equals(updatedInfo.id)) continue;
                p.set(updatedInfo);
                found = true;
                break;
            }
            if (!found) {
                this._info.adapters.add(updatedInfo);
            }
        }
        Iterator iterator = this._servers.iterator();
        while (iterator.hasNext() && !(server = (Server)iterator.next()).updateAdapter(updatedInfo)) {
        }
    }

    ObjectPrx getProxy(String adapterId) {
        if (this._info != null) {
            ListIterator<AdapterDynamicInfo> p = this._info.adapters.listIterator();
            while (p.hasNext()) {
                AdapterDynamicInfo ainfo = p.next();
                if (!ainfo.id.equals(adapterId)) continue;
                return ainfo.proxy;
            }
        }
        return null;
    }

    SortedMap<String, String> getLoadFactors() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, ApplicationData> p : this._map.entrySet()) {
            ApplicationData ad = p.getValue();
            String val = ad.resolver.substitute(ad.descriptor.loadFactor);
            if (val.length() == 0) {
                val = "Default";
            }
            result.put(p.getKey(), val);
        }
        return result;
    }

    void showLoad() {
        AdminPrx admin = this.getCoordinator().getAdmin();
        if (admin == null) {
            _editor.setLoad("Unknown", this);
        } else {
            _editor.setLoad("", this);
            String prefix = "Retrieving load for " + this.getDisplayName() + "...";
            this.getRoot().getCoordinator().getStatusBar().setText(prefix);
            try {
                admin.getNodeLoadAsync(this._id).whenComplete((result, ex) -> {
                    if (ex == null) {
                        NumberFormat format;
                        if (this._windows) {
                            format = NumberFormat.getPercentInstance();
                            format.setMaximumFractionDigits(1);
                            format.setMinimumFractionDigits(1);
                        } else {
                            format = NumberFormat.getNumberInstance();
                            format.setMaximumFractionDigits(2);
                            format.setMinimumFractionDigits(2);
                        }
                        String load = format.format(result.avg1) + " " + format.format(result.avg5) + " " + format.format(result.avg15);
                        SwingUtilities.invokeLater(() -> {
                            this.success(prefix);
                            _editor.setLoad(load, this);
                        });
                    } else {
                        this.amiFailure(prefix, "Failed to retrieve load for " + this.getDisplayName(), (Throwable)ex);
                    }
                });
            }
            catch (LocalException e) {
                this.getRoot().getCoordinator().getStatusBar().setText(prefix + " " + e.toString() + ".");
            }
        }
    }

    private Server createServer(ApplicationDescriptor application, Utils.Resolver resolver, ServerInstanceDescriptor instanceDescriptor) {
        TemplateDescriptor templateDescriptor = application.serverTemplates.get(instanceDescriptor.template);
        assert (templateDescriptor != null);
        ServerDescriptor serverDescriptor = (ServerDescriptor)templateDescriptor.descriptor;
        assert (serverDescriptor != null);
        Utils.Resolver instanceResolver = new Utils.Resolver(resolver, instanceDescriptor.parameterValues, templateDescriptor.parameterDefaults);
        String serverId = instanceResolver.substitute(serverDescriptor.id);
        instanceResolver.put("server", serverId);
        ServerState serverState = this._up ? ServerState.Inactive : null;
        int pid = 0;
        boolean enabled = true;
        if (this._info != null) {
            for (ServerDynamicInfo info : this._info.servers) {
                if (!info.id.equals(serverId)) continue;
                serverState = info.state;
                pid = info.pid;
                enabled = info.enabled;
                break;
            }
        }
        return new Server(this, serverId, instanceResolver, instanceDescriptor, serverDescriptor, application, serverState, pid, enabled);
    }

    private Server createServer(ApplicationDescriptor application, Utils.Resolver resolver, ServerDescriptor serverDescriptor) {
        Utils.Resolver instanceResolver = new Utils.Resolver(resolver);
        String serverId = instanceResolver.substitute(serverDescriptor.id);
        instanceResolver.put("server", serverId);
        ServerState serverState = this._up ? ServerState.Inactive : null;
        int pid = 0;
        boolean enabled = true;
        if (this._info != null) {
            for (ServerDynamicInfo info : this._info.servers) {
                if (!info.id.equals(serverId)) continue;
                serverState = info.state;
                pid = info.pid;
                enabled = info.enabled;
                break;
            }
        }
        return new Server(this, serverId, instanceResolver, null, serverDescriptor, application, serverState, pid, enabled);
    }

    private void insertServer(Server server) {
        this.insertSortedChild(server, this._servers, this.getRoot().getTreeModel());
    }

    private Server findServer(String id) {
        return (Server)this.find(id, this._servers);
    }

    private void removeDescriptor(NodeDescriptor nodeDesc, Server server) {
        ServerInstanceDescriptor instanceDescriptor = server.getInstanceDescriptor();
        if (instanceDescriptor != null) {
            this.removeDescriptor(nodeDesc, instanceDescriptor);
        } else {
            this.removeDescriptor(nodeDesc, server.getServerDescriptor());
        }
    }

    private void removeDescriptor(NodeDescriptor nodeDesc, ServerDescriptor sd) {
        Iterator<ServerDescriptor> p = nodeDesc.servers.iterator();
        while (p.hasNext()) {
            if (sd != p.next()) continue;
            p.remove();
            break;
        }
    }

    private void removeDescriptor(NodeDescriptor nodeDesc, ServerInstanceDescriptor sd) {
        Iterator<ServerInstanceDescriptor> p = nodeDesc.serverInstances.iterator();
        while (p.hasNext()) {
            if (sd != p.next()) continue;
            p.remove();
            break;
        }
    }

    static class ApplicationData {
        NodeDescriptor descriptor;
        Utils.Resolver resolver;

        ApplicationData() {
        }
    }
}

