/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffWriter {
    @NonNls
    private static final String INDEX_SIGNATURE = "Index: {0}{1}";
    @NonNls
    public static final String ADDITIONAL_PREFIX = "IDEA additional info:";
    @NonNls
    public static final String ADD_INFO_HEADER = "Subsystem: ";
    @NonNls
    public static final String ADD_INFO_LINE_START = "<+>";
    private static final String HEADER_SEPARATOR = "===================================================================";
    @NonNls
    public static final String NO_NEWLINE_SIGNATURE = "\\ No newline at end of file";

    private UnifiedDiffWriter() {
    }

    public static void write(@Nullable Project project, Collection<? extends FilePatch> patches, Writer writer, String lineSeparator, @Nullable CommitContext commitContext) throws IOException {
        UnifiedDiffWriter.write(project, patches, writer, lineSeparator, UnifiedDiffWriter.getPatchExtensions(project), commitContext);
    }

    @NotNull
    public static List<PatchEP> getPatchExtensions(@Nullable Project project) {
        List list = project == null ? Collections.emptyList() : PatchEP.EP_NAME.getExtensions((AreaInstance)project);
        if (list == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(0);
        }
        return list;
    }

    public static void write(@Nullable Project project, Collection<? extends FilePatch> patches, Writer writer, String lineSeparator, List<? extends PatchEP> extensions, CommitContext commitContext) throws IOException {
        UnifiedDiffWriter.write(project, project == null ? null : project.getBasePath(), patches, writer, lineSeparator, extensions, commitContext);
    }

    public static void write(@Nullable Project project, @Nullable String basePath, Collection<? extends FilePatch> patches, Writer writer, String lineSeparator, @NotNull List<? extends PatchEP> extensions, CommitContext commitContext) throws IOException {
        if (extensions == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(1);
        }
        for (FilePatch filePatch : patches) {
            if (!(filePatch instanceof TextFilePatch)) continue;
            TextFilePatch patch = (TextFilePatch)filePatch;
            String path2 = (String)ObjectUtils.assertNotNull((Object)(patch.getBeforeName() == null ? patch.getAfterName() : patch.getBeforeName()));
            String pathRelatedToProjectDir = project == null ? path2 : UnifiedDiffWriter.getPathRelatedToDir((String)ObjectUtils.assertNotNull((Object)project.getBasePath()), basePath, path2);
            HashMap<String, CharSequence> additionalMap = new HashMap<String, CharSequence>();
            for (PatchEP patchEP : extensions) {
                CharSequence charSequence = patchEP.provideContent(pathRelatedToProjectDir, commitContext);
                if (StringUtil.isEmpty((CharSequence)charSequence)) continue;
                additionalMap.put(patchEP.getName(), charSequence);
            }
            String fileContentLineSeparator = (String)ObjectUtils.coalesce((Object)patch.getLineSeparator(), (Object)lineSeparator, (Object)"\n");
            UnifiedDiffWriter.writeFileHeading(patch, writer, lineSeparator, additionalMap);
            for (PatchHunk hunk : patch.getHunks()) {
                UnifiedDiffWriter.writeHunkStart(writer, hunk.getStartLineBefore(), hunk.getEndLineBefore(), hunk.getStartLineAfter(), hunk.getEndLineAfter(), lineSeparator);
                for (PatchLine line : hunk.getLines()) {
                    char prefixChar = ' ';
                    switch (line.getType()) {
                        case ADD: {
                            prefixChar = '+';
                            break;
                        }
                        case REMOVE: {
                            prefixChar = '-';
                            break;
                        }
                        case CONTEXT: {
                            prefixChar = ' ';
                        }
                    }
                    String text = line.getText();
                    text = StringUtil.trimEnd((String)text, (String)"\n");
                    UnifiedDiffWriter.writeLine(writer, text, prefixChar);
                    if (line.isSuppressNewLine()) {
                        writer.write(lineSeparator + NO_NEWLINE_SIGNATURE + lineSeparator);
                        continue;
                    }
                    writer.write(fileContentLineSeparator);
                }
            }
        }
    }

    @NotNull
    private static String getPathRelatedToDir(@NotNull String newBaseDir, @Nullable String basePath, @NotNull String path2) {
        if (newBaseDir == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(3);
        }
        if (basePath == null) {
            String string = path2;
            if (string == null) {
                UnifiedDiffWriter.$$$reportNull$$$0(4);
            }
            return string;
        }
        String result = FileUtil.getRelativePath((File)new File(newBaseDir), (File)new File(basePath, path2));
        String string = result == null ? path2 : result;
        if (string == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void writeFileHeading(FilePatch patch, Writer writer, String lineSeparator, Map<String, CharSequence> additionalMap) throws IOException {
        writer.write(MessageFormat.format(INDEX_SIGNATURE, patch.getBeforeName(), lineSeparator));
        if (additionalMap != null && !additionalMap.isEmpty()) {
            writer.write(ADDITIONAL_PREFIX);
            writer.write(lineSeparator);
            for (Map.Entry<String, CharSequence> entry : additionalMap.entrySet()) {
                writer.write(ADD_INFO_HEADER + entry.getKey());
                writer.write(lineSeparator);
                String value = StringUtil.escapeStringCharacters((String)entry.getValue().toString());
                List lines = StringUtil.split((String)value, (String)"\n");
                for (String line : lines) {
                    writer.write(ADD_INFO_LINE_START);
                    writer.write(line);
                    writer.write(lineSeparator);
                }
            }
        }
        writer.write(HEADER_SEPARATOR + lineSeparator);
        UnifiedDiffWriter.writeRevisionHeading(writer, "---", patch.getBeforeName(), patch.getBeforeVersionId(), lineSeparator);
        UnifiedDiffWriter.writeRevisionHeading(writer, "+++", patch.getAfterName(), patch.getAfterVersionId(), lineSeparator);
    }

    private static void writeRevisionHeading(Writer writer, String prefix, String revisionPath, String revisionName, String lineSeparator) throws IOException {
        writer.write(prefix + " ");
        writer.write(revisionPath);
        writer.write("\t");
        if (!StringUtil.isEmptyOrSpaces((String)revisionName)) {
            writer.write(revisionName);
        }
        writer.write(lineSeparator);
    }

    private static void writeHunkStart(Writer writer, int startLine1, int endLine1, int startLine2, int endLine2, String lineSeparator) throws IOException {
        StringBuilder builder = new StringBuilder("@@ -");
        builder.append(startLine1 + 1).append(",").append(endLine1 - startLine1);
        builder.append(" +").append(startLine2 + 1).append(",").append(endLine2 - startLine2).append(" @@").append(lineSeparator);
        writer.append(builder.toString());
    }

    private static void writeLine(Writer writer, String line, char prefix) throws IOException {
        writer.write(prefix);
        writer.write(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/UnifiedDiffWriter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBaseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchExtensions";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/UnifiedDiffWriter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathRelatedToDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelatedToDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

