/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.java2d.SunGraphicsEnvironment;

public final class JreHiDpiUtil {
    private static final AtomicReference<Boolean> jreHiDPI = new AtomicReference();
    private static volatile boolean jreHiDPI_earlierVersion;

    public static boolean isJreHiDPI(@Nullable GraphicsConfiguration gc) {
        return JreHiDpiUtil.isJreHiDPIEnabled() && JBUIScale.isHiDPI(JBUIScale.sysScale(gc));
    }

    public static boolean isJreHiDPI(@Nullable Graphics2D g) {
        return JreHiDpiUtil.isJreHiDPIEnabled() && JBUIScale.isHiDPI(JBUIScale.sysScale(g));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJreHiDPIEnabled() {
        if (jreHiDPI.get() != null) {
            return jreHiDPI.get();
        }
        AtomicReference<Boolean> atomicReference = jreHiDPI;
        synchronized (atomicReference) {
            if (jreHiDPI.get() != null) {
                return jreHiDPI.get();
            }
            jreHiDPI.set(false);
            if (!SystemProperties.getBooleanProperty((String)"hidpi", (boolean)true)) {
                return false;
            }
            jreHiDPI_earlierVersion = true;
            if (SystemInfo.isJetBrainsJvm) {
                try {
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    if (ge instanceof SunGraphicsEnvironment) {
                        Method m = ReflectionUtil.getDeclaredMethod(SunGraphicsEnvironment.class, (String)"isUIScaleEnabled", (Class[])new Class[0]);
                        jreHiDPI.set(m != null && (Boolean)m.invoke((Object)ge, new Object[0]) != false);
                        jreHiDPI_earlierVersion = false;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (SystemInfo.isMac) {
                jreHiDPI.set(true);
            }
            return jreHiDPI.get();
        }
    }

    @ApiStatus.Internal
    public static boolean isJreHiDPI_earlierVersion() {
        JreHiDpiUtil.isJreHiDPIEnabled();
        return jreHiDPI_earlierVersion;
    }

    @NotNull
    public static AtomicReference<Boolean> test_jreHiDPI() {
        if (jreHiDPI.get() == null) {
            JreHiDpiUtil.isJreHiDPIEnabled();
        }
        AtomicReference<Boolean> atomicReference = jreHiDPI;
        if (atomicReference == null) {
            JreHiDpiUtil.$$$reportNull$$$0(0);
        }
        return atomicReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/JreHiDpiUtil", "test_jreHiDPI"));
    }
}

