/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleLogColumnsActionGroup
extends ActionGroup
implements DumbAware {
    public ToggleLogColumnsActionGroup() {
        super("Show Columns", true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(0);
        }
        super.update(e);
        e.getPresentation().setEnabledAndVisible(ToggleLogColumnsActionGroup.isEnabledAndVisible(e));
        e.getPresentation().setIcon(e.isFromActionToolbar() ? AllIcons.Actions.Show : null);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        ArrayList<ToggleColumnAction> actions = new ArrayList<ToggleColumnAction>();
        for (int column : GraphTableModel.DYNAMIC_COLUMNS) {
            actions.add(new ToggleColumnAction(column));
        }
        AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    private static boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
        VcsLogUiProperties properties;
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(2);
        }
        return (properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) != null && properties.exists(CommonUiProperties.COLUMN_ORDER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledAndVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ToggleColumnAction
    extends ToggleAction
    implements DumbAware {
        private final int myIndex;

        private ToggleColumnAction(int index) {
            super(GraphTableModel.COLUMN_NAMES[index]);
            this.myIndex = index;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            VcsLogUiProperties properties;
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(0);
            }
            if ((properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) != null && properties.exists(CommonUiProperties.COLUMN_ORDER)) {
                List<Integer> columnOrder = properties.get(CommonUiProperties.COLUMN_ORDER);
                return columnOrder.contains(this.myIndex);
            }
            return false;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(1);
            }
            VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            assert (properties.exists(CommonUiProperties.COLUMN_ORDER));
            ArrayList<Integer> columnOrder = new ArrayList<Integer>((Collection)properties.get(CommonUiProperties.COLUMN_ORDER));
            if (columnOrder.contains(this.myIndex)) {
                columnOrder.remove((Object)this.myIndex);
            } else {
                columnOrder.add(this.myIndex);
            }
            properties.set(CommonUiProperties.COLUMN_ORDER, columnOrder);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(ToggleLogColumnsActionGroup.isEnabledAndVisible(e));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup$ToggleColumnAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

