/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.ignore.actions.CreateNewIgnoreFileAction;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileAction;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010#\u001a\u0004\u0018\u00010\u001a*\u00020\u0017H\u0002J \u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0019*\b\u0012\u0004\u0012\u00020\u001a0\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010&\u001a\u00020'*\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0002R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "ignoreFileType", "Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;", "(Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;)V", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getActions", "()Ljava/util/Collection;", "setActions", "(Ljava/util/Collection;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canBePerformed", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "createNewIgnoreFileAction", "project", "Lcom/intellij/openapi/project/Project;", "selectedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filterSelectedFiles", "files", "findSuitableIgnoreFiles", "file", "getChildren", "", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "update", "getProjectRoot", "toActions", "Lcom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileAction;", "toTextRepresentation", "", "size", "", "intellij.platform.vcs.impl"})
public class IgnoreFileActionGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    private Collection<? extends AnAction> actions;
    private final IgnoreFileType ignoreFileType;

    @NotNull
    public final Collection<AnAction> getActions() {
        return this.actions;
    }

    public final void setActions(@NotNull Collection<? extends AnAction> collection) {
        Intrinsics.checkParameterIsNotNull(collection, (String)"<set-?>");
        this.actions = collection;
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Stream stream = (Stream)e.getData(ChangesListView.EXACTLY_SELECTED_FILES_DATA_KEY);
        List exactlySelectedFiles = stream != null ? StreamsKt.toList((Stream)stream) : null;
        List list = exactlySelectedFiles;
        if (list == null) {
            Object[] objectArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            list = objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        }
        List selectedFiles = list;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        Presentation presentation2 = presentation;
        if (project == null || selectedFiles == null || UtilKt.isEmpty(ScheduleForAdditionAction.getUnversionedFiles(e, project))) {
            presentation2.setVisible(false);
            return;
        }
        Iterable $this$map$iv = this.filterSelectedFiles(project, selectedFiles);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Collection<VirtualFile> collection2 = this.findSuitableIgnoreFiles(project, (VirtualFile)it);
            collection.add(collection2);
        }
        List ignoreFiles = (List)destination$iv$iv;
        HashSet resultedIgnoreFiles = CollectionsKt.toHashSet((Iterable)CollectionsKt.flatten((Iterable)ignoreFiles));
        for (Collection files2 : ignoreFiles) {
            resultedIgnoreFiles.retainAll(files2);
        }
        Collection<? extends AnAction> collection3 = resultedIgnoreFiles;
        boolean bl = false;
        this.actions = !collection3.isEmpty() ? (Collection)this.toActions(resultedIgnoreFiles, project) : (Collection)CollectionsKt.listOfNotNull((Object)this.createNewIgnoreFileAction(project, selectedFiles));
        this.setPopup(this.actions.size() > 1);
        collection3 = this.actions;
        collection = presentation2;
        bl = false;
        boolean bl2 = !collection3.isEmpty();
        collection.setVisible(bl2);
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.actions.size() == 1;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            AnAction anAction = (AnAction)CollectionsKt.firstOrNull((Iterable)this.actions);
            if (anAction == null) break block0;
            anAction.actionPerformed(e);
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Collection<? extends AnAction> $this$toTypedArray$iv = this.actions;
        boolean $i$f$toTypedArray = false;
        Collection<? extends AnAction> collection = $this$toTypedArray$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection<? extends AnAction> thisCollection$iv = collection;
        AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
        if (anActionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return anActionArray;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> filterSelectedFiles(Project project, List<? extends VirtualFile> files2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile file = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(VcsUtil.isFileUnderVcs((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file)) && !ChangeListManager.getInstance((Project)project).isIgnoredFile(file))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VirtualFile> findSuitableIgnoreFiles(Project project, VirtualFile file) {
        void $this$filterTo$iv$iv;
        VirtualFile fileParent = file.getParent();
        Collection collection = FileTypeIndex.getFiles((FileType)((FileType)this.ignoreFileType), (GlobalSearchScope)ProjectScope.getProjectScope((Project)project));
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FileTypeIndex.getFiles(i\u2026getProjectScope(project))");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
            if (!(Intrinsics.areEqual((Object)fileParent, (Object)virtualFile.getParent()) || fileParent != null && it.getParent() != null && VfsUtil.isAncestor((VirtualFile)it.getParent(), (VirtualFile)fileParent, (boolean)false))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IgnoreFileAction> toActions(@NotNull Collection<? extends VirtualFile> $this$toActions, Project project) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toActions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IgnoreFileAction ignoreFileAction = new IgnoreFileAction((VirtualFile)file);
            boolean bl2 = false;
            boolean bl3 = false;
            IgnoreFileAction $this$apply = ignoreFileAction;
            boolean bl4 = false;
            Presentation presentation = $this$apply.getTemplatePresentation();
            boolean bl5 = false;
            boolean bl6 = false;
            Presentation $this$apply2 = presentation;
            boolean bl7 = false;
            $this$apply2.setIcon(this.ignoreFileType.getIcon());
            $this$apply2.setText(this.toTextRepresentation((VirtualFile)file, project, $this$toActions.size()));
            IgnoreFileAction ignoreFileAction2 = ignoreFileAction;
            collection.add(ignoreFileAction2);
        }
        return (List)destination$iv$iv;
    }

    private final AnAction createNewIgnoreFileAction(Project project, List<? extends VirtualFile> selectedFiles) {
        boolean bl;
        VirtualFile projectRoot;
        String filename;
        block8: {
            IgnoreLanguage ignoreLanguage = this.ignoreFileType.getIgnoreLanguage();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ignoreLanguage), (String)"ignoreFileType.ignoreLanguage");
            String string = ignoreLanguage.getFilename();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ignoreFileType.ignoreLanguage.filename");
            filename = string;
            projectRoot = this.getProjectRoot(project);
            if (projectRoot == null || projectRoot.findChild(filename) != null) {
                return null;
            }
            Iterable $this$any$iv = selectedFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!(!VfsUtil.isAncestor((VirtualFile)projectRoot, (VirtualFile)it, (boolean)true))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)projectRoot);
        if (abstractVcs == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"VcsUtil.getVcsFor(projec\u2026ojectRoot) ?: return null");
        AbstractVcs rootVcs = abstractVcs;
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider(project, rootVcs);
        if (ignoredFileContentProvider == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ignoredFileContentProvider, (String)"VcsImplUtil.findIgnoredF\u2026, rootVcs) ?: return null");
        IgnoredFileContentProvider ignoredFileContentProvider2 = ignoredFileContentProvider;
        if (Intrinsics.areEqual((Object)ignoredFileContentProvider2.getFileName(), (Object)filename) ^ true) {
            return null;
        }
        Object object = new CreateNewIgnoreFileAction(filename, projectRoot);
        boolean bl3 = false;
        boolean bl4 = false;
        Object $this$apply = object;
        boolean bl5 = false;
        Presentation presentation = $this$apply.getTemplatePresentation();
        boolean bl6 = false;
        boolean bl7 = false;
        Presentation $this$apply2 = presentation;
        boolean bl8 = false;
        $this$apply2.setIcon(this.ignoreFileType.getIcon());
        $this$apply2.setText(VcsBundle.message((String)"vcs.add.to.ignore.file.action.group.text", (Object[])new Object[]{filename}));
        return (AnAction)object;
    }

    private final String toTextRepresentation(@NotNull VirtualFile $this$toTextRepresentation, Project project, int size) {
        if (size == 1) {
            Object[] objectArray = new Object[1];
            IgnoreLanguage ignoreLanguage = this.ignoreFileType.getIgnoreLanguage();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ignoreLanguage), (String)"ignoreFileType.ignoreLanguage");
            objectArray[0] = ignoreLanguage.getFilename();
            String string = VcsBundle.message((String)"vcs.add.to.ignore.file.action.group.text", (Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message(\"vcs.add.to.igno\u2026.ignoreLanguage.filename)");
            return string;
        }
        VirtualFile virtualFile = this.getProjectRoot(project);
        if (virtualFile == null) {
            String string = $this$toTextRepresentation.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            return string;
        }
        VirtualFile projectRoot = virtualFile;
        String string = VfsUtil.getRelativePath((VirtualFile)$this$toTextRepresentation, (VirtualFile)projectRoot);
        if (string == null) {
            String string2 = $this$toTextRepresentation.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VirtualFile getProjectRoot(@NotNull Project $this$getProjectRoot) {
        VirtualFile virtualFile;
        if (ProjectKt.isDirectoryBased((Project)$this$getProjectRoot)) {
            String string2 = ProjectKt.getStateStore((Project)$this$getProjectRoot).getProjectConfigDir();
            string2 = string2;
            if (string == null) return null;
            String string3 = string2;
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            boolean bl = false;
            boolean bl2 = false;
            String p1 = string3;
            boolean bl3 = false;
            VirtualFile virtualFile2 = localFileSystem.findFileByPath(p1);
            string2 = virtualFile2;
            if (virtualFile2 == null) return null;
            virtualFile = string2.getParent();
            return virtualFile;
        } else {
            VirtualFile virtualFile3 = $this$getProjectRoot.getProjectFile();
            if (virtualFile3 == null) return null;
            virtualFile = virtualFile3.getParent();
        }
        return virtualFile;
    }

    public IgnoreFileActionGroup(@NotNull IgnoreFileType ignoreFileType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)ignoreFileType), (String)"ignoreFileType");
        Object[] objectArray = new Object[1];
        IgnoreLanguage ignoreLanguage = ignoreFileType.getIgnoreLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ignoreLanguage), (String)"ignoreFileType.ignoreLanguage");
        objectArray[0] = ignoreLanguage.getFilename();
        String string = VcsBundle.message((String)"vcs.add.to.ignore.file.action.group.text", (Object[])objectArray);
        Object[] objectArray2 = new Object[1];
        IgnoreLanguage ignoreLanguage2 = ignoreFileType.getIgnoreLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ignoreLanguage2), (String)"ignoreFileType.ignoreLanguage");
        objectArray2[0] = ignoreLanguage2.getFilename();
        super(string, VcsBundle.message((String)"vcs.add.to.ignore.file.action.group.description", (Object[])objectArray2), ignoreFileType.getIcon());
        this.ignoreFileType = ignoreFileType;
        this.actions = CollectionsKt.emptyList();
    }
}

