/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

public class AsyncHighlighterUpdater {
    private static final Map<Editor, CancellablePromise<?>> ourHighlighterFutures = ContainerUtil.newConcurrentMap();

    public static void updateHighlighters(@NotNull Project project, @NotNull Editor editor, @NotNull VirtualFile file2) {
        CancellablePromise promise;
        CancellablePromise prev;
        if (project == null) {
            AsyncHighlighterUpdater.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AsyncHighlighterUpdater.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            AsyncHighlighterUpdater.$$$reportNull$$$0(2);
        }
        if ((prev = ourHighlighterFutures.put(editor, promise = ReadAction.nonBlocking(() -> AsyncHighlighterUpdater.updateHighlighter(project, editor, file2)).expireWith((Disposable)project).expireWhen(() -> !file2.isValid() || editor.isDisposed()).finishOnUiThread(ModalityState.any(), highlighter -> ((EditorEx)editor).setHighlighter((EditorHighlighter)highlighter)).submit((Executor)NonUrgentExecutor.getInstance()))) != null) {
            prev.cancel();
        }
        promise.onProcessed(__ -> ourHighlighterFutures.remove(editor, promise));
    }

    @NotNull
    private static EditorHighlighter updateHighlighter(@NotNull Project project, @NotNull Editor editor, @NotNull VirtualFile file2) {
        if (project == null) {
            AsyncHighlighterUpdater.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            AsyncHighlighterUpdater.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            AsyncHighlighterUpdater.$$$reportNull$$$0(5);
        }
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file2);
        highlighter.setText(editor.getDocument().getImmutableCharSequence());
        EditorHighlighter editorHighlighter = highlighter;
        if (editorHighlighter == null) {
            AsyncHighlighterUpdater.$$$reportNull$$$0(6);
        }
        return editorHighlighter;
    }

    public static void completeAsyncTasks() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/AsyncHighlighterUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/AsyncHighlighterUpdater";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "updateHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlighters";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlighter";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

