/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.annotations.NotNull;

public class EditorMouseHoverPopupControl {
    private static final Logger LOG = Logger.getInstance(EditorMouseHoverPopupControl.class);
    private static final Key<Integer> MOUSE_TRACKING_DISABLED_COUNT = Key.create((String)"MOUSE_TRACKING_DISABLED_COUNT");

    public static void disablePopups(@NotNull Editor editor) {
        if (editor == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(0);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)editor, true);
    }

    public static void enablePopups(@NotNull Editor editor) {
        if (editor == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(1);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)editor, false);
    }

    public static void disablePopups(@NotNull Document document) {
        if (document == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(2);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)document, true);
    }

    public static void enablePopups(@NotNull Document document) {
        if (document == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(3);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)document, false);
    }

    private static void setTrackingDisabled(@NotNull UserDataHolder holder, boolean value) {
        if (holder == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Integer userData = (Integer)holder.getUserData(MOUSE_TRACKING_DISABLED_COUNT);
        int count = (userData == null ? 0 : userData) + (value ? 1 : -1);
        if (count < 0) {
            LOG.warn((Throwable)new IllegalStateException("Editor mouse hover popups weren't disabled previously"));
            count = 0;
        }
        holder.putUserData(MOUSE_TRACKING_DISABLED_COUNT, (Object)(count == 0 ? null : Integer.valueOf(count)));
    }

    public static boolean arePopupsDisabled(@NotNull Editor editor) {
        if (editor == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return editor.getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null || editor.getDocument().getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null || editor.getComponent().getClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMouseHoverPopupControl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "disablePopups";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "enablePopups";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setTrackingDisabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "arePopupsDisabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

