/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.TrafficTooltipRenderer;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntIntHashMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorMarkupModelImpl
extends MarkupModelImpl
implements EditorMarkupModel {
    private static final TooltipGroup ERROR_STRIPE_TOOLTIP_GROUP = new TooltipGroup("ERROR_STRIPE_TOOLTIP_GROUP", 0);
    private static final int EDITOR_FRAGMENT_POPUP_BORDER = 1;
    @NotNull
    private final EditorImpl myEditor;
    @Nullable
    private ErrorStripeRenderer myErrorStripeRenderer;
    private final List<ErrorStripeListener> myErrorMarkerListeners;
    private boolean dimensionsAreValid;
    private int myEditorScrollbarTop;
    private int myEditorTargetHeight;
    private int myEditorSourceHeight;
    @Nullable
    private ProperTextRange myDirtyYPositions;
    private static final ProperTextRange WHOLE_DOCUMENT = new ProperTextRange(0, 0);
    @NotNull
    private ErrorStripTooltipRendererProvider myTooltipRendererProvider;
    private int myMinMarkHeight;
    private static final int myPreviewLines = Math.max(2, Math.min(25, Integer.getInteger("preview.lines", 5)));
    private static final int myCachePreviewLines = 100;
    @Nullable
    private LightweightHint myEditorPreviewHint;
    @NotNull
    private final EditorFragmentRenderer myEditorFragmentRenderer;
    private int myRowAdjuster;
    private int myWheelAccumulator;
    private int myLastVisualLine;

    private int getMinMarkHeight() {
        return JBUIScale.scale((int)this.myMinMarkHeight);
    }

    private static int getErrorIconWidth() {
        return JBUIScale.scale((int)14);
    }

    private static int getErrorIconHeight() {
        return JBUIScale.scale((int)14);
    }

    private static int getThinGap() {
        return JBUIScale.scale((int)2);
    }

    private static int getMaxStripeSize() {
        return JBUIScale.scale((int)4);
    }

    private static int getMaxMacThumbWidth() {
        return JBUIScale.scale((int)10);
    }

    EditorMarkupModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(0);
        }
        super(editor.getDocument());
        this.myErrorMarkerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myEditorScrollbarTop = -1;
        this.myEditorTargetHeight = -1;
        this.myEditorSourceHeight = -1;
        this.myTooltipRendererProvider = new BasicTooltipRendererProvider();
        this.myEditor = editor;
        this.myEditorFragmentRenderer = new EditorFragmentRenderer();
        this.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().getErrorStripeMarkMinHeight());
    }

    private int offsetToLine(int offset, @NotNull Document document) {
        if (document == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(1);
        }
        if (offset < 0) {
            return 0;
        }
        if (offset > document.getTextLength()) {
            return this.myEditor.getVisibleLineCount();
        }
        return this.myEditor.offsetToVisualLine(offset);
    }

    public void repaintVerticalScrollBar() {
        this.myEditor.getVerticalScrollBar().repaint();
    }

    void recalcEditorDimensions() {
        EditorImpl.MyScrollBar scrollBar = this.myEditor.getVerticalScrollBar();
        int scrollBarHeight = Math.max(0, scrollBar.getSize().height);
        this.myEditorScrollbarTop = scrollBar.getDecScrollButtonHeight();
        assert (this.myEditorScrollbarTop >= 0);
        int editorScrollbarBottom = scrollBar.getIncScrollButtonHeight();
        this.myEditorTargetHeight = scrollBarHeight - this.myEditorScrollbarTop - editorScrollbarBottom;
        this.myEditorSourceHeight = this.myEditor.getPreferredHeight();
        this.dimensionsAreValid = scrollBarHeight != 0;
    }

    public void setTrafficLightIconVisible(boolean value) {
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null && errorPanel.myErrorStripeButton.isVisible() != value) {
            errorPanel.myErrorStripeButton.setVisible(value);
            this.repaint(-1, -1);
        }
    }

    public void repaintTrafficLightIcon() {
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null) {
            errorPanel.myErrorStripeButton.repaint();
            errorPanel.repaintTrafficTooltip();
        }
    }

    private boolean showToolTipByMouseMove(@NotNull MouseEvent e) {
        boolean isVisible;
        int visualLine;
        if (e == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(2);
        }
        if (this.myEditor.getVisibleLineCount() == 0) {
            return false;
        }
        MouseEvent me = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), 0, e.getY() + 1, e.getClickCount(), e.isPopupTrigger());
        this.myLastVisualLine = visualLine = this.getVisualLineByEvent(e);
        Rectangle area = this.myEditor.getScrollingModel().getVisibleArea();
        int visualY = this.myEditor.visualLineToY(visualLine);
        boolean bl = isVisible = this.myWheelAccumulator == 0 && area.contains(area.x, visualY);
        if (UIUtil.uiParents((Component)this.myEditor.getComponent(), (boolean)false).filter(EditorWindowHolder.class).isEmpty() || isVisible || !UISettings.getInstance().getShowEditorToolTip()) {
            THashSet highlighters = new THashSet();
            this.getNearestHighlighters(this, me.getY(), (Collection<? super RangeHighlighter>)highlighters);
            this.getNearestHighlighters(((EditorEx)this.getEditor()).getFilteredDocumentMarkupModel(), me.getY(), (Collection<? super RangeHighlighter>)highlighters);
            if (highlighters.isEmpty()) {
                return false;
            }
            int y = e.getY();
            RangeHighlighter nearest = this.getNearestRangeHighlighter(e);
            if (nearest != null) {
                ProperTextRange range2 = this.offsetsToYPositions(nearest.getStartOffset(), nearest.getEndOffset());
                int eachStartY = range2.getStartOffset();
                int eachEndY = range2.getEndOffset();
                y = eachStartY + (eachEndY - eachStartY) / 2;
            }
            me = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), me.getX(), y + 1, e.getClickCount(), e.isPopupTrigger());
            TooltipRenderer bigRenderer = this.myTooltipRendererProvider.calcTooltipRenderer((Collection<? extends RangeHighlighter>)highlighters);
            if (bigRenderer != null) {
                this.showTooltip(me, bigRenderer, EditorMarkupModelImpl.createHint(me));
                return true;
            }
            return false;
        }
        float rowRatio = (float)visualLine / (float)(this.myEditor.getVisibleLineCount() - 1);
        int y = this.myRowAdjuster != 0 ? (int)(rowRatio * (float)this.myEditor.getVerticalScrollBar().getHeight()) : me.getY();
        me = new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX(), y, me.getClickCount(), me.isPopupTrigger());
        ArrayList highlighters = new ArrayList();
        this.collectRangeHighlighters(this, visualLine, highlighters);
        this.collectRangeHighlighters(this.myEditor.getFilteredDocumentMarkupModel(), visualLine, highlighters);
        this.myEditorFragmentRenderer.update(visualLine, highlighters, me.isAltDown());
        this.myEditorFragmentRenderer.show(this.myEditor, me.getPoint(), true, ERROR_STRIPE_TOOLTIP_GROUP, EditorMarkupModelImpl.createHint(me));
        return true;
    }

    private static HintHint createHint(MouseEvent me) {
        return new HintHint(me).setAwtTooltip(true).setPreferredPosition(Balloon.Position.atLeft).setBorderInsets((Insets)JBUI.insets((int)1)).setShowImmediately(true).setAnimationEnabled(false);
    }

    private int getVisualLineByEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(3);
        }
        int y = e.getY();
        if (e.getSource() == this.myEditor.getVerticalScrollBar() && y == this.myEditor.getVerticalScrollBar().getHeight() - 1) {
            ++y;
        }
        return this.fitLineToEditor(this.myEditor.offsetToVisualLine(this.yPositionToOffset(y + this.myWheelAccumulator, true)));
    }

    private int fitLineToEditor(int visualLine) {
        int lineCount = this.myEditor.getVisibleLineCount();
        int shift = 0;
        if (visualLine >= lineCount - 1) {
            CharSequence sequence = this.myEditor.getDocument().getCharsSequence();
            shift = sequence.charAt(sequence.length() - 1) == '\n' ? 1 : 0;
        }
        return Math.max(0, Math.min(lineCount - shift, visualLine));
    }

    private int getOffset(int visualLine, boolean startLine) {
        LogicalPosition pos = this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, startLine ? 0 : Integer.MAX_VALUE));
        return this.myEditor.logicalPositionToOffset(pos);
    }

    private void collectRangeHighlighters(@NotNull MarkupModelEx markupModel, int visualLine, @NotNull Collection<? super RangeHighlighterEx> highlighters) {
        if (markupModel == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(4);
        }
        if (highlighters == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(5);
        }
        int startOffset = this.getOffset(this.fitLineToEditor(visualLine - myPreviewLines), true);
        int endOffset = this.getOffset(this.fitLineToEditor(visualLine + myPreviewLines), false);
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            if (highlighter.getErrorStripeMarkColor() != null && highlighter.getStartOffset() < endOffset && highlighter.getEndOffset() > startOffset) {
                highlighters.add((RangeHighlighterEx)highlighter);
            }
            return true;
        }));
    }

    @Nullable
    private RangeHighlighter getNearestRangeHighlighter(@NotNull MouseEvent e) {
        if (e == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(6);
        }
        ArrayList highlighters = new ArrayList();
        this.getNearestHighlighters(this, e.getY(), highlighters);
        this.getNearestHighlighters(this.myEditor.getFilteredDocumentMarkupModel(), e.getY(), highlighters);
        RangeHighlighter nearestMarker = null;
        int yPos = 0;
        for (RangeHighlighter highlighter : highlighters) {
            int newYPos = this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset()).getStartOffset();
            if (nearestMarker != null && Math.abs(yPos - e.getY()) <= Math.abs(newYPos - e.getY())) continue;
            nearestMarker = highlighter;
            yPos = newYPos;
        }
        return nearestMarker;
    }

    private void getNearestHighlighters(@NotNull MarkupModelEx markupModel, int scrollBarY, @NotNull Collection<? super RangeHighlighter> nearest) {
        if (markupModel == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(7);
        }
        if (nearest == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(8);
        }
        int startOffset = this.yPositionToOffset(scrollBarY - this.getMinMarkHeight(), true);
        int endOffset = this.yPositionToOffset(scrollBarY + this.getMinMarkHeight(), false);
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            ProperTextRange range2;
            if (highlighter.getErrorStripeMarkColor() != null && scrollBarY >= (range2 = this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset())).getStartOffset() - this.getMinMarkHeight() * 2 && scrollBarY <= range2.getEndOffset() + this.getMinMarkHeight() * 2) {
                nearest.add((RangeHighlighter)highlighter);
            }
            return true;
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doClick(@NotNull MouseEvent e) {
        int offset;
        if (e == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(9);
        }
        RangeHighlighter marker = this.getNearestRangeHighlighter(e);
        LogicalPosition logicalPositionToScroll = null;
        if (marker == null) {
            if (this.myEditorPreviewHint == null) return;
            logicalPositionToScroll = this.myEditor.visualToLogicalPosition(new VisualPosition(this.myEditorFragmentRenderer.myStartVisualLine, 0));
            offset = this.myEditor.getDocument().getLineStartOffset(logicalPositionToScroll.line);
        } else {
            offset = marker.getStartOffset();
        }
        DocumentEx doc = this.myEditor.getDocument();
        if (doc.getLineCount() > 0 && this.myEditorPreviewHint == null) {
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            this.myEditor.getCaretModel().moveToOffset(lineEnd);
        }
        this.myEditor.getCaretModel().removeSecondaryCarets();
        this.myEditor.getCaretModel().moveToOffset(offset);
        this.myEditor.getSelectionModel().removeSelection();
        ScrollingModelEx scrollingModel = this.myEditor.getScrollingModel();
        scrollingModel.disableAnimation();
        if (logicalPositionToScroll != null) {
            int lineY = this.myEditor.logicalPositionToXY((LogicalPosition)logicalPositionToScroll).y;
            int relativePopupOffset = this.myEditorFragmentRenderer.myRelativeY;
            scrollingModel.scrollVertically(lineY - relativePopupOffset);
        } else {
            scrollingModel.scrollToCaret(ScrollType.CENTER);
        }
        scrollingModel.enableAnimation();
        if (marker == null) return;
        this.fireErrorMarkerClicked(marker, e);
    }

    @Override
    public void setErrorStripeVisible(boolean val) {
        if (val) {
            this.disposeErrorPanel();
            MyErrorPanel panel2 = new MyErrorPanel();
            this.myEditor.getVerticalScrollBar().setPersistentUI((ScrollBarUI)((Object)panel2));
        } else {
            this.myEditor.getVerticalScrollBar().setPersistentUI(JBScrollBar.createUI(null));
        }
    }

    @Nullable
    private MyErrorPanel getErrorPanel() {
        ScrollBarUI ui = this.myEditor.getVerticalScrollBar().getUI();
        return ui instanceof MyErrorPanel ? (MyErrorPanel)((Object)ui) : null;
    }

    @Override
    public void setErrorPanelPopupHandler(@NotNull PopupHandler handler2) {
        if (handler2 == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null) {
            errorPanel.setPopupHandler(handler2);
        }
    }

    @Override
    public void setErrorStripTooltipRendererProvider(@NotNull ErrorStripTooltipRendererProvider provider) {
        if (provider == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(11);
        }
        this.myTooltipRendererProvider = provider;
    }

    @Override
    @NotNull
    public ErrorStripTooltipRendererProvider getErrorStripTooltipRendererProvider() {
        ErrorStripTooltipRendererProvider errorStripTooltipRendererProvider = this.myTooltipRendererProvider;
        if (errorStripTooltipRendererProvider == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(12);
        }
        return errorStripTooltipRendererProvider;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(13);
        }
        return editorImpl;
    }

    @Override
    public void setErrorStripeRenderer(@Nullable ErrorStripeRenderer renderer2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myErrorStripeRenderer instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myErrorStripeRenderer));
        }
        this.myErrorStripeRenderer = renderer2;
        this.myEditor.getVerticalScrollBar().updateUI();
        this.repaintVerticalScrollBar();
    }

    @Override
    @Nullable
    public ErrorStripeRenderer getErrorStripeRenderer() {
        return this.myErrorStripeRenderer;
    }

    @Override
    public void dispose() {
        this.disposeErrorPanel();
        if (this.myErrorStripeRenderer instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myErrorStripeRenderer));
        }
        this.myErrorStripeRenderer = null;
        this.myTooltipRendererProvider = new BasicTooltipRendererProvider();
        this.myEditorPreviewHint = null;
        super.dispose();
    }

    private void disposeErrorPanel() {
        MyErrorPanel panel2 = this.getErrorPanel();
        if (panel2 != null) {
            panel2.uninstallListeners();
        }
    }

    void repaint(int startOffset, int endOffset) {
        ProperTextRange range2 = this.offsetsToYPositions(startOffset, endOffset);
        this.markDirtied(range2);
        if (startOffset == -1 || endOffset == -1) {
            this.myDirtyYPositions = WHOLE_DOCUMENT;
        }
        EditorImpl.MyScrollBar bar = this.myEditor.getVerticalScrollBar();
        ((Component)((Object)bar)).repaint(0, range2.getStartOffset(), ((JComponent)((Object)bar)).getWidth(), range2.getLength() + this.getMinMarkHeight());
    }

    private boolean isMirrored() {
        return this.myEditor.isMirrored();
    }

    private boolean transparent() {
        return !this.myEditor.shouldScrollBarBeOpaque();
    }

    private void showTooltip(@NotNull MouseEvent e, TooltipRenderer tooltipObject, @NotNull HintHint hintHint) {
        if (e == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(14);
        }
        if (hintHint == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(15);
        }
        TooltipController tooltipController = TooltipController.getInstance();
        tooltipController.showTooltipByMouseMove(this.myEditor, new RelativePoint(e), tooltipObject, this.myEditor.getVerticalScrollbarOrientation() == 1, ERROR_STRIPE_TOOLTIP_GROUP, hintHint);
    }

    private void fireErrorMarkerClicked(RangeHighlighter marker, MouseEvent e) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ErrorStripeEvent event = new ErrorStripeEvent(this.getEditor(), e, marker);
        for (ErrorStripeListener listener2 : this.myErrorMarkerListeners) {
            listener2.errorMarkerClicked(event);
        }
    }

    @Override
    public void addErrorMarkerListener(@NotNull ErrorStripeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(17);
        }
        ContainerUtil.add((Object)listener2, this.myErrorMarkerListeners, (Disposable)parent);
    }

    private void markDirtied(@NotNull ProperTextRange yPositions) {
        if (yPositions == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(18);
        }
        if (this.myDirtyYPositions != WHOLE_DOCUMENT) {
            int start2 = Math.max(0, yPositions.getStartOffset() - this.myEditor.getLineHeight());
            int end = this.myEditorScrollbarTop + this.myEditorTargetHeight == 0 ? yPositions.getEndOffset() + this.myEditor.getLineHeight() : Math.min(this.myEditorScrollbarTop + this.myEditorTargetHeight, yPositions.getEndOffset() + this.myEditor.getLineHeight());
            ProperTextRange adj = new ProperTextRange(start2, Math.max(end, start2));
            this.myDirtyYPositions = this.myDirtyYPositions == null ? adj : this.myDirtyYPositions.union((TextRange)adj);
        }
        this.myEditorScrollbarTop = 0;
        this.myEditorSourceHeight = 0;
        this.myEditorTargetHeight = 0;
        this.dimensionsAreValid = false;
    }

    @Override
    public void setMinMarkHeight(int minMarkHeight) {
        this.myMinMarkHeight = Math.min(minMarkHeight, EditorMarkupModelImpl.getMaxStripeSize());
    }

    @Override
    public boolean isErrorStripeVisible() {
        return this.getErrorPanel() != null;
    }

    @NotNull
    private ProperTextRange offsetsToYPositions(int start2, int end) {
        int endY;
        if (!this.dimensionsAreValid) {
            this.recalcEditorDimensions();
        }
        DocumentEx document = this.myEditor.getDocument();
        int startLineNumber = end == -1 ? 0 : this.offsetToLine(start2, document);
        int editorStartY = this.myEditor.visualLineToY(startLineNumber);
        int editorTargetHeight = Math.max(0, this.myEditorTargetHeight);
        int startY = this.myEditorSourceHeight < editorTargetHeight ? this.myEditorScrollbarTop + editorStartY : this.myEditorScrollbarTop + (int)((float)editorStartY / (float)this.myEditorSourceHeight * (float)editorTargetHeight);
        int endLineNumber = this.offsetToLine(end, document);
        if (end == -1 || start2 == -1) {
            endY = Math.min(this.myEditorSourceHeight, editorTargetHeight);
        } else if (startLineNumber == endLineNumber) {
            endY = startY;
        } else if (this.myEditorSourceHeight < editorTargetHeight) {
            endY = this.myEditorScrollbarTop + this.myEditor.visualLineToY(endLineNumber);
        } else {
            int editorEndY = this.myEditor.visualLineToY(endLineNumber);
            endY = this.myEditorScrollbarTop + (int)((float)editorEndY / (float)this.myEditorSourceHeight * (float)editorTargetHeight);
        }
        if (endY < startY) {
            endY = startY;
        }
        ProperTextRange properTextRange = new ProperTextRange(startY, endY);
        if (properTextRange == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(19);
        }
        return properTextRange;
    }

    private int yPositionToOffset(int y, boolean beginLine) {
        int editorY;
        if (!this.dimensionsAreValid) {
            this.recalcEditorDimensions();
        }
        int safeY = Math.max(0, y - this.myEditorScrollbarTop);
        if (this.myEditorSourceHeight < this.myEditorTargetHeight) {
            editorY = safeY;
        } else {
            float fraction = Math.max(0.0f, Math.min(1.0f, (float)safeY / (float)this.myEditorTargetHeight));
            editorY = (int)(fraction * (float)this.myEditorSourceHeight);
        }
        VisualPosition visual = this.myEditor.xyToVisualPosition(new Point(0, editorY));
        int line2 = this.myEditor.visualToLogicalPosition((VisualPosition)visual).line;
        DocumentEx document = this.myEditor.getDocument();
        if (line2 < 0) {
            return 0;
        }
        if (line2 >= document.getLineCount()) {
            return document.getTextLength();
        }
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (beginLine) {
            int offset = document.getLineStartOffset(line2);
            FoldRegion startCollapsed = foldingModel.getCollapsedRegionAtOffset(offset);
            return startCollapsed != null ? Math.min(offset, startCollapsed.getStartOffset()) : offset;
        }
        int offset = document.getLineEndOffset(line2);
        FoldRegion startCollapsed = foldingModel.getCollapsedRegionAtOffset(offset);
        return startCollapsed != null ? Math.max(offset, startCollapsed.getEndOffset()) : offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nearest";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 12: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintHint";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yPositions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorStripTooltipRendererProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetsToYPositions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLine";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showToolTipByMouseMove";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineByEvent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectRangeHighlighters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNearestRangeHighlighter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNearestHighlighters";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doClick";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setErrorPanelPopupHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setErrorStripTooltipRendererProvider";
                break;
            }
            case 12: 
            case 13: 
            case 19: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addErrorMarkerListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "markDirtied";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditorFragmentRenderer
    implements TooltipRenderer {
        private int myVisualLine;
        private boolean myShowInstantly;
        private final List<RangeHighlighterEx> myHighlighters = new ArrayList<RangeHighlighterEx>();
        @Nullable
        private BufferedImage myCacheLevel1;
        @Nullable
        private BufferedImage myCacheLevel2;
        private int myCacheStartLine;
        private int myCacheEndLine;
        private int myStartVisualLine;
        private int myEndVisualLine;
        private int myRelativeY;
        private boolean myDelayed;
        private boolean isDirty;
        private final AtomicReference<Point> myPointHolder = new AtomicReference();
        private final AtomicReference<HintHint> myHintHolder = new AtomicReference();

        private EditorFragmentRenderer() {
            this.update(-1, Collections.emptyList(), false);
        }

        void update(int visualLine, @NotNull Collection<? extends RangeHighlighterEx> rangeHighlighters, boolean showInstantly) {
            if (rangeHighlighters == null) {
                EditorFragmentRenderer.$$$reportNull$$$0(0);
            }
            this.myVisualLine = visualLine;
            this.myShowInstantly = showInstantly;
            this.myHighlighters.clear();
            if (this.myVisualLine == -1) {
                return;
            }
            int oldStartLine = this.myStartVisualLine;
            int oldEndLine = this.myEndVisualLine;
            this.myStartVisualLine = EditorMarkupModelImpl.this.fitLineToEditor(this.myVisualLine - myPreviewLines);
            this.myEndVisualLine = EditorMarkupModelImpl.this.fitLineToEditor(this.myVisualLine + myPreviewLines);
            this.isDirty |= oldStartLine != this.myStartVisualLine || oldEndLine != this.myEndVisualLine;
            this.myHighlighters.addAll(rangeHighlighters);
            Collections.sort(this.myHighlighters, (ex1, ex2) -> {
                LogicalPosition startPos1 = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(ex1.getAffectedAreaStartOffset());
                LogicalPosition startPos2 = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(ex2.getAffectedAreaStartOffset());
                if (startPos1.line != startPos2.line) {
                    return 0;
                }
                return startPos1.column - startPos2.column;
            });
        }

        @Override
        @Nullable
        public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintInfo) {
            if (editor == null) {
                EditorFragmentRenderer.$$$reportNull$$$0(1);
            }
            if (p == null) {
                EditorFragmentRenderer.$$$reportNull$$$0(2);
            }
            if (group == null) {
                EditorFragmentRenderer.$$$reportNull$$$0(3);
            }
            if (hintInfo == null) {
                EditorFragmentRenderer.$$$reportNull$$$0(4);
            }
            final int contentInsets = JBUIScale.scale((int)2);
            HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
            boolean needDelay = false;
            if (EditorMarkupModelImpl.this.myEditorPreviewHint == null) {
                needDelay = true;
                JPanel editorFragmentPreviewPanel = new JPanel(){
                    private static final int R = 6;

                    @Override
                    @NotNull
                    public Dimension getPreferredSize() {
                        int width = EditorMarkupModelImpl.this.myEditor.getGutterComponentEx().getWidth() + ((EditorMarkupModelImpl)EditorMarkupModelImpl.this).myEditor.getScrollingModel().getVisibleArea().width - EditorMarkupModelImpl.this.myEditor.getVerticalScrollBar().getWidth();
                        Dimension dimension = new Dimension((width -= JBUIScale.scale((int)1) * 2 + contentInsets) - BalloonImpl.POINTER_LENGTH.get(), Math.min(2 * myPreviewLines * EditorMarkupModelImpl.this.myEditor.getLineHeight(), EditorMarkupModelImpl.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myEndVisualLine) - EditorMarkupModelImpl.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myStartVisualLine)));
                        if (dimension == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return dimension;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void paintComponent(@NotNull Graphics g) {
                        if (g == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (EditorFragmentRenderer.this.myVisualLine == -1 || EditorMarkupModelImpl.this.myEditor.isDisposed()) {
                            return;
                        }
                        Dimension size = this.getPreferredSize();
                        if (size.width <= 0 || size.height <= 0) {
                            return;
                        }
                        EditorGutterComponentImpl gutter = EditorMarkupModelImpl.this.myEditor.getGutterComponentEx();
                        EditorComponentImpl content2 = EditorMarkupModelImpl.this.myEditor.getContentComponent();
                        int gutterWidth = gutter.getWidth();
                        if (EditorFragmentRenderer.this.myCacheLevel2 == null || EditorFragmentRenderer.this.myCacheStartLine > EditorFragmentRenderer.this.myStartVisualLine || EditorFragmentRenderer.this.myCacheEndLine < EditorFragmentRenderer.this.myEndVisualLine) {
                            EditorFragmentRenderer.this.myCacheStartLine = EditorMarkupModelImpl.this.fitLineToEditor(EditorFragmentRenderer.this.myVisualLine - 100);
                            EditorFragmentRenderer.this.myCacheEndLine = EditorMarkupModelImpl.this.fitLineToEditor(EditorFragmentRenderer.this.myCacheStartLine + 200 + 1);
                            int cacheStartY = EditorMarkupModelImpl.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myCacheStartLine);
                            if (EditorFragmentRenderer.this.myCacheLevel2 == null) {
                                EditorFragmentRenderer.this.myCacheLevel2 = UIUtil.createImage((Graphics)g, (int)size.width, (int)(EditorMarkupModelImpl.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myCacheEndLine) - cacheStartY + EditorMarkupModelImpl.this.myEditor.getLineHeight()), (int)1);
                            }
                            Graphics2D cg = EditorFragmentRenderer.this.myCacheLevel2.createGraphics();
                            AffineTransform t = cg.getTransform();
                            EditorUIUtil.setupAntialiasing(cg);
                            int lineShift = -cacheStartY;
                            int shift = JBUIScale.scale((int)1) + contentInsets;
                            AffineTransform gutterAT = AffineTransform.getTranslateInstance(-shift, lineShift);
                            AffineTransform contentAT = AffineTransform.getTranslateInstance(gutterWidth - shift, lineShift);
                            gutterAT.preConcatenate(t);
                            contentAT.preConcatenate(t);
                            EditorTextField.SUPPLEMENTARY_KEY.set((UserDataHolder)EditorMarkupModelImpl.this.myEditor, (Object)Boolean.TRUE);
                            try {
                                cg.setTransform(gutterAT);
                                cg.setClip(0, -lineShift, gutterWidth, EditorFragmentRenderer.this.myCacheLevel2.getHeight());
                                gutter.paint(cg);
                                cg.setTransform(contentAT);
                                cg.setClip(0, -lineShift, content2.getWidth(), EditorFragmentRenderer.this.myCacheLevel2.getHeight());
                                content2.paint(cg);
                            }
                            finally {
                                EditorTextField.SUPPLEMENTARY_KEY.set((UserDataHolder)EditorMarkupModelImpl.this.myEditor, null);
                            }
                        }
                        if (EditorFragmentRenderer.this.myCacheLevel1 == null) {
                            EditorFragmentRenderer.this.myCacheLevel1 = UIUtil.createImage((Graphics)g, (int)size.width, (int)(EditorMarkupModelImpl.this.myEditor.getLineHeight() * (2 * myPreviewLines + 1)), (int)1);
                            EditorFragmentRenderer.this.isDirty = true;
                        }
                        if (EditorFragmentRenderer.this.isDirty) {
                            EditorFragmentRenderer.this.myRelativeY = SwingUtilities.convertPoint((Component)this, (int)0, (int)0, (Component)((EditorMarkupModelImpl)EditorMarkupModelImpl.this).myEditor.getScrollPane()).y;
                            Graphics2D g2d = EditorFragmentRenderer.this.myCacheLevel1.createGraphics();
                            AffineTransform transform = g2d.getTransform();
                            EditorUIUtil.setupAntialiasing(g2d);
                            GraphicsUtil.setupAAPainting((Graphics)g2d);
                            g2d.setColor(EditorMarkupModelImpl.this.myEditor.getBackgroundColor());
                            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                            int topDisplayedY = Math.max(EditorMarkupModelImpl.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myStartVisualLine), EditorMarkupModelImpl.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myVisualLine) - myPreviewLines * EditorMarkupModelImpl.this.myEditor.getLineHeight());
                            int cacheStartY = EditorMarkupModelImpl.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myCacheStartLine);
                            AffineTransform translateInstance = AffineTransform.getTranslateInstance(gutterWidth, cacheStartY - topDisplayedY);
                            translateInstance.preConcatenate(transform);
                            g2d.setTransform(translateInstance);
                            UIUtil.drawImage((Graphics)g2d, (Image)EditorFragmentRenderer.this.myCacheLevel2, (int)(-gutterWidth), (int)0, null);
                            TIntIntHashMap rightEdges = new TIntIntHashMap();
                            int h = EditorMarkupModelImpl.this.myEditor.getLineHeight() - 2;
                            for (RangeHighlighterEx ex : EditorFragmentRenderer.this.myHighlighters) {
                                String s;
                                if (!ex.isValid()) continue;
                                int hEndOffset = ex.getAffectedAreaEndOffset();
                                Object tooltip = ex.getErrorStripeTooltip();
                                if (tooltip == null) continue;
                                String string = s = tooltip instanceof HighlightInfo ? ((HighlightInfo)tooltip).getDescription() : String.valueOf(tooltip);
                                if (StringUtil.isEmpty((String)s)) continue;
                                s = s.replaceAll("&nbsp;", " ").replaceAll("\\s+", " ");
                                s = StringUtil.unescapeXmlEntities((String)s);
                                LogicalPosition logicalPosition = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(hEndOffset);
                                int endOfLineOffset = EditorMarkupModelImpl.this.myEditor.getDocument().getLineEndOffset(logicalPosition.line);
                                logicalPosition = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(endOfLineOffset);
                                Point placeToShow = EditorMarkupModelImpl.this.myEditor.logicalPositionToXY(logicalPosition);
                                logicalPosition = EditorMarkupModelImpl.this.myEditor.xyToLogicalPosition(placeToShow);
                                placeToShow.x += 9;
                                placeToShow.y -= cacheStartY - 1;
                                Font font = EditorMarkupModelImpl.this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
                                g2d.setFont(font.deriveFont((float)font.getSize() * 0.8f));
                                int w = g2d.getFontMetrics().stringWidth(s);
                                int rightEdge = rightEdges.get(logicalPosition.line);
                                placeToShow.x = Math.max(placeToShow.x, rightEdge);
                                rightEdge = Math.max(rightEdge, placeToShow.x + w + 18);
                                rightEdges.put(logicalPosition.line, rightEdge);
                                g2d.setColor(MessageType.WARNING.getPopupBackground());
                                g2d.fillRoundRect(placeToShow.x, placeToShow.y, w + 12, h, 6, 6);
                                g2d.setColor((Color)new JBColor((Color)JBColor.GRAY, (Color)Gray._200));
                                g2d.drawRoundRect(placeToShow.x, placeToShow.y, w + 12, h, 6, 6);
                                g2d.setColor(JBColor.foreground());
                                g2d.drawString(s, placeToShow.x + 6, placeToShow.y + h - g2d.getFontMetrics(g2d.getFont()).getDescent() / 2 - 2);
                            }
                            EditorFragmentRenderer.this.isDirty = false;
                        }
                        Graphics2D g2 = (Graphics2D)g.create();
                        try {
                            GraphicsUtil.setupAAPainting((Graphics)g2);
                            g2.setClip(new RoundRectangle2D.Double(0.0, 0.0, (double)size.width - 0.5, (double)size.height - 0.5, 2.0, 2.0));
                            UIUtil.drawImage((Graphics)g2, (Image)EditorFragmentRenderer.this.myCacheLevel1, (int)0, (int)0, (ImageObserver)this);
                            if (UIUtil.isUnderDarcula()) {
                                Rectangle s = new Rectangle(0, 0, size.width, size.height);
                                double cx = size.width / 2;
                                double rx = size.width / 10;
                                int ry = EditorMarkupModelImpl.this.myEditor.getLineHeight() * 3 / 2;
                                g2.setPaint(new GradientPaint(0.0f, 0.0f, Gray._255.withAlpha(75), 0.0f, ry, Gray._255.withAlpha(10)));
                                double pseudoMajorAxis = (double)size.width - rx * 9.0 / 5.0;
                                double cy = 0.0;
                                Ellipse2D.Double topShape1 = new Ellipse2D.Double(cx - rx - pseudoMajorAxis / 2.0, cy - (double)ry, 2.0 * rx, 2 * ry);
                                Ellipse2D.Double topShape2 = new Ellipse2D.Double(cx - rx + pseudoMajorAxis / 2.0, cy - (double)ry, 2.0 * rx, 2 * ry);
                                Area topArea = new Area(topShape1);
                                topArea.add(new Area(topShape2));
                                topArea.add(new Area(new Rectangle2D.Double(cx - pseudoMajorAxis / 2.0, cy, pseudoMajorAxis, ry)));
                                g2.fill(topArea);
                                Area bottomArea = new Area(s);
                                bottomArea.subtract(topArea);
                                g2.setPaint(new GradientPaint(0.0f, size.height - ry, Gray._0.withAlpha(10), 0.0f, size.height, Gray._255.withAlpha(30)));
                                g2.fill(bottomArea);
                            }
                        }
                        finally {
                            g2.dispose();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "g";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getPreferredSize";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "paintComponent";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                editorFragmentPreviewPanel.putClientProperty(BalloonImpl.FORCED_NO_SHADOW, Boolean.TRUE);
                EditorMarkupModelImpl.this.myEditorPreviewHint = new LightweightHint(editorFragmentPreviewPanel){

                    @Override
                    public void hide(boolean ok) {
                        super.hide(ok);
                        EditorFragmentRenderer.this.myCacheLevel1 = null;
                        if (EditorFragmentRenderer.this.myCacheLevel2 != null) {
                            EditorFragmentRenderer.this.myCacheLevel2 = null;
                            EditorFragmentRenderer.this.myCacheStartLine = -1;
                            EditorFragmentRenderer.this.myCacheEndLine = -1;
                        }
                        EditorFragmentRenderer.this.myDelayed = false;
                    }
                };
                EditorMarkupModelImpl.this.myEditorPreviewHint.setForceLightweightPopup(true);
            }
            Point point = new Point(hintInfo.getOriginalPoint());
            hintInfo.setTextBg(EditorMarkupModelImpl.this.myEditor.getBackgroundColor());
            Color borderColor = EditorMarkupModelImpl.this.myEditor.getColorsScheme().getAttributes(EditorColors.CODE_LENS_BORDER_COLOR).getEffectColor();
            hintInfo.setBorderColor(borderColor != null ? borderColor : EditorMarkupModelImpl.this.myEditor.getColorsScheme().getDefaultForeground());
            point = SwingUtilities.convertPoint((Component)((Object)((EditorImpl)editor).getVerticalScrollBar()), point, EditorMarkupModelImpl.this.myEditor.getComponent().getRootPane());
            this.myPointHolder.set(point);
            this.myHintHolder.set(hintInfo);
            if (needDelay && !this.myShowInstantly) {
                this.myDelayed = true;
                Alarm alarm = new Alarm();
                alarm.addRequest(() -> {
                    if (EditorMarkupModelImpl.this.myEditorPreviewHint == null || !this.myDelayed) {
                        return;
                    }
                    this.showEditorHint(hintManager, this.myPointHolder.get(), this.myHintHolder.get());
                    this.myDelayed = false;
                }, 300);
            } else if (!this.myDelayed) {
                this.showEditorHint(hintManager, point, hintInfo);
            }
            return EditorMarkupModelImpl.this.myEditorPreviewHint;
        }

        private void showEditorHint(@NotNull HintManagerImpl hintManager, @NotNull Point point, HintHint hintInfo) {
            if (hintManager == null) {
                EditorFragmentRenderer.$$$reportNull$$$0(5);
            }
            if (point == null) {
                EditorFragmentRenderer.$$$reportNull$$$0(6);
            }
            int flags = 299;
            hintManager.showEditorHint(EditorMarkupModelImpl.this.myEditorPreviewHint, (Editor)EditorMarkupModelImpl.this.myEditor, point, flags, 0, false, hintInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeHighlighters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintInfo";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintManager";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "show";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showEditorHint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BasicTooltipRendererProvider
    implements ErrorStripTooltipRendererProvider {
        private BasicTooltipRendererProvider() {
        }

        @Override
        public TooltipRenderer calcTooltipRenderer(@NotNull Collection<? extends RangeHighlighter> highlighters) {
            if (highlighters == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(0);
            }
            LineTooltipRenderer bigRenderer = null;
            Set tooltips = null;
            for (RangeHighlighter rangeHighlighter : highlighters) {
                String text2;
                Object tooltipObject = rangeHighlighter.getErrorStripeTooltip();
                if (tooltipObject == null || (text2 = tooltipObject instanceof HighlightInfo ? ((HighlightInfo)tooltipObject).getToolTip() : tooltipObject.toString()) == null) continue;
                if (tooltips == null) {
                    tooltips = new THashSet();
                }
                if (!tooltips.add(text2)) continue;
                if (bigRenderer == null) {
                    bigRenderer = new LineTooltipRenderer(text2, new Object[]{highlighters});
                    continue;
                }
                bigRenderer.addBelow(text2);
            }
            return bigRenderer;
        }

        @Override
        @NotNull
        public TooltipRenderer calcTooltipRenderer(@NotNull String text2) {
            if (text2 == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(1);
            }
            LineTooltipRenderer lineTooltipRenderer = new LineTooltipRenderer(text2, new Object[]{text2});
            if (lineTooltipRenderer == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(2);
            }
            return lineTooltipRenderer;
        }

        @Override
        @NotNull
        public TooltipRenderer calcTooltipRenderer(@NotNull String text2, int width) {
            if (text2 == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(3);
            }
            LineTooltipRenderer lineTooltipRenderer = new LineTooltipRenderer(text2, width, new Object[]{text2});
            if (lineTooltipRenderer == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(4);
            }
            return lineTooltipRenderer;
        }

        @Override
        @NotNull
        public TrafficTooltipRenderer createTrafficTooltipRenderer(final @NotNull Runnable onHide, @NotNull Editor editor) {
            if (onHide == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(5);
            }
            if (editor == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(6);
            }
            TrafficTooltipRenderer trafficTooltipRenderer = new TrafficTooltipRenderer(){

                @Override
                public void repaintTooltipWindow() {
                }

                @Override
                @NotNull
                public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
                    if (editor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (p == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (group == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (hintHint == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    JLabel label2 = new JLabel("WTF");
                    LightweightHint lightweightHint = new LightweightHint(label2){

                        @Override
                        public void hide() {
                            super.hide();
                            onHide.run();
                        }
                    };
                    if (lightweightHint == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return lightweightHint;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 4: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 4: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "editor";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "p";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "group";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "hintHint";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "show";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "show";
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 4: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            if (trafficTooltipRenderer == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(7);
            }
            return trafficTooltipRenderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighters";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onHide";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcTooltipRenderer";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTrafficTooltipRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "calcTooltipRenderer";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createTrafficTooltipRenderer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyErrorPanel
    extends ButtonlessScrollBarUI
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    UISettingsListener {
        private PopupHandler myHandler;
        private JButton myErrorStripeButton;
        @Nullable
        private BufferedImage myCachedTrack;
        private int myCachedHeight = -1;
        @Nullable
        private TrafficTooltipRenderer myTrafficTooltipRenderer;

        private MyErrorPanel() {
        }

        public void dropCache() {
            this.myCachedTrack = null;
            this.myCachedHeight = -1;
        }

        @NotNull
        protected JButton createDecreaseButton(int orientation) {
            JButton jButton = this.myErrorStripeButton = EditorMarkupModelImpl.this.myErrorStripeRenderer == null ? super.createDecreaseButton(orientation) : new ErrorStripeButton();
            if (jButton == null) {
                MyErrorPanel.$$$reportNull$$$0(0);
            }
            return jButton;
        }

        public boolean alwaysShowTrack() {
            if (this.scrollbar.getOrientation() == 1) {
                return !EditorMarkupModelImpl.this.transparent();
            }
            return super.alwaysShowTrack();
        }

        public void installUI(JComponent c2) {
            super.installUI(c2);
            this.dropCache();
        }

        public void uninstallUI(@NotNull JComponent c2) {
            if (c2 == null) {
                MyErrorPanel.$$$reportNull$$$0(1);
            }
            super.uninstallUI(c2);
            this.dropCache();
        }

        protected void installListeners() {
            super.installListeners();
            this.scrollbar.addMouseMotionListener(this);
            this.scrollbar.addMouseListener(this);
            this.scrollbar.addMouseWheelListener(this);
            this.myErrorStripeButton.addMouseMotionListener(this);
            this.myErrorStripeButton.addMouseListener(this);
        }

        protected void uninstallListeners() {
            this.scrollbar.removeMouseMotionListener(this);
            this.scrollbar.removeMouseListener(this);
            this.myErrorStripeButton.removeMouseMotionListener(this);
            this.myErrorStripeButton.removeMouseListener(this);
            super.uninstallListeners();
        }

        public void uiSettingsChanged(UISettings uiSettings) {
            if (!uiSettings.getShowEditorToolTip()) {
                this.hideMyEditorPreviewHint();
            }
            EditorMarkupModelImpl.this.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().getErrorStripeMarkMinHeight());
            this.repaintTrafficTooltip();
            EditorMarkupModelImpl.this.repaintTrafficLightIcon();
            EditorMarkupModelImpl.this.repaintVerticalScrollBar();
        }

        protected void paintThumb(@NotNull Graphics g, @NotNull JComponent c2, Rectangle thumbBounds) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(2);
            }
            if (c2 == null) {
                MyErrorPanel.$$$reportNull$$$0(3);
            }
            if (this.isMacOverlayScrollbar()) {
                if (!EditorMarkupModelImpl.this.isMirrored()) {
                    super.paintThumb(g, c2, thumbBounds);
                } else {
                    Graphics2D g2d = (Graphics2D)g;
                    AffineTransform old = g2d.getTransform();
                    AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                    tx.translate(-c2.getWidth(), 0.0);
                    g2d.transform(tx);
                    super.paintThumb(g, c2, thumbBounds);
                    g2d.setTransform(old);
                }
            } else {
                super.paintThumb(g, c2, thumbBounds);
            }
        }

        protected boolean isThumbTranslucent() {
            return true;
        }

        protected int getThumbOffset(int value) {
            if (SystemInfo.isMac || Registry.is((String)"editor.full.width.scrollbar")) {
                return EditorMarkupModelImpl.this.getMinMarkHeight() + JBUIScale.scale((int)2);
            }
            return super.getThumbOffset(value);
        }

        protected boolean isDark() {
            return EditorMarkupModelImpl.this.myEditor.isDarkEnough();
        }

        protected boolean alwaysPaintThumb() {
            return true;
        }

        protected Rectangle getMacScrollBarBounds(Rectangle baseBounds, boolean thumb) {
            Rectangle bounds2 = super.getMacScrollBarBounds(baseBounds, thumb);
            bounds2.width = Math.min(bounds2.width, EditorMarkupModelImpl.getMaxMacThumbWidth());
            int b2 = bounds2.width / 2;
            bounds2.x = EditorMarkupModelImpl.getThinGap() + EditorMarkupModelImpl.this.getMinMarkHeight() + EditorMarkupModelImpl.getErrorIconWidth() / 2 - b2;
            return bounds2;
        }

        protected int getThickness() {
            return EditorMarkupModelImpl.getErrorIconWidth() + EditorMarkupModelImpl.getThinGap() + EditorMarkupModelImpl.this.getMinMarkHeight();
        }

        protected void paintTrack(@NotNull Graphics g, @NotNull JComponent c2, @NotNull Rectangle trackBounds) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(4);
            }
            if (c2 == null) {
                MyErrorPanel.$$$reportNull$$$0(5);
            }
            if (trackBounds == null) {
                MyErrorPanel.$$$reportNull$$$0(6);
            }
            if (EditorMarkupModelImpl.this.myEditor.isDisposed()) {
                return;
            }
            if (EditorMarkupModelImpl.this.transparent()) {
                this.doPaintTrack(g, c2, trackBounds);
            } else {
                super.paintTrack(g, c2, trackBounds);
            }
        }

        protected void doPaintTrack(@NotNull Graphics g, @NotNull JComponent c2, @NotNull Rectangle bounds2) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(7);
            }
            if (c2 == null) {
                MyErrorPanel.$$$reportNull$$$0(8);
            }
            if (bounds2 == null) {
                MyErrorPanel.$$$reportNull$$$0(9);
            }
            Rectangle clip = g.getClipBounds().intersection(bounds2);
            if (clip.height == 0) {
                return;
            }
            Rectangle componentBounds = c2.getBounds();
            ProperTextRange docRange = ProperTextRange.create((int)0, (int)componentBounds.height);
            if (this.myCachedTrack == null || this.myCachedHeight != componentBounds.height) {
                this.myCachedTrack = UIUtil.createImage((Component)c2, (int)componentBounds.width, (int)componentBounds.height, (int)2);
                this.myCachedHeight = componentBounds.height;
                EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
                EditorMarkupModelImpl.this.dimensionsAreValid = false;
                this.paintTrackBasement(this.myCachedTrack.getGraphics(), new Rectangle(0, 0, componentBounds.width, componentBounds.height));
            }
            if (EditorMarkupModelImpl.this.myDirtyYPositions == WHOLE_DOCUMENT) {
                EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
            }
            if (EditorMarkupModelImpl.this.myDirtyYPositions != null) {
                Graphics2D imageGraphics = this.myCachedTrack.createGraphics();
                EditorMarkupModelImpl.this.myDirtyYPositions = EditorMarkupModelImpl.this.myDirtyYPositions.intersection((TextRange)docRange);
                if (EditorMarkupModelImpl.this.myDirtyYPositions == null) {
                    EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
                }
                this.repaint(imageGraphics, componentBounds.width, EditorMarkupModelImpl.this.myDirtyYPositions);
                EditorMarkupModelImpl.this.myDirtyYPositions = null;
            }
            UIUtil.drawImage((Graphics)g, (BufferedImage)this.myCachedTrack, null, (int)0, (int)0);
        }

        private void paintTrackBasement(@NotNull Graphics g, @NotNull Rectangle bounds2) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(10);
            }
            if (bounds2 == null) {
                MyErrorPanel.$$$reportNull$$$0(11);
            }
            if (EditorMarkupModelImpl.this.transparent()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setComposite(AlphaComposite.getInstance(1));
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                g2.setComposite(AlphaComposite.getInstance(3));
            } else {
                g.setColor(EditorMarkupModelImpl.this.myEditor.getBackgroundColor());
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            }
        }

        @NotNull
        protected Color adjustColor(Color c2) {
            Color color = this.isMacOverlayScrollbar() ? super.adjustColor(c2) : EditorImpl.adjustThumbColor(super.adjustColor(c2), this.isDark());
            if (color == null) {
                MyErrorPanel.$$$reportNull$$$0(12);
            }
            return color;
        }

        private void repaint(@NotNull Graphics g, int gutterWidth, @NotNull ProperTextRange yrange) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(13);
            }
            if (yrange == null) {
                MyErrorPanel.$$$reportNull$$$0(14);
            }
            Rectangle clip = new Rectangle(0, yrange.getStartOffset(), gutterWidth, yrange.getLength() + EditorMarkupModelImpl.this.getMinMarkHeight());
            this.paintTrackBasement(g, clip);
            int startOffset = EditorMarkupModelImpl.this.yPositionToOffset(clip.y - EditorMarkupModelImpl.this.getMinMarkHeight(), true);
            int endOffset = EditorMarkupModelImpl.this.yPositionToOffset(clip.y + clip.height, false);
            Shape oldClip = g.getClip();
            g.clipRect(clip.x, clip.y, clip.width, clip.height);
            this.drawMarkup(g, startOffset, endOffset, EditorMarkupModelImpl.this.myEditor.getFilteredDocumentMarkupModel(), EditorMarkupModelImpl.this);
            g.setClip(oldClip);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawMarkup(@NotNull Graphics g, int startOffset, int endOffset, @NotNull MarkupModelEx markup1, @NotNull MarkupModelEx markup2) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(15);
            }
            if (markup1 == null) {
                MyErrorPanel.$$$reportNull$$$0(16);
            }
            if (markup2 == null) {
                MyErrorPanel.$$$reportNull$$$0(17);
            }
            PriorityQueue<PositionedStripe> thinEnds = new PriorityQueue<PositionedStripe>(5, Comparator.comparingInt(o -> ((PositionedStripe)o).yEnd));
            PriorityQueue<PositionedStripe> wideEnds = new PriorityQueue<PositionedStripe>(5, Comparator.comparingInt(o -> ((PositionedStripe)o).yEnd));
            ArrayList<PositionedStripe> thinStripes = new ArrayList<PositionedStripe>();
            ArrayList<PositionedStripe> wideStripes = new ArrayList<PositionedStripe>();
            int[] thinYStart = new int[1];
            int[] wideYStart = new int[1];
            MarkupIterator<RangeHighlighterEx> iterator1 = markup1.overlappingIterator(startOffset, endOffset);
            MarkupIterator<RangeHighlighterEx> iterator2 = markup2.overlappingIterator(startOffset, endOffset);
            MarkupIterator<RangeHighlighterEx> iterator = MarkupIterator.mergeIterators(iterator1, iterator2, RangeHighlighterEx.BY_AFFECTED_START_OFFSET);
            try {
                ContainerUtil.process(iterator, highlighter -> {
                    int i;
                    Color color = highlighter.getErrorStripeMarkColor();
                    if (color == null) {
                        return true;
                    }
                    boolean isThin = highlighter.isThinErrorStripeMark();
                    int[] yStart = isThin ? thinYStart : wideYStart;
                    List stripes = isThin ? thinStripes : wideStripes;
                    Queue ends = isThin ? thinEnds : wideEnds;
                    ProperTextRange range2 = EditorMarkupModelImpl.this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset());
                    int ys = range2.getStartOffset();
                    int ye = range2.getEndOffset();
                    if (ye - ys < EditorMarkupModelImpl.this.getMinMarkHeight()) {
                        ye = ys + EditorMarkupModelImpl.this.getMinMarkHeight();
                    }
                    yStart[0] = this.drawStripesEndingBefore(ys, ends, stripes, g, yStart[0]);
                    int layer = highlighter.getLayer();
                    PositionedStripe stripe = null;
                    for (i = 0; i < stripes.size(); ++i) {
                        PositionedStripe s = (PositionedStripe)stripes.get(i);
                        if (s.layer == layer) {
                            stripe = s;
                            break;
                        }
                        if (s.layer < layer) break;
                    }
                    if (stripe == null) {
                        if (i == 0 && yStart[0] != ys) {
                            if (!stripes.isEmpty()) {
                                PositionedStripe top = (PositionedStripe)stripes.get(0);
                                this.drawSpot(g, top.thin, yStart[0], ys, top.color);
                            }
                            yStart[0] = ys;
                        }
                        stripe = new PositionedStripe(color, ye, isThin, layer);
                        stripes.add(i, stripe);
                        ends.offer(stripe);
                    } else if (stripe.yEnd < ye) {
                        if (!color.equals(stripe.color)) {
                            if (i == 0 && yStart[0] != ys) {
                                this.drawSpot(g, stripe.thin, yStart[0], ys, stripe.color);
                                yStart[0] = ys;
                            }
                            stripe.color = color;
                        }
                        ends.remove(stripe);
                        stripe.yEnd = ye;
                        ends.offer(stripe);
                    }
                    return true;
                });
            }
            finally {
                iterator.dispose();
            }
            this.drawStripesEndingBefore(Integer.MAX_VALUE, thinEnds, thinStripes, g, thinYStart[0]);
            this.drawStripesEndingBefore(Integer.MAX_VALUE, wideEnds, wideStripes, g, wideYStart[0]);
        }

        private int drawStripesEndingBefore(int ys, @NotNull Queue<? extends PositionedStripe> ends, @NotNull List<PositionedStripe> stripes, @NotNull Graphics g, int yStart) {
            PositionedStripe endingStripe;
            if (ends == null) {
                MyErrorPanel.$$$reportNull$$$0(18);
            }
            if (stripes == null) {
                MyErrorPanel.$$$reportNull$$$0(19);
            }
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(20);
            }
            while (!ends.isEmpty() && (endingStripe = ends.peek()) != null && endingStripe.yEnd <= ys) {
                ends.remove();
                int i = stripes.indexOf(endingStripe);
                stripes.remove(i);
                if (i != 0) continue;
                this.drawSpot(g, endingStripe.thin, yStart, endingStripe.yEnd, endingStripe.color);
                yStart = endingStripe.yEnd;
            }
            return yStart;
        }

        private void drawSpot(@NotNull Graphics g, boolean thinErrorStripeMark, int yStart, int yEnd, @NotNull Color color) {
            int x;
            int paintWidth;
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(21);
            }
            if (color == null) {
                MyErrorPanel.$$$reportNull$$$0(22);
            }
            if (thinErrorStripeMark) {
                paintWidth = EditorMarkupModelImpl.this.getMinMarkHeight();
                int n = x = EditorMarkupModelImpl.this.isMirrored() ? this.getThickness() - paintWidth : 0;
                if (yEnd - yStart < 6) {
                    yEnd += yEnd - --yStart - 1;
                }
            } else {
                x = EditorMarkupModelImpl.this.isMirrored() ? 0 : EditorMarkupModelImpl.this.getMinMarkHeight() + EditorMarkupModelImpl.getThinGap();
                paintWidth = EditorMarkupModelImpl.getErrorIconWidth();
            }
            g.setColor(color);
            g.fillRect(x, yStart, paintWidth, yEnd - yStart);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(23);
            }
            CommandProcessor.getInstance().executeCommand(EditorMarkupModelImpl.this.myEditor.getProject(), () -> this.doMouseClicked(e), EditorBundle.message((String)"move.caret.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorMarkupModelImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, EditorMarkupModelImpl.this.getDocument());
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(24);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(25);
            }
        }

        private int getWidth() {
            return this.scrollbar.getWidth();
        }

        private void doMouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(26);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)EditorMarkupModelImpl.this.myEditor.getContentComponent(), true));
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getX() > 0 && e.getX() <= this.getWidth()) {
                EditorMarkupModelImpl.this.doClick(e);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(27);
            }
            EditorImpl.MyScrollBar scrollBar = EditorMarkupModelImpl.this.myEditor.getVerticalScrollBar();
            int buttonHeight = scrollBar.getDecScrollButtonHeight();
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getY() < buttonHeight && EditorMarkupModelImpl.this.myErrorStripeRenderer != null) {
                this.showTrafficLightTooltip(e);
                return;
            }
            if (e.getX() > 0 && e.getX() <= this.getWidth() && EditorMarkupModelImpl.this.showToolTipByMouseMove(e)) {
                UIUtil.setCursor((Component)this.scrollbar, (Cursor)Cursor.getPredefinedCursor(12));
                return;
            }
            this.cancelMyToolTips(e, false);
            if (this.scrollbar.getCursor().equals(Cursor.getPredefinedCursor(12))) {
                this.scrollbar.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(28);
            }
            if (EditorMarkupModelImpl.this.myEditorPreviewHint == null) {
                return;
            }
            int units = e.getUnitsToScroll();
            if (units == 0) {
                return;
            }
            if (EditorMarkupModelImpl.this.myLastVisualLine < EditorMarkupModelImpl.this.myEditor.getVisibleLineCount() - 1 && units > 0 || EditorMarkupModelImpl.this.myLastVisualLine > 0 && units < 0) {
                EditorMarkupModelImpl.this.myWheelAccumulator = EditorMarkupModelImpl.this.myWheelAccumulator + units;
            }
            EditorMarkupModelImpl.this.myRowAdjuster = EditorMarkupModelImpl.this.myWheelAccumulator / EditorMarkupModelImpl.this.myEditor.getLineHeight();
            EditorMarkupModelImpl.this.showToolTipByMouseMove(e);
        }

        private void showTrafficLightTooltip(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(29);
            }
            if (this.myTrafficTooltipRenderer == null) {
                this.myTrafficTooltipRenderer = EditorMarkupModelImpl.this.myTooltipRendererProvider.createTrafficTooltipRenderer(() -> {
                    this.myTrafficTooltipRenderer = null;
                }, EditorMarkupModelImpl.this.myEditor);
            }
            EditorMarkupModelImpl.this.showTooltip(e, this.myTrafficTooltipRenderer, new HintHint(e).setAwtTooltip(true).setMayCenterPosition(true).setContentActive(false).setPreferredPosition(Balloon.Position.atLeft));
        }

        private void repaintTrafficTooltip() {
            if (this.myTrafficTooltipRenderer != null) {
                this.myTrafficTooltipRenderer.repaintTooltipWindow();
            }
        }

        private void cancelMyToolTips(MouseEvent e, boolean checkIfShouldSurvive) {
            this.hideMyEditorPreviewHint();
            TooltipController tooltipController = TooltipController.getInstance();
            if (!checkIfShouldSurvive || !tooltipController.shouldSurvive(e)) {
                tooltipController.cancelTooltip(ERROR_STRIPE_TOOLTIP_GROUP, e, true);
            }
        }

        private void hideMyEditorPreviewHint() {
            if (EditorMarkupModelImpl.this.myEditorPreviewHint != null) {
                EditorMarkupModelImpl.this.myEditorPreviewHint.hide();
                EditorMarkupModelImpl.this.myEditorPreviewHint = null;
                EditorMarkupModelImpl.this.myRowAdjuster = 0;
                EditorMarkupModelImpl.this.myWheelAccumulator = 0;
                EditorMarkupModelImpl.this.myLastVisualLine = 0;
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(30);
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(31);
            }
            this.cancelMyToolTips(e, true);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(32);
            }
            this.cancelMyToolTips(e, true);
        }

        private void setPopupHandler(@NotNull PopupHandler handler2) {
            if (handler2 == null) {
                MyErrorPanel.$$$reportNull$$$0(33);
            }
            if (this.myHandler != null) {
                this.scrollbar.removeMouseListener((MouseListener)this.myHandler);
                this.myErrorStripeButton.removeMouseListener((MouseListener)this.myHandler);
            }
            this.myHandler = handler2;
            this.scrollbar.addMouseListener((MouseListener)handler2);
            this.myErrorStripeButton.addMouseListener((MouseListener)this.myHandler);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 10: 
                case 13: 
                case 15: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trackBounds";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yrange";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markup1";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markup2";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ends";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stripes";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDecreaseButton";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "uninstallUI";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "paintThumb";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "paintTrack";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "doPaintTrack";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "paintTrackBasement";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "repaint";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "drawMarkup";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "drawStripesEndingBefore";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "drawSpot";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseClicked";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "mousePressed";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseReleased";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "doMouseClicked";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseMoved";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseWheelMoved";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "showTrafficLightTooltip";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseEntered";
                    break;
                }
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseExited";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseDragged";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "setPopupHandler";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ErrorStripeButton
    extends JButton {
        private ErrorStripeButton() {
            this.setFocusable(false);
            this.setOpaque(false);
        }

        @Override
        public void paint(@NotNull Graphics g) {
            if (g == null) {
                ErrorStripeButton.$$$reportNull$$$0(0);
            }
            if (!EditorMarkupModelImpl.this.transparent()) {
                g.setColor(EditorMarkupModelImpl.this.myEditor.getBackgroundColor());
                Rectangle bounds2 = this.getBounds();
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            }
            if (EditorMarkupModelImpl.this.myErrorStripeRenderer != null) {
                int x = EditorMarkupModelImpl.this.isMirrored() ? 0 : EditorMarkupModelImpl.getThinGap() + EditorMarkupModelImpl.this.getMinMarkHeight();
                Rectangle b = new Rectangle(x, 0, EditorMarkupModelImpl.getErrorIconWidth(), EditorMarkupModelImpl.getErrorIconHeight());
                EditorMarkupModelImpl.this.myErrorStripeRenderer.paint((Component)this, g, b);
            }
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension = !this.isPreferredSizeSet() ? (this.isVisible() ? new Dimension(EditorMarkupModelImpl.getErrorIconWidth() + EditorMarkupModelImpl.getThinGap(), EditorMarkupModelImpl.getErrorIconHeight() + EditorMarkupModelImpl.getThinGap()) : JBUI.emptySize()) : super.getPreferredSize();
            if (dimension == null) {
                ErrorStripeButton.$$$reportNull$$$0(1);
            }
            return dimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$ErrorStripeButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$ErrorStripeButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PositionedStripe {
        @NotNull
        private Color color;
        private int yEnd;
        private final boolean thin;
        private final int layer;

        private PositionedStripe(@NotNull Color color, int yEnd, boolean thin, int layer) {
            if (color == null) {
                PositionedStripe.$$$reportNull$$$0(0);
            }
            this.color = color;
            this.yEnd = yEnd;
            this.thin = thin;
            this.layer = layer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$PositionedStripe", "<init>"));
        }
    }
}

